/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.definition;

import java.util.HashMap;
import nc.vo.ml.NCLangRes4VoTransl;

public enum ActivityTypeEnum {
    Makebill(0, "MAKEBILL_ID"),
    Checkbill(1, "CHECKBILL_ID"),
    Subflow(2, "SUBFLOW_ID"),
    Route(3, "ROUTE_ID"),
    Auto(4, "AUTO_ID"),
    Manual(5, "MANUAL_ID"),
    Other(99, "OTHER_ID");

    private int intValue;
    private String tag;
    private static HashMap<String, ActivityTypeEnum> hm;

    static void initStatic(ActivityTypeEnum at) {
        hm.put(at.getTag(), at);
    }

    private ActivityTypeEnum(int intValue, String tag) {
        this.intValue = intValue;
        this.tag = tag;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getTag() {
        return this.tag;
    }

    public static ActivityTypeEnum fromTag(String tag) {
        return hm.get(tag);
    }

    public static ActivityTypeEnum fromIntValue(int intValue) {
        switch (intValue) {
            case 0: {
                return Makebill;
            }
            case 1: {
                return Checkbill;
            }
            case 2: {
                return Subflow;
            }
            case 3: {
                return Route;
            }
            case 4: {
                return Auto;
            }
            case 5: {
                return Manual;
            }
            case 99: {
                return Other;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.getIntValue()) {
            case 0: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000614");
            }
            case 1: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC001-0000027");
            }
            case 2: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000303");
            }
            case 3: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000305");
            }
            case 4: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "ActivityTypeEnum-000000");
            }
            case 5: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "ActivityTypeEnum-000001");
            }
            case 99: {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "ActivityTypeEnum-000002");
            }
        }
        return "UnknownStatus";
    }

    static {
        hm = new HashMap();
        ActivityTypeEnum.initStatic(Makebill);
        ActivityTypeEnum.initStatic(Checkbill);
        ActivityTypeEnum.initStatic(Subflow);
        ActivityTypeEnum.initStatic(Route);
        ActivityTypeEnum.initStatic(Auto);
        ActivityTypeEnum.initStatic(Manual);
        ActivityTypeEnum.initStatic(Other);
    }
}

