/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.workflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.uap.pf.IWorkflowDefine;
import nc.vo.wfengine.core.AbstractWFElement;
import nc.vo.wfengine.core.AccessLevel;
import nc.vo.wfengine.core.RedefinableHeader;
import nc.vo.wfengine.core.XpdlPackage;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.ActivitySet;
import nc.vo.wfengine.core.activity.BlockActivity;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.transition.Transition;
import nc.vo.wfengine.core.util.CoreUtilities;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.ProcessHeader;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.ActivityTypeEnum;
import nc.vo.wfengine.definition.WorkflowDefinitionVO;

public abstract class AbstractWorkflowProcess
extends AbstractWFElement
implements WorkflowProcess {
    static final long serialVersionUID = -2304468508983567539L;
    private XpdlPackage pkg;
    private ProcessHeader processHeader;
    private RedefinableHeader redefinableHeader;
    private List formalParameters = new ArrayList();
    private List dataFields = new ArrayList();
    private List eventTypes = new ArrayList();
    private List participants = new ArrayList();
    private List applications = new ArrayList();
    private List activities = new ArrayList();
    private List activitySets = new ArrayList();
    private List transitions = new ArrayList();
    private AccessLevel accessLevel = AccessLevel.PUBLIC;
    private int state = 1;
    private String pkInDB = null;
    private String subflowIdsForsql;
    private String fakeId;
    private String pre_processdefid = null;

    public AbstractWorkflowProcess(String id, String name, XpdlPackage pkg, ProcessHeader processHeader) {
        super(id, name);
        this.setProcessHeader(processHeader);
        this.pkg = pkg;
    }

    @Override
    public String getPackageId() {
        return this.pkg == null ? null : this.pkg.getId();
    }

    @Override
    public String getProcessDefinitionId() {
        return this.getId();
    }

    @Override
    public XpdlPackage getPackage() {
        return this.pkg;
    }

    @Override
    public void setPackage(XpdlPackage pkg) {
        this.pkg = pkg;
    }

    @Override
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public void setAccessLevel(AccessLevel accessLevel) {
        if (accessLevel != null) {
            this.accessLevel = accessLevel;
        }
    }

    @Override
    public String getDescription() {
        return this.processHeader.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.processHeader.setDescription(description);
    }

    @Override
    public ProcessHeader getProcessHeader() {
        return this.processHeader;
    }

    @Override
    public void setProcessHeader(ProcessHeader processHeader) {
        if (processHeader == null) {
            throw new IllegalArgumentException("ProcessHeader must not be null");
        }
        this.processHeader = processHeader;
    }

    @Override
    public RedefinableHeader getRedefinableHeader() {
        return this.redefinableHeader;
    }

    @Override
    public void setRedefinableHeader(RedefinableHeader redefinableHeader) {
        this.redefinableHeader = redefinableHeader;
    }

    @Override
    public List getFormalParameters() {
        return this.formalParameters;
    }

    @Override
    public List getDataFields() {
        return this.dataFields;
    }

    @Override
    public List getParticipants() {
        return this.participants;
    }

    @Override
    public List getApplications() {
        return this.applications;
    }

    @Override
    public List getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public List getActivities() {
        return this.activities;
    }

    @Override
    public List getActivitySets() {
        return this.activitySets;
    }

    @Override
    public List getTransitions() {
        return this.transitions;
    }

    @Override
    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    private List getTranstionConnectObjects() {
        ArrayList list = new ArrayList();
        List activities = this.getActivities();
        list.addAll(activities);
        return list;
    }

    public void resolveReferences() {
        this.resolveActivitySets(this.getActivitySets(), this.getActivities(), true);
        this.resolveTransitions(this.getActivitySets(), this.getTranstionConnectObjects(), this.getTransitions());
    }

    private void resolveActivitySets(List activitySets, List activities, boolean recursive) {
        for (Activity activity : activities) {
            BlockActivity ba = activity.getBlockActivity();
            if (ba == null) continue;
            for (ActivitySet activitySet : activitySets) {
                if (!activitySet.getId().equals(ba.getBlockId())) continue;
                ba.setActivitySet(activitySet);
                break;
            }
            if (ba.getActivitySet() != null) continue;
            throw new IllegalStateException("ActivitySet not found: " + ba.getBlockId());
        }
        if (recursive) {
            for (ActivitySet activitySet : activitySets) {
                this.resolveActivitySets(activitySets, activitySet.getActivities(), false);
            }
        }
    }

    private void resolveTransitions(List activitySets, List activities, List transitions) {
        for (Activity activity : activities) {
            String activityId = activity.getId();
            Map afferentTransitions = activity.getAfferentTransitions();
            Map efferentTransitions = activity.getEfferentTransitions();
            afferentTransitions.clear();
            efferentTransitions.clear();
            for (Transition transition : transitions) {
                if (transition.getFrom().equals(activityId)) {
                    transition.setFromActivity(activity);
                    efferentTransitions.put(transition.getId(), transition);
                }
                if (!transition.getTo().equals(activityId)) continue;
                transition.setToActivity(activity);
                afferentTransitions.put(transition.getId(), transition);
            }
        }
        for (Transition tObj : transitions) {
            if (tObj.getFromActivity() == null) {
                throw new IllegalStateException("FromActivity of transition not found:" + tObj.getFrom());
            }
            if (tObj.getToActivity() != null) continue;
            throw new IllegalStateException("ToActivity of transition not found:" + tObj.getTo());
        }
        if (activitySets != null) {
            for (ActivitySet activitySet : activitySets) {
                this.resolveTransitions(null, activitySet.getActivities(), activitySet.getTransitions());
            }
        }
    }

    @Override
    public Activity findActivityByID(String actId) {
        Activity activity;
        int i;
        Activity retrActivity = null;
        ArrayList<Activity> subFlowActivities = new ArrayList<Activity>();
        List activities = this.getActivities();
        int count = activities.size();
        for (i = 0; i < count; ++i) {
            activity = (Activity)activities.get(i);
            if (activity.getActivityType() == ActivityTypeEnum.Subflow.getIntValue()) {
                subFlowActivities.add(activity);
            }
            if (!activity.getId().equals(actId)) continue;
            retrActivity = activity;
            break;
        }
        if (retrActivity != null) {
            return retrActivity;
        }
        count = subFlowActivities.size();
        for (i = 0; i < count; ++i) {
            activity = (Activity)subFlowActivities.get(i);
            SubFlow sf = (SubFlow)activity.getImplementation();
            try {
                IWorkflowDefine workflowDefine = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class.getName());
                WorkflowDefinitionVO workflowDefineVO = workflowDefine.findDefinitionByGUID(sf.getId());
                BasicWorkflowProcess subflowDef = PfDataCache.getWorkflowProcess(workflowDefineVO.getPrimaryKey());
                retrActivity = subflowDef.findActivityByID(actId);
                if (retrActivity == null) continue;
                return retrActivity;
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                return retrActivity;
            }
        }
        return retrActivity;
    }

    @Override
    public Activity findStartActivity() {
        Object startInfo = CoreUtilities.getValueOfExtendedAttr(this, "UFW_StartOfWorkflow");
        if (startInfo instanceof String) {
            int index = ((String)startInfo).indexOf("@");
            String actId = ((String)startInfo).substring(0, index);
            return this.findActivityByID(actId);
        }
        return null;
    }

    @Override
    public List findEndActivities() {
        ArrayList<Activity> endList = new ArrayList<Activity>();
        Map attrs = this.getExtendedAttributes();
        String extAttrValue = "";
        Set extAttrKeys = attrs.keySet();
        Iterator iter = extAttrKeys.iterator();
        String key = "";
        while (iter.hasNext()) {
            int index;
            String actId;
            Activity endAct;
            key = (String)iter.next();
            if (key.indexOf("UFW_EndOfWorkflow") < 0 || (endAct = this.findActivityByID(actId = (extAttrValue = (String)attrs.get(key)).substring(0, index = extAttrValue.indexOf("@")))) == null) continue;
            endList.add(endAct);
        }
        return endList;
    }

    @Override
    public Participant findParticipantByID(String ParticipantID) {
        int i;
        for (int i2 = 0; i2 < this.participants.size(); ++i2) {
            Participant p = (Participant)this.participants.get(i2);
            if (!p.getId().equals(ParticipantID)) continue;
            return p;
        }
        ArrayList<Activity> subFlowActivities = new ArrayList<Activity>();
        List activities = this.getActivities();
        int count = activities.size();
        for (i = 0; i < count; ++i) {
            Activity activity = (Activity)activities.get(i);
            if (activity.getActivityType() != ActivityTypeEnum.Subflow.getIntValue()) continue;
            subFlowActivities.add(activity);
        }
        i = 0;
        int count2 = subFlowActivities.size();
        if (i < count2) {
            Activity activity = (Activity)subFlowActivities.get(i);
            SubFlow sf = (SubFlow)activity.getImplementation();
            try {
                IWorkflowDefine workflowDefine = (IWorkflowDefine)NCLocator.getInstance().lookup(IWorkflowDefine.class.getName());
                WorkflowDefinitionVO workflowDefineVO = workflowDefine.findDefinitionByGUID(sf.getId());
                BasicWorkflowProcess subflowDef = PfDataCache.getWorkflowProcess(workflowDefineVO.getPrimaryKey());
                return subflowDef.findParticipantByID(ParticipantID);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getPrimaryKey() {
        return this.pkInDB;
    }

    @Override
    public void setPrimaryKey(String pk) {
        this.pkInDB = pk;
    }

    @Override
    public String getSublfowIds() {
        return this.subflowIdsForsql;
    }

    @Override
    public void setSublfowIds(String subflowIdsForsql) {
        this.subflowIdsForsql = subflowIdsForsql;
    }

    @Override
    public String getFakeId() {
        return this.fakeId;
    }

    @Override
    public void setFakeId(String fakeId) {
        this.fakeId = fakeId;
    }

    @Override
    public void setPre_processdefid(String pre_processdefid) {
        this.pre_processdefid = pre_processdefid;
    }

    @Override
    public String getPre_processdefid() {
        return this.pre_processdefid;
    }
}

