/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import nc.bs.logging.Logger;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pub.guid.UUIDGenerator;
import nc.vo.pub.pf.plugin.ActivityMsgConfigVO;
import nc.vo.pub.workflownote.WorkitemMsgConfigVO;
import nc.vo.wfengine.core.WFElement;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.RaceModal;
import nc.vo.wfengine.core.activity.ShapeStyle;
import nc.vo.wfengine.core.activity.TextPosition;
import nc.vo.wfengine.core.application.WfGadgetBodyVO;
import nc.vo.wfengine.core.condition.BasicXpression;
import nc.vo.wfengine.core.condition.Condition;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.transition.Join;
import nc.vo.wfengine.core.transition.RoutingType;
import nc.vo.wfengine.core.transition.Split;
import nc.vo.wfengine.core.transition.TLineType;
import nc.vo.wfengine.core.transition.Transition;
import nc.vo.wfengine.core.transition.TransitionRestriction;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nc.vo.wfengine.definition.NCFunctionXpression;
import nc.vo.wfengine.definition.StartOrEndInfo;

public final class CoreUtilities {
    public static void dummyThread4Performance() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Logger.debug((Object)">>Start a dummy thread to initialize random seed and preload xml document builder");
                UUIDGenerator.getInstance().getDummyAddress();
            }
        }).start();
    }

    public static Object getValueOfExtendedAttr(WFElement wfElement, String attrName) {
        if (wfElement == null) {
            return null;
        }
        Map extendedAttrs = wfElement.getExtendedAttributes();
        return extendedAttrs.get(attrName);
    }

    public static void setValueOfExtendedAttr(WFElement wfElement, String attrName, Object value) {
        Map extendedAttrs = wfElement.getExtendedAttributes();
        extendedAttrs.put(attrName, value);
    }

    public static boolean isParticipantAlreadyExist(Participant partVo, WorkflowProcess wp) {
        Participant part = CoreUtilities.findParticipantById(partVo.getId(), wp);
        return part != null;
    }

    public static Participant findParticipantById(String part_guid, WorkflowProcess wp) {
        List parts = wp.getParticipants();
        for (Participant part : parts) {
            if (!part.getId().equals(part_guid)) continue;
            return part;
        }
        return null;
    }

    public static void fillDefaultExtAttr4CheckBillActivity(Activity act) {
        Map attrs = act.getExtendedAttributes();
        attrs.put("ShapeStyle", "0");
        attrs.put("Font", "Dialog;0;12");
        attrs.put("TextColor", "Color.black");
        attrs.put("TextPosition", "3");
        attrs.put("Background", "Color.lightGray");
        attrs.put("HasBorder", "false");
        attrs.put("BorderColor", "Color.black");
        attrs.put("BorderWidth", "1.0");
        attrs.put("Opaque", "false");
        attrs.put("UseIcon", "true");
        attrs.put("Exchange", "true");
    }

    public static void fillDefaultExtAttr4MakeBillActivity(Activity act) {
        Map attrs = act.getExtendedAttributes();
        attrs.put("ShapeStyle", String.valueOf(0));
        attrs.put("Font", "Dialog;0;12");
        attrs.put("TextColor", "Color.black");
        attrs.put("TextPosition", String.valueOf(3));
        attrs.put("Background", "R=195,G=170,B=228");
        attrs.put("HasBorder", "false");
        attrs.put("BorderColor", "Color.black");
        attrs.put("BorderWidth", "1.0");
        attrs.put("Opaque", "false");
        attrs.put("UseIcon", "true");
        attrs.put("Exchange", "true");
    }

    public static void fillDefaultExtAttr4Route(Activity act) {
        Map attrs = act.getExtendedAttributes();
        attrs.put("ShapeStyle", String.valueOf(0));
        attrs.put("Font", "Dialog;0;12");
        attrs.put("TextColor", "Color.black");
        attrs.put("TextPosition", String.valueOf(3));
        attrs.put("Background", "R=161,G=205,B=99");
        attrs.put("HasBorder", "false");
        attrs.put("BorderColor", "Color.black");
        attrs.put("BorderWidth", "1");
        attrs.put("Opaque", "false");
        attrs.put("UseIcon", "true");
        attrs.put("Exchange", "true");
    }

    public static NCFunctionXpression[] getFuncXpressionsOfCondition(Condition cond) {
        List exps = cond.getXpressions();
        return CoreUtilities.getFuncXpressions(exps);
    }

    public static NCFunctionXpression[] getFuncXpressions(List exps) {
        ArrayList<NCFunctionXpression> al = new ArrayList<NCFunctionXpression>();
        NCFunctionXpression fx = null;
        String strExp = null;
        for (BasicXpression exp : exps) {
            if (!exp.getValue().startsWith(BasicXpression.FUNCTION_PREFIX) || (fx = NCFunctionXpression.fromString(strExp = exp.getValue().substring(BasicXpression.FUNCTION_PREFIX.length()))) == null) continue;
            al.add(fx);
        }
        if (al.size() != 0) {
            return al.toArray(new NCFunctionXpression[0]);
        }
        return null;
    }

    public static String getCustomXpressionOfCondition(Condition cond) {
        List exps = cond.getXpressions();
        return CoreUtilities.getCustomXpression(exps);
    }

    public static String getCustomXpression(List exps) {
        String strExp = null;
        for (BasicXpression exp : exps) {
            if (!exp.getValue().startsWith(BasicXpression.CUSTOM_PREFIX)) continue;
            strExp = exp.getValue().substring(BasicXpression.CUSTOM_PREFIX.length());
            break;
        }
        return strExp;
    }

    public static String getCheckXpressionOfCondition(Condition cond) {
        List exps = cond.getXpressions();
        return CoreUtilities.getCheckXpression(exps);
    }

    public static String getCheckXpression(List exps) {
        String strExp = null;
        for (BasicXpression exp : exps) {
            if (!exp.getValue().startsWith(BasicXpression.CHECK_PREFIX)) continue;
            strExp = exp.getValue().substring(BasicXpression.CHECK_PREFIX.length());
            break;
        }
        return strExp;
    }

    public static Collection<ActivityMsgConfigVO> getMsgConfigs(Activity activity) {
        Object value = CoreUtilities.getValueOfExtendedAttr(activity, "MsgConfig");
        if (value == null || value instanceof String && StringUtil.isEmptyWithTrim((String)((String)value))) {
            return null;
        }
        ActivityMsgConfigVO[] configs = CoreUtilities.msgConfigFromXML((String)value);
        return Arrays.asList(configs);
    }

    public static Collection<WorkitemMsgConfigVO> getWorkitemMsgConfigs(Activity activity) {
        Object value = CoreUtilities.getValueOfExtendedAttr(activity, "WorkitemMsgConfig");
        if (value == null || value instanceof String && StringUtil.isEmptyWithTrim((String)((String)value))) {
            return null;
        }
        WorkitemMsgConfigVO[] configs = CoreUtilities.workitemMsgConfigFromXML((String)value);
        return Arrays.asList(configs);
    }

    public static ArrayList<String> getSupervisors(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "Supervisor");
        return (ArrayList)value;
    }

    public static ActivityMsgConfigVO[] msgConfigFromXML(String xmlString) {
        if (StringUtil.isEmptyWithTrim((String)xmlString)) {
            return null;
        }
        try {
            XStream xs = new XStream();
            XStream.setupDefaultSecurity((XStream)xs);
            xs.allowTypes(new Class[]{ActivityMsgConfigVO.class});
            return (ActivityMsgConfigVO[])xs.fromXML(xmlString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String xmlStringFromMsgConfig(ActivityMsgConfigVO[] configs) {
        if (configs == null || configs.length == 0) {
            return "";
        }
        try {
            XStream xs = new XStream();
            xs.addPermission(AnyTypePermission.ANY);
            return xs.toXML((Object)configs);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static WorkitemMsgConfigVO[] workitemMsgConfigFromXML(String xmlString) {
        if (StringUtil.isEmptyWithTrim((String)xmlString)) {
            return null;
        }
        try {
            XStream xs = new XStream();
            XStream.setupDefaultSecurity((XStream)xs);
            xs.allowTypes(new Class[]{WorkitemMsgConfigVO.class});
            return (WorkitemMsgConfigVO[])xs.fromXML(xmlString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String xmlStringFromWorkitemMsgConfig(WorkitemMsgConfigVO[] configs) {
        if (configs == null || configs.length == 0) {
            return "";
        }
        try {
            XStream xs = new XStream();
            xs.addPermission(AnyTypePermission.ANY);
            return xs.toXML((Object)configs);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String[] tokenize(String input, String boundary) {
        if (input == null) {
            input = "";
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, boundary);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public static String[] getStartArrow(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "StartArrow");
        if (value == null) {
            return new String[]{"0", "10", "false"};
        }
        String[] s = CoreUtilities.tokenize((String)value, ";");
        return new String[]{s[0], s[1], s[2]};
    }

    public static String[] getEndArrow(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "EndArrow");
        if (value == null) {
            return new String[]{"4", "10", "false"};
        }
        String[] s = CoreUtilities.tokenize((String)value, ";");
        return new String[]{s[0], s[1], s[2]};
    }

    public static float[] getDashPattern(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "DashPattern");
        if (value == null) {
            return new float[]{5.0f, 5.0f};
        }
        String[] s = CoreUtilities.tokenize((String)value, ";");
        return new float[]{Float.parseFloat(s[0]), Float.parseFloat(s[1])};
    }

    public static boolean isTransDashed(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "Dashed");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public static ShapeStyle getShapeStyle(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "ShapeStyle");
        if (value == null) {
            return ShapeStyle.RECTANGLE;
        }
        int race = Integer.parseInt(value.toString());
        return ShapeStyle.VALUES[race];
    }

    public static Font getTextFont(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "Font");
        if (value == null) {
            return new Font("Dialog", 0, 12);
        }
        return CoreUtilities.parseFontString((String)value);
    }

    public static Font parseFontString(String fontString) {
        String[] s = CoreUtilities.tokenize(fontString, ";");
        return new Font(s[0], Integer.parseInt(s[1]), Integer.parseInt(s[2]));
    }

    public static Color getTextColor(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "TextColor");
        if (value == null) {
            return Color.black;
        }
        return CoreUtilities.getColor((String)value);
    }

    public static TextPosition getTextPosition(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "TextPosition");
        if (value == null) {
            return TextPosition.LEFT_ICON_RIGHT_TEXT;
        }
        int tp = Integer.parseInt(value.toString());
        return TextPosition.VALUES[tp];
    }

    public static Color getBackground(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "Background");
        if (value == null) {
            return Color.lightGray;
        }
        return CoreUtilities.getColor((String)value);
    }

    public static Color getBorderColor(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "BorderColor");
        if (value == null) {
            return Color.black;
        }
        return CoreUtilities.getColor((String)value);
    }

    public static float getBorderWidth(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "BorderWidth");
        if (value == null) {
            return 1.0f;
        }
        return Float.parseFloat((String)value);
    }

    public static boolean hasBorder(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "HasBorder");
        if (value == null) {
            return true;
        }
        return value.equals("true");
    }

    public static boolean isOpaque(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "Opaque");
        if (value == null) {
            return true;
        }
        return value.equals("true");
    }

    public static boolean isUseIcon(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "UseIcon");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public static boolean isExchange(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "Exchange");
        return "true".equals(value);
    }

    public static Color getColor(String col) {
        Color c = null;
        int dotInd = col.indexOf(".");
        if (col.indexOf("Color") != -1 && dotInd != -1) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> cls = cl.loadClass("java.awt." + col.substring(0, dotInd));
                Field f = cls.getField(col.substring(dotInd + 1));
                c = (Color)f.get(null);
            }
            catch (Exception ex) {
                Logger.debug((Object)ex.getMessage());
            }
        } else {
            try {
                int i1 = col.indexOf("R=");
                if (i1 == -1) {
                    i1 = col.indexOf("r=");
                }
                int i1c = col.indexOf(",", i1 + 2);
                int i2 = col.indexOf("G=");
                if (i2 == -1) {
                    i2 = col.indexOf("g=");
                }
                int i2c = col.indexOf(",", i2 + 2);
                int i3 = col.indexOf("B=");
                if (i3 == -1) {
                    i3 = col.indexOf("b=");
                }
                if (i1 != -1 && i1c != -1 && i2 != -1 && i2c != -1 && i3 != -1 && i1c < i2 && i2c < i3) {
                    int b;
                    int g;
                    int r = Integer.valueOf(col.substring(i1 + 2, i1c).trim());
                    if (r < 0) {
                        r = 0;
                    }
                    if (r > 255) {
                        r = 255;
                    }
                    if ((g = Integer.valueOf(col.substring(i2 + 2, i2c).trim()).intValue()) < 0) {
                        g = 0;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if ((b = Integer.valueOf(col.substring(i3 + 2).trim()).intValue()) < 0) {
                        b = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    c = new Color(r, g, b);
                }
            }
            catch (Exception ex) {
                Logger.debug((Object)ex.getMessage());
            }
        }
        return c;
    }

    public static String parseColor(Color color) {
        return "R=" + color.getRed() + ",G=" + color.getGreen() + ",B=" + color.getBlue();
    }

    public static String getFontString(Font font) {
        if (font == null) {
            return "Dialog;0;12";
        }
        return font.getName() + ";" + font.getStyle() + ";" + font.getSize();
    }

    public static TLineType getLineType(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "LineType");
        if (value == null) {
            return TLineType.ORTHOGONAL;
        }
        int iLineType = Integer.parseInt(value.toString());
        return TLineType.VALUES[iLineType];
    }

    public static RaceModal getRaceModal(Activity act) {
        Object value = CoreUtilities.getValueOfExtendedAttr(act, "RaceModal");
        if (value == null) {
            return RaceModal.TOGETHER;
        }
        int race = Integer.parseInt(value.toString());
        return RaceModal.VALUES[race];
    }

    public static String getRaceModalValue(Activity act) {
        Object value = CoreUtilities.getValueOfExtendedAttr(act, "RaceModalValue");
        String raceValue = "100%";
        if (value != null && !StringUtil.isEmptyWithTrim((String)value.toString())) {
            raceValue = value.toString();
        }
        return raceValue;
    }

    public static String getPreConditionValue(Activity act) {
        Object value = CoreUtilities.getValueOfExtendedAttr(act, "PreconditionValue");
        String prevalue = "100%";
        if (value != null && !StringUtil.isEmptyWithTrim((String)value.toString())) {
            prevalue = value.toString();
        }
        return prevalue;
    }

    public static String getPostConditionValue(Activity act) {
        Object value = CoreUtilities.getValueOfExtendedAttr(act, "PostconditionValue");
        String postvalue = "100%";
        if (value != null && !StringUtil.isEmptyWithTrim((String)value.toString())) {
            postvalue = value.toString();
        }
        return postvalue;
    }

    public static int getPriority(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "Priority");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt((String)value);
    }

    public static RoutingType getRoutingType(WFElement element) {
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "RoutingType");
        if (value == null) {
            return RoutingType.NOROUTING;
        }
        return RoutingType.fromString((String)value);
    }

    public static float getLineWidth(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "LineWidth");
        if (value == null) {
            return 1.0f;
        }
        return Float.parseFloat((String)value);
    }

    public static Color getLineColor(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "LineColor");
        if (value == null) {
            return Color.black;
        }
        return CoreUtilities.getColor((String)value);
    }

    public static String getParticipantIcon(Participant userObject) {
        Object value = CoreUtilities.getValueOfExtendedAttr(userObject, "Icon");
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    public static float getParticipantTextPercent(Participant userObject) {
        float defaultPercent = 0.3f;
        Object value = CoreUtilities.getValueOfExtendedAttr(userObject, "TextPercent");
        if (value == null) {
            return defaultPercent;
        }
        return Float.parseFloat((String)value);
    }

    public static boolean isANDTypeSplitOrJoin(Activity act, int sOrJ) {
        List transitionRestrictions = act.getTransitionRestrictions();
        Iterator iter = transitionRestrictions.iterator();
        TransitionRestriction restriction = (TransitionRestriction)iter.next();
        Split split = restriction.getSplit();
        Join join = restriction.getJoin();
        if (sOrJ != 0) {
            return join.getType().getValue() == 0;
        }
        return split.getType().getValue() == 0;
    }

    public static Set getSplitOrJoinActivities(Collection acts, int sOrJ) {
        HashSet<Activity> sOrJactivities = new HashSet<Activity>();
        if (acts == null) {
            return sOrJactivities;
        }
        List ts = null;
        for (Activity act : acts) {
            if (ts == null) {
                ts = act.getWorkflowProcess().getTransitions();
            }
            Iterator iter = sOrJ == 0 ? CoreUtilities.getTransitions(ts, act.getId(), -1).iterator() : CoreUtilities.getTransitions(ts, act.getId(), 1).iterator();
            int noOfTrans = 0;
            while (iter.hasNext()) {
                Transition t = (Transition)iter.next();
                if (t == null || t.getFrom() == null || t.getTo() == null) continue;
                ++noOfTrans;
            }
            if (noOfTrans <= true) continue;
            sOrJactivities.add(act);
        }
        return sOrJactivities;
    }

    public static Set getTransitions(List trans, String actId, int st) {
        HashSet<Transition> transet = new HashSet<Transition>();
        for (Transition t : trans) {
            if (st <= 0 && t.getFrom().equals(actId)) {
                transet.add(t);
            }
            if (st < 0 || !t.getTo().equals(actId)) continue;
            transet.add(t);
        }
        return transet;
    }

    public static void genDefaultExtAttr4Transition(Transition transVo, boolean isRouting) {
        Map attrs = transVo.getExtendedAttributes();
        if (isRouting) {
            attrs.put("RoutingType", RoutingType.SIMPLE.getTag());
        } else {
            attrs.put("RoutingType", RoutingType.NOROUTING.getTag());
        }
        attrs.put("LineColor", "Color.black");
        attrs.put("LineWidth", "1");
        attrs.put("LineType", "0");
        attrs.put("StartArrow", "0;10;false");
        attrs.put("EndArrow", "2;8;true");
        attrs.put("Dashed", "false");
        attrs.put("DashPattern", "5;5");
        attrs.put("LabelPosition", "500;0");
    }

    public static String getRect(Rectangle rect) {
        return rect.x + ";" + rect.y + ";" + rect.width + ";" + rect.height;
    }

    public static String getPointString(Point2D p) {
        if (p == null) {
            return "0;0";
        }
        return p.getX() + ";" + p.getY();
    }

    public static Point2D getLabelPosition(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "LabelPosition");
        if (value == null || value.equals("")) {
            return null;
        }
        Point2D pos = CoreUtilities.parsePointString((String)value);
        pos.setLocation(pos.getX(), 0.0);
        return pos;
    }

    public static Point2D getLabelOffset(Transition transVo) {
        Object value = CoreUtilities.getValueOfExtendedAttr(transVo, "LabelOffset");
        if (value == null || value.equals("")) {
            return null;
        }
        Point2D pos = CoreUtilities.parsePointString((String)value);
        return pos;
    }

    public static void springDescription(Transition transObj, StartOrEndInfo info) {
        info.setTransTitle(transObj.getName());
        info.setStartArrow((String)transObj.getExtendedAttributes().get("StartArrow"));
        info.setEndArrow((String)transObj.getExtendedAttributes().get("EndArrow"));
        info.setLineWidth(CoreUtilities.getLineWidth(transObj));
        info.setLineColor(CoreUtilities.getLineColor(transObj));
        info.setLineType(CoreUtilities.getLineType(transObj).getValue());
        info.setRoutingType(CoreUtilities.getRoutingType(transObj).getTag());
        info.setDashed(CoreUtilities.isTransDashed(transObj));
        info.setDashPattern((String)transObj.getExtendedAttributes().get("DashPattern"));
    }

    public static Rectangle getDimension(WFElement element) {
        Rectangle rect = new Rectangle(76, 76);
        Object value = CoreUtilities.getValueOfExtendedAttr(element, "Dimension");
        if (value == null) {
            return rect;
        }
        return CoreUtilities.parseRectString((String)value);
    }

    public static Rectangle parseRectString(String strRect) {
        Rectangle rect = new Rectangle();
        String[] s = CoreUtilities.tokenize(strRect, ";");
        rect.x = Integer.parseInt(s[0]);
        rect.y = Integer.parseInt(s[1]);
        rect.width = Integer.parseInt(s[2]);
        rect.height = Integer.parseInt(s[3]);
        return rect;
    }

    public static Point2D parsePointString(String pStr) {
        String[] s = CoreUtilities.tokenize(pStr, ";");
        return new Point2D.Double(Double.parseDouble(s[0]), Double.parseDouble(s[1]));
    }

    public static String getStrRealParam(WfGadgetBodyVO[] realParams) {
        if (realParams == null || realParams.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (WfGadgetBodyVO param : realParams) {
            if (StringUtil.isEmptyWithTrim((String)param.getValue())) continue;
            sb.append(param.getVarcode());
            sb.append("=");
            sb.append(param.getValue());
            sb.append(",");
            sb.append(param.getDisplayvalue());
            sb.append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static WfGadgetBodyVO[] getRealParamFromStr(String strRealParam) {
        String[] strs;
        if (StringUtil.isEmptyWithTrim((String)strRealParam)) {
            return null;
        }
        ArrayList<WfGadgetBodyVO> bodyVOs = new ArrayList<WfGadgetBodyVO>();
        for (String str : strs = StringUtil.split((String)strRealParam, (String)";")) {
            int index = str.indexOf("=");
            if (index <= 0) continue;
            String varCode = str.substring(0, index);
            String displayandvalue = str.substring(index + 1);
            String[] values = displayandvalue.split(",");
            String value = values[0];
            String displayValue = values[1];
            WfGadgetBodyVO bodyVO = new WfGadgetBodyVO();
            bodyVO.setVarcode(varCode);
            bodyVO.setValue(value);
            bodyVO.setDisplayvalue(displayValue);
            bodyVOs.add(bodyVO);
        }
        return bodyVOs.toArray(new WfGadgetBodyVO[0]);
    }

    public static Object canAssign(Activity act) {
        Object value = CoreUtilities.getValueOfExtendedAttr(act, "Assigned");
        return "true".equals(value);
    }

    public static Object canTransfer(Activity act) {
        Object value = CoreUtilities.getValueOfExtendedAttr(act, "CanTransfer");
        return "true".equals(value);
    }

    public static Object canAddAprover(Activity act) {
        Object value = CoreUtilities.getValueOfExtendedAttr(act, "CanAddApprover");
        return "true".equals(value);
    }

    public static String findFiltercodeOfAct(Activity act) {
        String strCode = null;
        Object filterMode = CoreUtilities.getValueOfExtendedAttr(act, "ParticipantFilterMode");
        if (filterMode != null) {
            strCode = filterMode.toString();
        }
        return strCode;
    }
}

