/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nc.bs.logging.Logger;
import nc.rule.datastruct.IRule;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.jcom.xml.XMLUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.querytemplate.QueryTemplateUtils;
import nc.vo.wf.condition.FilterExpressionConvertor;
import nc.vo.wfengine.core.AccessLevel;
import nc.vo.wfengine.core.ConformanceClass;
import nc.vo.wfengine.core.ExternalPackage;
import nc.vo.wfengine.core.GraphConformance;
import nc.vo.wfengine.core.PackageHeader;
import nc.vo.wfengine.core.PublicationStatus;
import nc.vo.wfengine.core.RedefinableHeader;
import nc.vo.wfengine.core.Script;
import nc.vo.wfengine.core.XpdlPackage;
import nc.vo.wfengine.core.activity.Activity;
import nc.vo.wfengine.core.activity.ActivityEx;
import nc.vo.wfengine.core.activity.ActivitySet;
import nc.vo.wfengine.core.activity.AutomationMode;
import nc.vo.wfengine.core.activity.BlockActivity;
import nc.vo.wfengine.core.activity.CompletionStrategy;
import nc.vo.wfengine.core.activity.ExecutionType;
import nc.vo.wfengine.core.activity.GenericActivityEx;
import nc.vo.wfengine.core.activity.Implementation;
import nc.vo.wfengine.core.activity.ImplementationType;
import nc.vo.wfengine.core.activity.Loop;
import nc.vo.wfengine.core.activity.NoImplementation;
import nc.vo.wfengine.core.activity.Route;
import nc.vo.wfengine.core.activity.SubFlow;
import nc.vo.wfengine.core.activity.Tool;
import nc.vo.wfengine.core.activity.ToolSet;
import nc.vo.wfengine.core.activity.ToolType;
import nc.vo.wfengine.core.application.Application;
import nc.vo.wfengine.core.application.BasicApplication;
import nc.vo.wfengine.core.condition.BasicCondition;
import nc.vo.wfengine.core.condition.BasicXpression;
import nc.vo.wfengine.core.condition.Condition;
import nc.vo.wfengine.core.condition.ConditionType;
import nc.vo.wfengine.core.condition.Xpression;
import nc.vo.wfengine.core.data.ActualParameter;
import nc.vo.wfengine.core.data.ArrayType;
import nc.vo.wfengine.core.data.BasicType;
import nc.vo.wfengine.core.data.DataField;
import nc.vo.wfengine.core.data.DataType;
import nc.vo.wfengine.core.data.DeclaredType;
import nc.vo.wfengine.core.data.EnumerationType;
import nc.vo.wfengine.core.data.EnumerationValue;
import nc.vo.wfengine.core.data.ExternalReference;
import nc.vo.wfengine.core.data.FormalParameter;
import nc.vo.wfengine.core.data.ListType;
import nc.vo.wfengine.core.data.RecordType;
import nc.vo.wfengine.core.data.Type;
import nc.vo.wfengine.core.data.TypeDeclaration;
import nc.vo.wfengine.core.data.UnionType;
import nc.vo.wfengine.core.parser.ElementRequiredException;
import nc.vo.wfengine.core.parser.XPDLParser;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.parser.XPDLParserUtil;
import nc.vo.wfengine.core.participant.BasicParticipantEx;
import nc.vo.wfengine.core.participant.Participant;
import nc.vo.wfengine.core.participant.ParticipantType;
import nc.vo.wfengine.core.transition.BasicTransitionEx;
import nc.vo.wfengine.core.transition.Event;
import nc.vo.wfengine.core.transition.Join;
import nc.vo.wfengine.core.transition.Split;
import nc.vo.wfengine.core.transition.SplitJoinType;
import nc.vo.wfengine.core.transition.Transition;
import nc.vo.wfengine.core.transition.TransitionRestriction;
import nc.vo.wfengine.core.util.Deadline;
import nc.vo.wfengine.core.util.DurationUnit;
import nc.vo.wfengine.core.util.InstantiationType;
import nc.vo.wfengine.core.util.SimulationInformation;
import nc.vo.wfengine.core.util.TimeEstimation;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.ProcessHeader;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nccloud.riart.pub.expression.XpdlCompatibilityLowVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class UfXPDLParser
implements XPDLParser {
    private static UfXPDLParser instance = new UfXPDLParser();
    private DurationUnit defaultDurationUnit = DurationUnit.MINUTE;
    private InstantiationType defaultInstantiationType = InstantiationType.ONCE;
    private final int PARSER_TYPE_ALL = 0;
    private final int PARSER_TYPE_NO_PROCESS = 1;
    private final int PARSER_TYPE_PROCESS_ONLY = 2;

    private UfXPDLParser() {
    }

    public static UfXPDLParser getInstance() {
        return instance;
    }

    @Override
    public XpdlPackage parse(InputStream in) throws XPDLParserException {
        return this.parse(new InputStreamReader(in));
    }

    public XpdlPackage parse(String xpdlFilePath) throws FileNotFoundException, XPDLParserException {
        FileInputStream fin = new FileInputStream(xpdlFilePath);
        return this.parse(fin);
    }

    @Override
    public XpdlPackage parse(Reader in) throws XPDLParserException {
        try {
            Document document = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
            Element packageElement = XPDLParserUtil.getRootElement(document);
            PackageHeader packageHeader = this.createPackageHeader(XPDLParserUtil.child(packageElement, "PackageHeader"));
            String pkgId = XMLUtil.getAtrributeValueOf((Node)packageElement, (String)"Id");
            String pkgName = XMLUtil.getAtrributeValueOf((Node)packageElement, (String)"Name");
            XpdlPackage pkg = new XpdlPackage(pkgId, pkgName, packageHeader);
            XPDLParserUtil.setNameWithMultiLang(pkg, packageElement);
            pkg.setRedefinableHeader(this.createRedefinableHeader(XPDLParserUtil.child(packageElement, "RedefinableHeader")));
            pkg.setConformanceClass(this.createConformanceClass(XPDLParserUtil.child(packageElement, "ConformanceClass")));
            pkg.setScript(this.createScript(XPDLParserUtil.child(packageElement, "Script")));
            this.loadExternalPackages(pkg.getExternalPackages(), XPDLParserUtil.child(packageElement, "ExternalPackages"));
            this.loadTypeDeclarations(pkg.getTypeDeclarations(), XPDLParserUtil.child(packageElement, "TypeDeclarations"));
            this.loadParticipants(pkg.getParticipants(), XPDLParserUtil.child(packageElement, "Participants"));
            this.loadApplications(pkg.getApplications(), XPDLParserUtil.child(packageElement, "Applications"));
            this.loadDataFields(pkg.getDataFields(), XPDLParserUtil.child(packageElement, "DataFields"));
            this.loadWorkflowProcesses(pkg, pkg.getWorkflowProcesses(), XPDLParserUtil.child(packageElement, "WorkflowProcesses"));
            Map extAttrs = pkg.getExtendedAttributes();
            this.loadExtendedAttributes(extAttrs, XPDLParserUtil.child(packageElement, "ExtendedAttributes"));
            List eventTypes = (List)extAttrs.remove("ufw:EventTypes");
            if (eventTypes != null) {
                pkg.getEventTypes().addAll(eventTypes);
            }
            return pkg;
        }
        catch (Exception e) {
            throw new XPDLParserException("Error parsing document.", e);
        }
    }

    public DurationUnit getDefaultDurationUnit() {
        return this.defaultDurationUnit;
    }

    public void setDefaultDurationUnit(DurationUnit defaultDurationUnit) {
        this.defaultDurationUnit = defaultDurationUnit;
    }

    protected PackageHeader createPackageHeader(Node element) throws XPDLParserException {
        if (element == null) {
            throw new ElementRequiredException("PackageHeader", "Package header required but not found");
        }
        PackageHeader packageHeader = new PackageHeader();
        packageHeader.setXPDLVersion(XPDLParserUtil.elementAsString(element, "XPDLVersion"));
        packageHeader.setVendor(XPDLParserUtil.elementAsString(element, "Vendor"));
        packageHeader.setCreated(XPDLParserUtil.elementAsDate(element, "Created"));
        packageHeader.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        packageHeader.setDocumentation(XPDLParserUtil.elementAsURL(element, "Documentation"));
        packageHeader.setPriorityUnit(XPDLParserUtil.elementAsString(element, "PriorityUnit"));
        packageHeader.setCostUnit(XPDLParserUtil.elementAsString(element, "CostUnit"));
        return packageHeader;
    }

    protected RedefinableHeader createRedefinableHeader(Node element) throws XPDLParserException {
        if (element == null) {
            return null;
        }
        RedefinableHeader redefinableHeader = new RedefinableHeader();
        redefinableHeader.setAuthor(XPDLParserUtil.elementAsString(element, "Author"));
        redefinableHeader.setVersion(XPDLParserUtil.elementAsString(element, "Version"));
        redefinableHeader.setCodepage(XPDLParserUtil.elementAsString(element, "Codepage"));
        redefinableHeader.setCountrykey(XPDLParserUtil.elementAsString(element, "Countrykey"));
        String pubStatusString = XMLUtil.getAtrributeValueOf((Node)element, (String)"PublicationStatus");
        if (pubStatusString != null) {
            PublicationStatus publicationStatus = PublicationStatus.fromString(pubStatusString);
            redefinableHeader.setPublicationStatus(publicationStatus);
        }
        this.loadResponsibles(redefinableHeader.getResponsibles(), XPDLParserUtil.child(element, "Responsibles"));
        return redefinableHeader;
    }

    protected ConformanceClass createConformanceClass(Node element) throws XPDLParserException {
        if (element == null) {
            return null;
        }
        ConformanceClass cc = new ConformanceClass();
        String attrValue = XMLUtil.getAtrributeValueOf((Node)element, (String)"GraphConformance");
        GraphConformance gc = GraphConformance.fromString(attrValue);
        cc.setGraphConformance(gc);
        return cc;
    }

    protected Script createScript(Node element) throws XPDLParserException {
        if (element == null) {
            return null;
        }
        String attrValue_TYPE = XMLUtil.getAtrributeValueOf((Node)element, (String)"Type");
        String attrValue_VERSION = XMLUtil.getAtrributeValueOf((Node)element, (String)"Version");
        String attrValue_GRAMMAR = XMLUtil.getAtrributeValueOf((Node)element, (String)"Grammar");
        Script script = new Script(attrValue_TYPE);
        script.setVersion(attrValue_VERSION);
        script.setGrammar(attrValue_GRAMMAR);
        return script;
    }

    protected void loadExternalPackages(List externalPackages, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadExternalPackages(externalPackages, XPDLParserUtil.children(element, "ExternalPackage"));
    }

    protected void loadExternalPackages(List externalPackages, List elements) throws XPDLParserException {
        externalPackages.clear();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            try {
                Element xpackElement = (Element)iter.next();
                externalPackages.add(this.createExternalPackage(xpackElement));
            }
            catch (Throwable throwable) {}
        }
        if (externalPackages.size() == 0) {
            // empty if block
        }
    }

    protected ExternalPackage createExternalPackage(Element element) throws XPDLParserException {
        String href = XMLUtil.getAtrributeValueOf((Node)element, (String)"href");
        XpdlPackage p = null;
        try {
            p = this.parse(new URL(href).openStream());
        }
        catch (Exception e) {
            throw new XPDLParserException("Error loading external package " + href, e);
        }
        ExternalPackage xpackage = new ExternalPackage(href, p);
        this.loadExtendedAttributes(xpackage.getExtendedAttributes(), XPDLParserUtil.child(element, "ExtendedAttributes"));
        return xpackage;
    }

    protected void loadResponsibles(List responsibles, Node element) {
        if (element == null) {
            return;
        }
        this.loadResponsibles(responsibles, XPDLParserUtil.children(element, "Responsible"));
    }

    protected void loadResponsibles(List responsibles, List elements) {
        responsibles.clear();
        for (Element responsibleElement : elements) {
            responsibles.add(XMLUtil.getValueOf((Node)responsibleElement));
        }
        if (responsibles.size() == 0) {
            // empty if block
        }
    }

    protected void loadParticipants(List participants, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadParticipants(participants, XPDLParserUtil.children(element, "Participant"));
    }

    protected void loadParticipants(List participants, List elements) throws XPDLParserException {
        participants.clear();
        for (Element participantElement : elements) {
            participants.add(this.createParticipant(participantElement));
        }
    }

    protected Participant createParticipant(Element element) throws XPDLParserException {
        Node typeElement = XPDLParserUtil.child(element, "ParticipantType");
        if (typeElement == null) {
            throw new ElementRequiredException("ParticipantType", "Participant type required");
        }
        String typeString = XMLUtil.getAtrributeValueOf((Node)typeElement, (String)"Type");
        if (typeString == null) {
            throw new ElementRequiredException("Type", "Participant type identifier required");
        }
        ParticipantType participantType = ParticipantType.fromString(typeString);
        if (participantType == null) {
            throw new XPDLParserException("Unknown participant type: " + typeString);
        }
        String attrValue_ID = XMLUtil.getAtrributeValueOf((Node)element, (String)"Id");
        String attrValue_NAME = XMLUtil.getAtrributeValueOf((Node)element, (String)"Name");
        BasicParticipantEx participant = new BasicParticipantEx(attrValue_ID, attrValue_NAME, participantType);
        participant.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        this.loadExtendedAttributes(participant.getExtendedAttributes(), XPDLParserUtil.child(element, "ExtendedAttributes"));
        return participant;
    }

    protected void loadApplications(List applications, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadApplications(applications, XPDLParserUtil.children(element, "Application"));
    }

    protected void loadApplications(List applications, List elements) throws XPDLParserException {
        applications.clear();
        for (Element applicationElement : elements) {
            applications.add(this.createApplication(applicationElement));
        }
    }

    protected Application createApplication(Element element) throws XPDLParserException {
        String attrValue_ID = XMLUtil.getAtrributeValueOf((Node)element, (String)"Id");
        String attrValue_NAME = XMLUtil.getAtrributeValueOf((Node)element, (String)"Name");
        BasicApplication application = new BasicApplication(attrValue_ID, attrValue_NAME);
        application.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        if (XPDLParserUtil.child(element, "FormalParameters") != null) {
            this.loadFormalParameters(application.getFormalParameters(), XPDLParserUtil.child(element, "FormalParameters"));
        } else if (XPDLParserUtil.child(element, "ExternalReference") != null) {
            application.setExternalReference(this.createExternalReference(XPDLParserUtil.child(element, "ExternalReference")));
        }
        this.loadExtendedAttributes(application.getExtendedAttributes(), XPDLParserUtil.child(element, "ExtendedAttributes"));
        return application;
    }

    protected void loadWorkflowProcesses(XpdlPackage pkg, List workflowProcesses, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadWorkflowProcesses(pkg, workflowProcesses, XPDLParserUtil.children(element, "WorkflowProcess"));
    }

    protected void loadWorkflowProcesses(XpdlPackage pkg, List workflowProcesses, List elements) throws XPDLParserException {
        workflowProcesses.clear();
        for (Element workflowProcessElement : elements) {
            workflowProcesses.add(this.createWorkflowProcess(pkg, workflowProcessElement));
        }
    }

    protected WorkflowProcess createWorkflowProcess(XpdlPackage pkg, Element element) throws XPDLParserException {
        ProcessHeader processHeader = this.createProcessHeader(XPDLParserUtil.child(element, "ProcessHeader"));
        BasicWorkflowProcess wp = new BasicWorkflowProcess(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), pkg, processHeader);
        XPDLParserUtil.setNameWithMultiLang(wp, element);
        wp.setRedefinableHeader(this.createRedefinableHeader(XPDLParserUtil.child(element, "RedefinableHeader")));
        wp.setAccessLevel(AccessLevel.fromString(XMLUtil.getAtrributeValueOf((Node)element, (String)"AccessLevel")));
        this.loadFormalParameters(wp.getFormalParameters(), XPDLParserUtil.child(element, "FormalParameters"));
        this.loadParticipants(wp.getParticipants(), XPDLParserUtil.child(element, "Participants"));
        this.loadApplications(wp.getApplications(), XPDLParserUtil.child(element, "Applications"));
        this.loadActivitySets((WorkflowProcess)wp, wp.getActivitySets(), XPDLParserUtil.child(element, "ActivitySets"));
        this.loadActivities((WorkflowProcess)wp, wp.getActivities(), XPDLParserUtil.child(element, "Activities"));
        this.loadTransitions(wp.getTransitions(), XPDLParserUtil.child(element, "Transitions"));
        Map extAttrs = wp.getExtendedAttributes();
        this.loadExtendedAttributes(extAttrs, XPDLParserUtil.child(element, "ExtendedAttributes"));
        wp.resolveReferences();
        return wp;
    }

    protected ProcessHeader createProcessHeader(Node element) throws XPDLParserException {
        if (element == null) {
            throw new ElementRequiredException("ProcessHeader", "Process header required");
        }
        ProcessHeader processHeader = new ProcessHeader();
        DurationUnit durationUnit = this.defaultDurationUnit;
        String durationUnitString = XMLUtil.getAtrributeValueOf((Node)element, (String)"DurationUnit");
        if (durationUnitString != null) {
            durationUnit = DurationUnit.fromString(durationUnitString);
        }
        processHeader.setDurationUnit(durationUnit);
        processHeader.setCreated(XPDLParserUtil.elementAsDate(element, "Created"));
        processHeader.setPriority(XPDLParserUtil.elementAsString(element, "Priority"));
        processHeader.setLimit(XPDLParserUtil.elementAsDuration(element, "Limit"));
        processHeader.setValidFrom(XPDLParserUtil.elementAsDuration(element, "ValidFrom"));
        processHeader.setValidTo(XPDLParserUtil.elementAsDuration(element, "ValidTo"));
        processHeader.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        processHeader.setTimeEstimation(this.createTimeEstimation(XPDLParserUtil.child(element, "TimeEstimation")));
        this.createMailMobile(processHeader, element);
        return processHeader;
    }

    private void createMailMobile(ProcessHeader processHeader, Node element) {
        processHeader.getMailMobile().setMailModal(XPDLParserUtil.elementAsString(element, "MailModal"));
        processHeader.getMailMobile().setMobileModal(XPDLParserUtil.elementAsString(element, "MobileModal"));
        processHeader.getMailMobile().setPrintTempletid(XPDLParserUtil.elementAsString(element, "PrintTempletId"));
        processHeader.getMailMobile().setPrintTempletname(XPDLParserUtil.elementAsString(element, "PrintTempletName"));
    }

    protected void loadActivitySets(WorkflowProcess wp, List activitySets, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadActivitySets(wp, activitySets, XPDLParserUtil.children(element, "ActivitySet"));
    }

    protected void loadActivitySets(WorkflowProcess wp, List activitySets, List elements) throws XPDLParserException {
        activitySets.clear();
        for (Element activitySetElement : elements) {
            activitySets.add(this.createActivitySet(wp, activitySetElement));
        }
    }

    protected ActivitySet createActivitySet(WorkflowProcess wp, Element element) throws XPDLParserException {
        ActivitySet activitySet = new ActivitySet(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"));
        this.loadActivities(wp, activitySet.getActivities(), XPDLParserUtil.child(element, "Activities"));
        this.loadTransitions(activitySet.getTransitions(), XPDLParserUtil.child(element, "Transitions"));
        return activitySet;
    }

    protected void loadActivities(WorkflowProcess wp, List activities, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadActivities(wp, activities, XPDLParserUtil.children(element, "Activity"));
    }

    protected void loadActivities(WorkflowProcess wp, List activities, List elements) throws XPDLParserException {
        activities.clear();
        for (Element activityElement : elements) {
            activities.add(this.createActivity(wp, activityElement));
        }
    }

    private void fillCommonInfo(Activity activity, Element element) throws XPDLParserException {
        activity.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        activity.setLimit(XPDLParserUtil.elementAsDuration(element, "Limit"));
        activity.setPerformer(XPDLParserUtil.elementAsString(element, "Performer"));
        activity.setPriority(XPDLParserUtil.elementAsString(element, "Priority"));
        activity.setDocumentation(XPDLParserUtil.elementAsURL(element, "Documentation"));
        activity.setIcon(XPDLParserUtil.elementAsString(element, "Icon"));
        this.loadDeadlines(activity.getDeadlines(), XPDLParserUtil.children(element, "Deadline"));
        activity.setSimulationInformation(this.createSimulationInformation(XPDLParserUtil.child(element, "SimulationInformation")));
    }

    protected Activity createActivity(WorkflowProcess wp, Element element) throws XPDLParserException {
        String completionStrategy;
        Node blockActivityElement;
        Node routeElement;
        ActivityEx activity = null;
        Node implementationElement = XPDLParserUtil.child(element, "Implementation");
        if (implementationElement != null) {
            Implementation impl = this.createImplementation(implementationElement);
            activity = impl instanceof SubFlow ? new ActivityEx(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), wp) : new GenericActivityEx(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), wp);
            XPDLParserUtil.setNameWithMultiLang(activity, element);
            activity.setImplementation(impl);
        }
        if ((routeElement = XPDLParserUtil.child(element, "Route")) != null && implementationElement == null) {
            activity = new ActivityEx(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), wp);
            XPDLParserUtil.setNameWithMultiLang(activity, element);
            activity.setRoute(this.createRoute(routeElement));
        }
        if ((blockActivityElement = XPDLParserUtil.child(element, "BlockActivity")) != null && implementationElement == null && routeElement == null) {
            activity = new ActivityEx(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), wp);
            XPDLParserUtil.setNameWithMultiLang(activity, element);
            activity.setBlockActivity(this.createBlockActivity(blockActivityElement));
        }
        if (implementationElement == null && routeElement == null && blockActivityElement == null) {
            throw new XPDLParserException("Activity '" + activity.getId() + "' requires Implementation, Route or BlockActivity");
        }
        this.fillCommonInfo(activity, element);
        Node startModeElement = XPDLParserUtil.child(element, "StartMode");
        if (startModeElement != null && XPDLParserUtil.child(startModeElement, "Manual") != null) {
            activity.setStartMode(AutomationMode.MANUAL);
        } else {
            activity.setStartMode(AutomationMode.AUTOMATIC);
        }
        Node finishModeElement = XPDLParserUtil.child(element, "FinishMode");
        if (finishModeElement != null && XPDLParserUtil.child(finishModeElement, "Manual") != null) {
            activity.setFinishMode(AutomationMode.MANUAL);
        } else {
            activity.setFinishMode(AutomationMode.AUTOMATIC);
        }
        this.loadTransitionRestrictions(activity.getTransitionRestrictions(), XPDLParserUtil.child(element, "TransitionRestrictions"));
        if (activity instanceof GenericActivityEx) {
            List dataFields = ((GenericActivityEx)activity).getApplicationArgs();
            this.loadDataFields(dataFields, XPDLParserUtil.child(element, "DataFields"));
        }
        Map extAttrs = activity.getExtendedAttributes();
        this.loadExtendedAttributes(extAttrs, XPDLParserUtil.child(element, "ExtendedAttributes"));
        BlockActivity ba = activity.getBlockActivity();
        if (ba != null) {
            ba.setLoop((Loop)extAttrs.remove("ufw:Loop"));
        }
        if ((completionStrategy = (String)extAttrs.remove("ufw:CompletionStrategy")) != null) {
            activity.setCompletionStrategy(CompletionStrategy.fromString(completionStrategy));
        }
        return activity;
    }

    protected void loadDeadlines(List deadlines, List elements) throws XPDLParserException {
        if (elements != null) {
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Deadline deadline = this.createDeadline((Element)i.next());
                if (deadline == null) continue;
                deadlines.add(deadline);
            }
        }
    }

    protected Deadline createDeadline(Element element) throws XPDLParserException {
        if (element == null) {
            return null;
        }
        Deadline deadline = new Deadline(XPDLParserUtil.elementAsString(element, "DeadlineCondition"), XPDLParserUtil.elementAsString(element, "ExceptionName"));
        deadline.setExecutionType(ExecutionType.fromString(XMLUtil.getAtrributeValueOf((Node)element, (String)"Execution")));
        return deadline;
    }

    protected BlockActivity createBlockActivity(Node element) {
        BlockActivity blockActivity = new BlockActivity();
        blockActivity.setBlockId(XMLUtil.getAtrributeValueOf((Node)element, (String)"BlockId"));
        return blockActivity;
    }

    protected Implementation createImplementation(Node element) throws XPDLParserException {
        ToolSet toolSet = new ToolSet();
        block5: for (Element implElement : XPDLParserUtil.getChildNodesNotText(element)) {
            ImplementationType implType = ImplementationType.fromString(implElement.getNodeName());
            if (implType == null) {
                throw new XPDLParserException("Illegal implementation type: " + implElement.getNodeName());
            }
            switch (implType.getValue()) {
                case 0: {
                    return new NoImplementation();
                }
                case 2: {
                    return this.createSubFlow(implElement);
                }
                case 1: {
                    toolSet.getTools().add(this.createTool(implElement));
                    continue block5;
                }
            }
            throw new XPDLParserException("Unsupported implementation type: " + implType);
        }
        return toolSet;
    }

    protected Route createRoute(Node element) {
        return new Route();
    }

    protected SubFlow createSubFlow(Element element) throws XPDLParserException {
        SubFlow subFlow = new SubFlow(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"));
        String executionString = XMLUtil.getAtrributeValueOf((Node)element, (String)"Execution");
        if (executionString != null) {
            subFlow.setExecution(ExecutionType.fromString(executionString));
        }
        this.loadActualParameters(subFlow.getActualParameters(), XPDLParserUtil.child(element, "ActualParameters"));
        return subFlow;
    }

    protected Tool createTool(Element element) throws XPDLParserException {
        Tool tool = new Tool(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"));
        tool.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        String typeString = XMLUtil.getAtrributeValueOf((Node)element, (String)"Type");
        if (typeString != null) {
            tool.setToolType(ToolType.fromString(typeString));
        }
        this.loadExtendedAttributes(tool.getExtendedAttributes(), XPDLParserUtil.child(element, "ExtendedAttributes"));
        this.loadActualParameters(tool.getActualParameters(), XPDLParserUtil.child(element, "ActualParameters"));
        return tool;
    }

    protected SimulationInformation createSimulationInformation(Node element) throws XPDLParserException {
        if (element == null) {
            return null;
        }
        SimulationInformation simInfo = new SimulationInformation();
        InstantiationType instantiationType = this.defaultInstantiationType;
        String instantiationTypeString = XMLUtil.getAtrributeValueOf((Node)element, (String)"InstantiationType");
        if (instantiationTypeString != null) {
            instantiationType = InstantiationType.fromString(instantiationTypeString);
        }
        simInfo.setInstantiationType(instantiationType);
        simInfo.setCost(XPDLParserUtil.elementAsString(element, "Cost"));
        simInfo.setTimeEstimation(this.createTimeEstimation(XPDLParserUtil.child(element, "TimeEstimation")));
        return simInfo;
    }

    protected TimeEstimation createTimeEstimation(Node element) throws XPDLParserException {
        if (element == null) {
            return null;
        }
        TimeEstimation timeEstimation = new TimeEstimation();
        timeEstimation.setWaitingTime(XPDLParserUtil.elementAsDuration(element, "WaitingTime"));
        timeEstimation.setWorkingTime(XPDLParserUtil.elementAsDuration(element, "WorkingTime"));
        timeEstimation.setDuration(XPDLParserUtil.elementAsDuration(element, "Duration"));
        return timeEstimation;
    }

    public Condition createCondition(Node element) {
        if (element == null) {
            return null;
        }
        BasicCondition condition = new BasicCondition();
        String typeString = XMLUtil.getAtrributeValueOf((Node)element, (String)"Type");
        if (!StringUtil.isEmptyWithTrim((String)typeString)) {
            condition.setType(ConditionType.fromString(typeString));
        }
        List xprList = condition.getXpressions();
        List childExps = XPDLParserUtil.children(element, "Xpression");
        if (childExps.size() > 0) {
            ArrayList<Xpression> alTemp = new ArrayList<Xpression>();
            for (Element xpressionElement : childExps) {
                alTemp.add(new BasicXpression(XMLUtil.getValueOf((Node)xpressionElement)));
            }
            IRule rule = FilterExpressionConvertor.expression2Rule(alTemp);
            xprList.add(rule);
        } else {
            List childExpsAND = XPDLParserUtil.children(element, "AND");
            if (childExpsAND.size() == 0) {
                childExpsAND = XPDLParserUtil.children(element, "OR");
            }
            List childExpsQry = XPDLParserUtil.children(element, "QueryRule");
            childExpsAND.addAll(childExpsQry);
            if (childExpsAND.size() > 0) {
                Object child = childExpsAND.get(0);
                Object rule = null;
                if (child instanceof Element) {
                    String xx;
                    String c;
                    Node n = ((Element)child).getFirstChild();
                    if (n != null && (c = n.getNodeValue()) != null && !(xx = c.toString()).trim().equals("")) {
                        rule = QueryTemplateUtils.readFromXML((Object)xx);
                    }
                } else {
                    rule = QueryTemplateUtils.readFromElement((Element)((Element)child));
                }
                if (rule != null) {
                    xprList.add(rule);
                }
            }
        }
        return condition;
    }

    protected void loadTransitions(List transitions, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadTransitions(transitions, XPDLParserUtil.children(element, "Transition"));
    }

    protected void loadTransitions(List transitions, List elements) throws XPDLParserException {
        transitions.clear();
        for (Element transitionElement : elements) {
            transitions.add(this.createTransition(transitionElement));
        }
    }

    protected Transition createTransition(Element element) throws XPDLParserException {
        BasicTransitionEx transition = new BasicTransitionEx(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), XMLUtil.getAtrributeValueOf((Node)element, (String)"From"), XMLUtil.getAtrributeValueOf((Node)element, (String)"To"));
        XPDLParserUtil.setNameWithMultiLang(transition, element);
        transition.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        transition.setCondition(this.createCondition(XPDLParserUtil.child(element, "Condition")));
        Map extAttrs = transition.getExtendedAttributes();
        this.loadExtendedAttributes(extAttrs, XPDLParserUtil.child(element, "ExtendedAttributes"));
        transition.setEvent((Event)extAttrs.remove("ufw:Event"));
        transition.setExecutionType((ExecutionType)extAttrs.remove("Execution"));
        return transition;
    }

    protected void loadTransitionRestrictions(List transitionRestrictions, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadTransitionRestrictions(transitionRestrictions, XPDLParserUtil.children(element, "TransitionRestriction"));
    }

    protected void loadTransitionRestrictions(List transitionRestrictions, List elements) throws XPDLParserException {
        transitionRestrictions.clear();
        for (Element transitionRestrictionElement : elements) {
            transitionRestrictions.add(this.createTransitionRestriction(transitionRestrictionElement));
        }
    }

    protected TransitionRestriction createTransitionRestriction(Element element) throws XPDLParserException {
        TransitionRestriction transitionRestriction = new TransitionRestriction();
        transitionRestriction.setJoin(this.createJoin(XPDLParserUtil.child(element, "Join")));
        transitionRestriction.setSplit(this.createSplit(XPDLParserUtil.child(element, "Split")));
        return transitionRestriction;
    }

    public Join createJoin(Node element) {
        if (element == null) {
            return null;
        }
        Join join = new Join();
        String typeString = XMLUtil.getAtrributeValueOf((Node)element, (String)"Type");
        if (typeString != null) {
            join.setType(SplitJoinType.fromString(typeString));
        }
        return join;
    }

    public Split createSplit(Node element) throws XPDLParserException {
        if (element == null) {
            return null;
        }
        Split split = new Split();
        String typeString = XMLUtil.getAtrributeValueOf((Node)element, (String)"Type");
        if (typeString == null) {
            throw new XPDLParserException("Unsupported split type: " + typeString);
        }
        split.setType(SplitJoinType.fromString(typeString));
        this.loadTransitionReferences(split.getTransitionReferences(), XPDLParserUtil.child(element, "TransitionRefs"));
        return split;
    }

    protected void loadTransitionReferences(List transitionReferences, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadTransitionReferences(transitionReferences, XPDLParserUtil.children(element, "TransitionRef"));
    }

    protected void loadTransitionReferences(List transitionReferences, List elements) throws XPDLParserException {
        transitionReferences.clear();
        for (Element transitionRefElement : elements) {
            transitionReferences.add(XMLUtil.getAtrributeValueOf((Node)transitionRefElement, (String)"Id"));
        }
    }

    protected void loadFormalParameters(List formalParameters, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadFormalParameters(formalParameters, XPDLParserUtil.children(element, "FormalParameter"));
    }

    protected void loadFormalParameters(List formalParameters, List elements) throws XPDLParserException {
        formalParameters.clear();
        for (Element formalParameterElement : elements) {
            formalParameters.add(this.createFormalParameter(formalParameterElement));
        }
    }

    protected FormalParameter createFormalParameter(Element element) throws XPDLParserException {
        DataType dataType = this.createDataType(XPDLParserUtil.child(element, "DataType"));
        if (dataType == null) {
            throw new ElementRequiredException("DataType", "Data type required");
        }
        FormalParameter param = new FormalParameter(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Index"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Mode"), dataType);
        param.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        return param;
    }

    protected void loadActualParameters(List actualParameters, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadActualParameters(actualParameters, XPDLParserUtil.children(element, "ActualParameter"));
    }

    protected void loadActualParameters(List actualParameters, List elements) throws XPDLParserException {
        actualParameters.clear();
        for (Element actualParameterElement : elements) {
            actualParameters.add(this.createActualParameter(actualParameterElement));
        }
    }

    protected ActualParameter createActualParameter(Element element) throws XPDLParserException {
        return new ActualParameter(XMLUtil.getValueOf((Node)element));
    }

    protected DataType createDataType(Node element) throws XPDLParserException {
        Type type = this.getFirstType(element);
        if (type == null) {
            throw new ElementRequiredException("Type", "Type required");
        }
        return new DataType(type);
    }

    protected Type getFirstType(Node element) throws XPDLParserException {
        for (Element child : XPDLParserUtil.getChildNodesNotText(element)) {
            String name = child.getNodeName();
            if (name.equals("PlainType") || name.equals("BasicType") || name.equals("RecordType") || name.equals("UnionType") || name.equals("ListType") || name.equals("EnumerationType") || name.equals("ArrayType") || name.equals("DeclaredType")) {
                return this.createType(child);
            }
            if (!name.equals("ExternalReference")) continue;
            return this.createExternalReference(child);
        }
        return null;
    }

    protected Type createType(Element element) throws XPDLParserException {
        String typeName = element.getNodeName();
        if (typeName.equals("BasicType")) {
            return BasicType.fromString(XMLUtil.getAtrributeValueOf((Node)element, (String)"Type"));
        }
        if (typeName.equals("RecordType")) {
            RecordType type = new RecordType();
            this.loadMembers(XPDLParserUtil.children(element, "Member"), type.getMembers());
            return type;
        }
        if (typeName.equals("UnionType")) {
            UnionType type = new UnionType();
            this.loadMembers(XPDLParserUtil.children(element, "Member"), type.getMembers());
            return type;
        }
        if (typeName.equals("ListType")) {
            return new ListType(this.getFirstType(element));
        }
        if (typeName.equals("EnumerationType")) {
            EnumerationType type = new EnumerationType();
            this.loadEnumerationValues(XPDLParserUtil.children(element, "EnumerationValue"), type.getValues());
            return type;
        }
        if (typeName.equals("ArrayType")) {
            return new ArrayType(this.getFirstType(element), XMLUtil.getAtrributeValueOf((Node)element, (String)"LowerIndex"), XMLUtil.getAtrributeValueOf((Node)element, (String)"UpperIndex"));
        }
        if (typeName.equals("DeclaredType")) {
            return new DeclaredType(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"));
        }
        throw new XPDLParserException("Unsupported type: " + typeName);
    }

    protected void loadMembers(List elements, List members) throws XPDLParserException {
        for (Element memberElement : elements) {
            Type type = this.getFirstType(memberElement);
            if (type == null) {
                throw new ElementRequiredException("Type", "Member missing type");
            }
            members.add(type);
        }
    }

    protected void loadEnumerationValues(List elements, List enumerationValues) throws XPDLParserException {
        for (Element valueElement : elements) {
            enumerationValues.add(new EnumerationValue(XMLUtil.getAtrributeValueOf((Node)valueElement, (String)"Name")));
        }
    }

    protected void loadTypeDeclarations(List typeDeclarations, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadTypeDeclarations(typeDeclarations, XPDLParserUtil.children(element, "TypeDeclaration"));
    }

    protected void loadTypeDeclarations(List typeDeclarations, List elements) throws XPDLParserException {
        typeDeclarations.clear();
        for (Element typeDeclarationElement : elements) {
            typeDeclarations.add(this.createTypeDeclaration(typeDeclarationElement));
        }
    }

    protected TypeDeclaration createTypeDeclaration(Element element) throws XPDLParserException {
        Type type = this.getFirstType(element);
        if (type == null) {
            throw new ElementRequiredException("Type", "Type required");
        }
        TypeDeclaration typeDeclaration = new TypeDeclaration(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), type);
        typeDeclaration.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        this.loadExtendedAttributes(typeDeclaration.getExtendedAttributes(), XPDLParserUtil.child(element, "ExtendedAttributes"));
        return typeDeclaration;
    }

    protected void loadDataFields(List dataFields, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadDataFields(dataFields, XPDLParserUtil.children(element, "DataField"));
    }

    protected void loadDataFields(List dataFields, List elements) throws XPDLParserException {
        dataFields.clear();
        for (Element dataFieldElement : elements) {
            dataFields.add(this.createDataField(dataFieldElement));
        }
    }

    protected DataField createDataField(Element element) throws XPDLParserException {
        DataType dataType = this.createDataType(XPDLParserUtil.child(element, "DataType"));
        if (dataType == null) {
            throw new ElementRequiredException("DataType", "Data type required");
        }
        DataField dataField = new DataField(XMLUtil.getAtrributeValueOf((Node)element, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Name"), XMLUtil.getAtrributeValueOf((Node)element, (String)"Description"), dataType);
        String isArrayString = XMLUtil.getAtrributeValueOf((Node)element, (String)"IsArray");
        if (isArrayString == null) {
            isArrayString = "false";
        }
        dataField.setArray(new Boolean(isArrayString));
        dataField.setDescription(XPDLParserUtil.elementAsString(element, "Description"));
        dataField.setInitialValue(XPDLParserUtil.elementAsString(element, "InitialValue"));
        dataField.setLength(XPDLParserUtil.elementAsInteger(element, "Length"));
        this.loadExtendedAttributes(dataField.getExtendedAttributes(), XPDLParserUtil.child(element, "ExtendedAttributes"));
        return dataField;
    }

    protected ExternalReference createExternalReference(Node element) throws XPDLParserException {
        ExternalReference externalReference = new ExternalReference(XMLUtil.getAtrributeValueOf((Node)element, (String)"location"));
        externalReference.setNamespace(XMLUtil.getAtrributeValueOf((Node)element, (String)"namespace"));
        externalReference.setXref(XMLUtil.getAtrributeValueOf((Node)element, (String)"xref"));
        return externalReference;
    }

    protected void loadExtendedAttributes(Map extendedAttributes, Node element) throws XPDLParserException {
        if (element == null) {
            return;
        }
        this.loadExtendedAttributes(extendedAttributes, XPDLParserUtil.children(element, "ExtendedAttribute"));
    }

    protected void loadExtendedAttributes(Map extendedAttributes, List elements) throws XPDLParserException {
        extendedAttributes.clear();
        for (Element extAttrElement : elements) {
            Object value;
            String name = XMLUtil.getAtrributeValueOf((Node)extAttrElement, (String)"Name");
            if (name.equals("MsgConfig")) {
                Logger.debug((Object)"nothing");
            }
            if (name.equals("Execution")) {
                String tag = XMLUtil.getAtrributeValueOf((Node)extAttrElement, (String)"Value");
                value = ExecutionType.fromString(tag);
                extendedAttributes.put(name, value);
                continue;
            }
            if (extendedAttributes.containsKey(name)) {
                Object oldValue = extendedAttributes.get(name);
                String newValue = XMLUtil.getAtrributeValueOf((Node)extAttrElement, (String)"Value");
                if (oldValue instanceof ArrayList) {
                    ((ArrayList)oldValue).add(newValue);
                    continue;
                }
                ArrayList<Object> al = new ArrayList<Object>();
                al.add(oldValue);
                al.add(newValue);
                extendedAttributes.put(name, al);
                continue;
            }
            if (name.equals("OrgUnitTree") || name.equals("Supervisor") || name.equals("EditableProperties") || name.equals("RejectUneditableProperties")) {
                ArrayList<String> al = new ArrayList<String>();
                value = XMLUtil.getAtrributeValueOf((Node)extAttrElement, (String)"Value");
                if (value != null) {
                    String[] strs = ((String)value).split(";");
                    for (int n = 0; n < strs.length; ++n) {
                        al.add(strs[n]);
                    }
                }
                extendedAttributes.put(name, al);
                continue;
            }
            value = XMLUtil.getAtrributeValueOf((Node)extAttrElement, (String)"Value");
            if (name.equals("ConditionXpression")) {
                Object rule = QueryTemplateUtils.readFromXML((Object)((String)value));
                extendedAttributes.put(name, rule);
                continue;
            }
            extendedAttributes.put(name, value);
        }
    }

    private XpdlPackage parseByType(Reader in, int parseType) throws XPDLParserException {
        try {
            Document document = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
            Element packageElement = XPDLParserUtil.getRootElement(document);
            XpdlPackage pkg = new XpdlPackage(XMLUtil.getAtrributeValueOf((Node)packageElement, (String)"Id"), XMLUtil.getAtrributeValueOf((Node)packageElement, (String)"Name"), null);
            XPDLParserUtil.setNameWithMultiLang(pkg, packageElement);
            if (parseType == 0 || parseType == 1) {
                PackageHeader packageHeader = this.createPackageHeader(XPDLParserUtil.child(packageElement, "PackageHeader"));
                pkg.setPackageHeader(packageHeader);
                pkg.setRedefinableHeader(this.createRedefinableHeader(XPDLParserUtil.child(packageElement, "RedefinableHeader")));
                pkg.setConformanceClass(this.createConformanceClass(XPDLParserUtil.child(packageElement, "ConformanceClass")));
                pkg.setScript(this.createScript(XPDLParserUtil.child(packageElement, "Script")));
                this.loadExternalPackages(pkg.getExternalPackages(), XPDLParserUtil.child(packageElement, "ExternalPackages"));
                this.loadTypeDeclarations(pkg.getTypeDeclarations(), XPDLParserUtil.child(packageElement, "TypeDeclarations"));
                this.loadParticipants(pkg.getParticipants(), XPDLParserUtil.child(packageElement, "Participants"));
                this.loadApplications(pkg.getApplications(), XPDLParserUtil.child(packageElement, "Applications"));
                Map extAttrs = pkg.getExtendedAttributes();
                this.loadExtendedAttributes(extAttrs, XPDLParserUtil.child(packageElement, "ExtendedAttributes"));
                List eventTypes = (List)extAttrs.remove("ufw:EventTypes");
                if (eventTypes != null) {
                    pkg.getEventTypes().addAll(eventTypes);
                }
            }
            if (parseType == 0 || parseType == 2) {
                this.loadWorkflowProcesses(pkg, pkg.getWorkflowProcesses(), XPDLParserUtil.child(packageElement, "WorkflowProcesses"));
            }
            return pkg;
        }
        catch (Exception e) {
            throw new XPDLParserException("Error parsing document.", e);
        }
    }

    public XpdlPackage parseNoProcess(InputStream in) throws XPDLParserException {
        return this.parseByType(new InputStreamReader(in), 1);
    }

    public XpdlPackage parseProcessOnly(InputStream in) throws XPDLParserException {
        return this.parseByType(new InputStreamReader(in), 2);
    }

    public BasicWorkflowProcess parseProcess(InputStream in) throws XPDLParserException {
        try {
            InputSource is = new InputSource(in);
            is.setEncoding("utf-8");
            Document document = XMLUtil.getDocumentBuilder().parse(is);
            Element processElement = XPDLParserUtil.getRootElement(document);
            return (BasicWorkflowProcess)this.createWorkflowProcess(null, processElement);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new XPDLParserException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "UfXPDLParser-000000", null, new String[]{ex.getMessage()}));
        }
    }

    public BasicWorkflowProcess parseProcess(String xmlContent) throws XPDLParserException {
        try {
            if (StringUtil.isEmptyWithTrim((String)xmlContent)) {
                throw new Exception("xml is null");
            }
            xmlContent = XpdlCompatibilityLowVersion.to18XMl((String)xmlContent);
            Document document = XMLUtil.getDocumentBuilder().parse(new InputSource(new StringReader(xmlContent)));
            Element processElement = XPDLParserUtil.getRootElement(document);
            return (BasicWorkflowProcess)this.createWorkflowProcess(null, processElement);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new XPDLParserException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "UfXPDLParser-000000", null, new String[]{ex.getMessage()}));
        }
    }
}

