/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.wfengine.core.data;

import java.io.Serializable;
import nc.vo.wfengine.core.data.DataType;
import nc.vo.wfengine.core.data.ParameterMode;

public class FormalParameter
implements Serializable {
    static final long serialVersionUID = 3019502908080770457L;
    private String id;
    private String name;
    private String description;
    private int index;
    private DataType dataType;
    private ParameterMode mode = ParameterMode.IN;

    public FormalParameter(String id, String name, String index, String mode, DataType dataType) {
        this(id, name, index != null ? Integer.parseInt(index) : 0, ParameterMode.fromString(mode), dataType);
    }

    public FormalParameter(String id, String name, int index, ParameterMode mode, DataType dataType) {
        this.id = id;
        this.name = name;
        this.setIndex(index);
        this.setMode(mode);
        this.setDataType(dataType);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setIndex(String index) {
        if (index != null) {
            this.setIndex(Integer.parseInt(index));
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException("Data type required");
        }
        this.dataType = dataType;
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public void setMode(ParameterMode mode) {
        this.mode = mode == null ? ParameterMode.IN : mode;
    }
}

