/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.uap.pf.refmodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.logging.Logger;
import nc.ui.bd.ref.AbstractRefModel;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.uap.pf.DynamicOrgRegInfo;
import nc.vo.uap.pf.DynamicOrganizeUnit;
import nc.vo.uap.pf.DynamicOrganizeUnitRegistry;
import nc.vo.uap.pf.IDynamicOrganizeUnitBuilder;
import nc.vo.uap.pf.OrganizeUnitTypes;
import nc.vo.uap.pf.refmodel.IOrgAcquirable;
import nc.vo.uap.pf.refmodel.OrgAcquireUtil;

public class VirtualRoleParticipantRefModel
extends AbstractRefModel
implements IOrgAcquirable {
    private Map<String, Vector> groupDataMap = new HashMap<String, Vector>();

    public VirtualRoleParticipantRefModel() {
        this.reset();
    }

    public void reset() {
        this.setFieldCode(new String[]{"code", "name"});
        this.setFieldName(new String[]{NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "WfUserGroupManagerUI-000002"), NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000083")});
        this.setHiddenFieldCode(new String[]{"pk", "pk_org"});
        this.setPkFieldCode("pk");
        this.setRefTitle(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000077"));
        this.resetFieldName();
    }

    public Vector getData() {
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        if (!this.groupDataMap.containsKey(pk_group)) {
            Vector data = new Vector();
            Object[] dous = this.findDynamicOrgs(InvocationInfoProxy.getInstance().getGroupId());
            if (ArrayUtil.isNotNull((Object[])dous)) {
                for (Object dou : dous) {
                    Vector<String> row = new Vector<String>();
                    row.add(((DynamicOrganizeUnit)dou).getCode());
                    row.add(((DynamicOrganizeUnit)dou).getName());
                    row.add(((DynamicOrganizeUnit)dou).getId());
                    row.add(((DynamicOrganizeUnit)dou).getPkOrg());
                    data.add(row);
                }
            }
            this.groupDataMap.put(pk_group, data);
        }
        return this.groupDataMap.get(pk_group);
    }

    public DynamicOrganizeUnit[] findDynamicOrgs(String pkOrg) {
        DynamicOrgRegInfo reginfo = DynamicOrganizeUnitRegistry.getInstance().getDynamicOrgInfoByType(OrganizeUnitTypes.VIRTUALROLE.toString());
        if (reginfo == null) {
            return null;
        }
        DynamicOrganizeUnit[] dous = null;
        try {
            Class<?> cls = Class.forName(reginfo.getBuilderclass());
            Object obj = cls.newInstance();
            if (obj instanceof IDynamicOrganizeUnitBuilder && ((dous = ((IDynamicOrganizeUnitBuilder)obj).createOrgUnits(pkOrg)) == null || dous.length == 0)) {
                return null;
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return dous;
    }

    @Override
    public String getPk_org(String pk) {
        return OrgAcquireUtil.getPk_org(this, this.getData(), pk);
    }
}

