/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowusergroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.pub.pf.ParticipantFilterContext;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.pubitf.bd.accessor.IGeneralAccessor;
import nc.vo.bd.accessor.IBDData;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.DeptVO;
import nc.vo.org.OrgVO;
import nc.vo.org.util.OrgTypeManager;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.workflowusergroup.WFUserGroupUtil;
import nc.vo.pub.workflowusergroup.WfUserGroupResolvingException;
import nc.vo.uap.pf.IWfUserGroupResolver;
import nccloud.commons.lang.StringUtils;

public class WfUserGroup4HigherUp
implements IWfUserGroupResolver {
    private String NAME = NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4HigherUp-000000");

    @Override
    public HashSet<String> queryUsers(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        long beginMills = System.currentTimeMillis();
        try {
            String[] orgPks = this.getParameterValue(billtype, context, parameter, pk_org, prevParticipant);
            ArrayList<String> busiUnitPks = new ArrayList<String>();
            ArrayList<String> deptPks = new ArrayList<String>();
            for (String pk : orgPks) {
                if (OrgTypeManager.getInstance().isTypeOfByPk(pk, "BUSINESSUNIT00000000")) {
                    busiUnitPks.add(pk);
                    continue;
                }
                if (!OrgTypeManager.getInstance().isTypeOfByPk(pk, "DEPTORGTYPE000000000")) continue;
                deptPks.add(pk);
            }
            List<Object> busiUnitPrincipals = new ArrayList();
            if (busiUnitPks.size() > 0) {
                busiUnitPrincipals = this.findPrincipalOfParentOrg(busiUnitPks.toArray(new String[0]));
            }
            ArrayList<String> deptPrincipals = new ArrayList<String>();
            if (deptPks.size() > 0) {
                DeptVO[] depts = WFUserGroupUtil.getDeptQryService().queryDeptVOsByPks(deptPks.toArray(new String[0]));
                StringBuffer whereBuf = new StringBuffer();
                whereBuf.append("pk_dept in (select pk_fatherorg from org_dept where ");
                whereBuf.append(WFUserGroupUtil.buildSqlForIn("pk_dept", deptPks.toArray(new String[0])));
                whereBuf.append(")");
                List parentDepts = (List)WFUserGroupUtil.getUAPQueryBS().retrieveByClause(DeptVO.class, whereBuf.toString());
                HashMap<String, DeptVO[]> tempMap = new HashMap<String, DeptVO[]>();
                for (DeptVO[] dept : parentDepts) {
                    tempMap.put(dept.getPk_dept(), dept);
                }
                ArrayList<String> rootOrgs = new ArrayList<String>();
                for (DeptVO vo : depts) {
                    if (tempMap.containsKey(vo.getPk_fatherorg())) {
                        deptPrincipals.add(((DeptVO)tempMap.get(vo.getPk_fatherorg())).getPrincipal());
                        continue;
                    }
                    rootOrgs.add(vo.getPk_org());
                }
                if (rootOrgs != null && rootOrgs.size() > 0) {
                    Set<String> rootPrincipals = this.findPrincipalOfOrg(rootOrgs.toArray(new String[0]));
                    deptPrincipals.addAll(rootPrincipals);
                }
            }
            ArrayList principals = new ArrayList();
            principals.addAll(busiUnitPrincipals);
            principals.addAll(deptPrincipals);
            Set<String> userOfPrincipal = WFUserGroupUtil.findUserOfPsndoc(principals.toArray(new String[0]));
            if (ArrayUtil.isNull(userOfPrincipal)) {
                IBDData[] principalDatas;
                ArrayList<String> principalsdatas = new ArrayList<String>();
                IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"40d39c26-a2b6-4f16-a018-45664cac1a1f");
                for (IBDData ibddate : principalDatas = acessor.getDocbyPks(principals.toArray(new String[0]))) {
                    if (ibddate == null || null == ibddate.getName()) continue;
                    principalsdatas.add(ibddate.getName().toString());
                }
                if (principalsdatas.size() > 0) {
                    throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Employer-000007", null, new String[]{StringUtil.toString((Object[])principalsdatas.toArray(new String[0]), (String)"],[")}));
                }
            }
            HashSet<String> hashSet = WFUserGroupUtil.filterDisabledUsersWithException(userOfPrincipal);
            return hashSet;
        }
        catch (BusinessException e) {
            throw new BusinessExceptionAdapter(e);
        }
        finally {
            Logger.debug((Object)WFUserGroupUtil.getPerformanceLogString(this.NAME, beginMills));
        }
    }

    private Set<String> findPrincipalOfOrg(String[] pk_orgs) throws BusinessException {
        OrgVO[] orgs = WFUserGroupUtil.getOrgUnitQryService().getOrgs(pk_orgs);
        if (orgs == null) {
            IBDData[] orgDatas;
            ArrayList<String> orgsdatas = new ArrayList<String>();
            IGeneralAccessor acessor = GeneralAccessorFactory.getAccessor((String)"985be8a4-3a36-4778-8afe-2d8ed3902659");
            for (IBDData ibddate : orgDatas = acessor.getDocbyPks(pk_orgs)) {
                orgsdatas.add(ibddate.getName().toString());
            }
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4Employer-000008", null, new String[]{StringUtil.toString((Object[])orgsdatas.toArray(new String[0]), (String)"],[")}));
        }
        HashSet<String> principals = new HashSet<String>();
        for (OrgVO org : orgs) {
            if (principals.contains(org.getPrincipal())) continue;
            principals.add(org.getPrincipal());
        }
        if (principals.size() == 0) {
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4HigherUp-0000"));
        }
        return principals;
    }

    private List<String> findPrincipalOfParentOrg(String[] pk_orgs) throws BusinessException {
        StringBuffer whereBuf = new StringBuffer();
        whereBuf.append("pk_org in (select pk_fatherorg from org_orgs where ");
        whereBuf.append(WFUserGroupUtil.buildSqlForIn("pk_org", pk_orgs));
        whereBuf.append(")");
        List orgList = (List)WFUserGroupUtil.getUAPQueryBS().retrieveByClause(OrgVO.class, whereBuf.toString());
        if (orgList == null || orgList.size() == 0) {
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4HigherUp-0001"));
        }
        ArrayList<String> principals = new ArrayList<String>();
        ArrayList<String> orgNames = new ArrayList<String>();
        for (OrgVO org : orgList) {
            if (StringUtils.isNotEmpty((CharSequence)org.getPrincipal())) {
                principals.add(org.getPrincipal());
            }
            orgNames.add(MultiLangUtil.getSuperVONameOfCurrentLang((SuperVO)org, (String)"name", null));
        }
        if (principals.size() == 0) {
            throw new WfUserGroupResolvingException(NCLangRes4VoTransl.getNCLangRes().getStrByID("wfusergroup", "WfUserGroup4HigherUp-000001", null, new String[]{StringUtil.toString(orgNames, (String)"],[")}));
        }
        return principals;
    }

    private String[] getParameterValue(String billtype, ParticipantFilterContext context, String parameter, String pk_org, String prevParticipant) {
        return WFUserGroupUtil.getParameterValueWithException(this.NAME, context.getBillEntity(), billtype, parameter, pk_org);
    }
}

