/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.workflowqry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nc.bs.framework.common.NCLocator;
import nc.itf.pub.workflowqry.IWorkflowQuery;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFWorkflowQry;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.workflowqry.WorkflowQueryResult;

public abstract class AbstractWorkflowQuery
implements IWorkflowQuery<WorkflowQueryResult> {
    protected static final String WHERE = "#where#";
    IUAPQueryBS baseQryService = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
    IPFWorkflowQry flowQryService = (IPFWorkflowQry)NCLocator.getInstance().lookup(IPFWorkflowQry.class);

    @Override
    public String[] getPKsByCondition(String where) throws BusinessException {
        if (StringUtil.isEmptyWithTrim((String)where)) {
            where = "1=1";
        }
        String sql = this.getPKsSql().replace(WHERE, where);
        List list = (List)this.baseQryService.executeQuery(sql, (ResultSetProcessor)new ColumnListProcessor());
        return list.toArray(new String[0]);
    }

    @Override
    public List<WorkflowQueryResult> getFieldValuesByPKs(String[] pks, String additionalWhere) throws BusinessException {
        List<WorkflowQueryResult> qryResult = this.flowQryService.queryFieldValues(this.buildFieldValuesSql(pks, additionalWhere), this.getRefactorClass());
        return this.rearrange(qryResult, pks);
    }

    @Override
    public List<WorkflowQueryResult> getFieldValues() throws BusinessException {
        return this.flowQryService.queryFieldValues(this.getFieldValuesSql(), this.getRefactorClass());
    }

    public List<WorkflowQueryResult> rearrange(List<WorkflowQueryResult> queryResult, String[] pks) {
        HashMap<String, WorkflowQueryResult> pkEntityMap = new HashMap<String, WorkflowQueryResult>();
        for (WorkflowQueryResult entity : queryResult) {
            pkEntityMap.put(entity.getPrimaryKey(), entity);
        }
        ArrayList<WorkflowQueryResult> rearrangedList = new ArrayList<WorkflowQueryResult>();
        for (String pk : pks) {
            WorkflowQueryResult entity = (WorkflowQueryResult)pkEntityMap.get(pk);
            rearrangedList.add(entity);
        }
        return rearrangedList;
    }

    private String buildFieldValuesSql(String[] pks, String additionalWhere) {
        int i;
        String where = "";
        if (pks != null && pks.length != 0 && pks[0].length() == 0) {
            where = !StringUtil.isEmptyWithTrim((String)additionalWhere) ? where + additionalWhere : " 1=1 ";
            return this.getFieldValuesSql().replace(WHERE, where);
        }
        StringBuffer pkStr = new StringBuffer("('");
        for (i = 0; i < pks.length - 1; ++i) {
            pkStr.append(pks[i]);
            pkStr.append("', '");
        }
        pkStr.append(pks[i]);
        pkStr.append("') ");
        where = where + this.getPkField() + " in " + pkStr.toString();
        if (!StringUtil.isEmptyWithTrim((String)additionalWhere)) {
            where = where + " and " + additionalWhere;
        }
        return this.getFieldValuesSql().replace(WHERE, where);
    }

    public abstract String getRefactorClass();

    public abstract String getPKsSql();

    public abstract String getPkField();

    public abstract String getFieldValuesSql();
}

