/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.busilog;

import nc.bs.busilog.vo.BusinessLogContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.busilog.PFBusiLogUtil;
import nc.vo.pub.busilog.operation.PFOperaEnum;
import nc.vo.pub.pf.Pfi18nTools;
import nc.vo.pub.workflowusergroup.WFUserGroupVO;

public class WfUserGroupBusiLogUtil {
    public static void writeBaseLog(WFUserGroupVO wfUserGroupVO, PFOperaEnum operation) throws BusinessException {
        BusinessLogContext context = WfUserGroupBusiLogUtil.buildLogContext(wfUserGroupVO, operation);
        String logMsg = WfUserGroupBusiLogUtil.buildBaseOperaMsg(wfUserGroupVO, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static BusinessLogContext buildLogContext(WFUserGroupVO wfUserGroupVO, PFOperaEnum operation) {
        BusinessLogContext context = PFBusiLogUtil.createPFBusinessLogContext();
        context.setPk_busiobj(wfUserGroupVO.getPrimaryKey());
        context.setBusiobjcode(wfUserGroupVO.getCode());
        context.setBusiobjname(Pfi18nTools.i18nWfUserGroupName(wfUserGroupVO));
        context.setTypepk_busiobj("05ca7196-4142-4bf1-aca6-ce3dfcb7f7a8");
        context.setBusiobjvo((Object)wfUserGroupVO);
        context.setPk_operation(WfUserGroupBusiLogUtil.getPkOperationByEnum(operation));
        return context;
    }

    private static String buildBaseOperaMsg(WFUserGroupVO wfUserGroupVO, PFOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(operation.toString()).append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0056"));
        sbMsg.append("[").append(Pfi18nTools.i18nWfUserGroupName(wfUserGroupVO)).append("]");
        return sbMsg.toString();
    }

    private static String getPkOperationByEnum(PFOperaEnum operation) {
        if (PFOperaEnum.Add.equals(operation)) {
            return "ee0a4cf1-d740-4f2a-b555-9bbe5163590c";
        }
        if (PFOperaEnum.Edit.equals(operation)) {
            return "922b16b1-fe77-48c7-8904-bdbe76b76ea2";
        }
        if (PFOperaEnum.Delete.equals(operation)) {
            return "e682e12f-252f-47b3-95a3-d7305559dcd7";
        }
        return null;
    }
}

