/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.busilog;

import nc.bs.busilog.vo.BusinessLogContext;
import nc.bs.pf.pub.PfDataCache;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.ExchangeVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.busilog.PFBusiLogUtil;
import nc.vo.pub.busilog.operation.PFOperaEnum;
import nc.vo.pub.pf.Pfi18nTools;

public class VOChangeBusiLogUtil {
    public static void writeBaseLog(ExchangeVO exchangeVO, PFOperaEnum operation) throws BusinessException {
        BusinessLogContext context = VOChangeBusiLogUtil.buildLogContext(exchangeVO, operation);
        String logMsg = VOChangeBusiLogUtil.buildBaseOperaMsg(exchangeVO, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static BusinessLogContext buildLogContext(ExchangeVO exchangeVO, PFOperaEnum operation) {
        BusinessLogContext context = PFBusiLogUtil.createPFBusinessLogContext();
        context.setPk_busiobj(exchangeVO.getPrimaryKey());
        context.setBusiobjcode(VOChangeBusiLogUtil.getSrcType(exchangeVO) + "->" + VOChangeBusiLogUtil.getDestType(exchangeVO));
        context.setBusiobjname(VOChangeBusiLogUtil.getSrcTypeName(exchangeVO) + "->" + VOChangeBusiLogUtil.getDestTypeName(exchangeVO));
        context.setTypepk_busiobj("580c9133-2bff-442a-b136-cf3e44a43a9a");
        context.setBusiobjvo((Object)exchangeVO);
        context.setPk_operation(VOChangeBusiLogUtil.getPkOperationByEnum(operation));
        return context;
    }

    private static String buildBaseOperaMsg(ExchangeVO exchangeVO, PFOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(operation.toString()).append(" ").append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0088") + ",");
        String srcBillTypeName = Pfi18nTools.i18nBilltypeName(exchangeVO.getSrc_billtype());
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0089") + "[").append(srcBillTypeName).append("],");
        if (!StringUtil.isEmptyWithTrim((String)exchangeVO.getSrc_transtype())) {
            BilltypeVO srcTransTypeVO = PfDataCache.getBillTypeInfo(exchangeVO.getPk_group(), exchangeVO.getSrc_transtype());
            String srcTransTypeName = Pfi18nTools.i18nBilltypeNameByVO(exchangeVO.getSrc_transtype(), srcTransTypeVO);
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0090") + "[").append(srcTransTypeName).append("],");
        }
        String destBillTypeName = Pfi18nTools.i18nBilltypeName(exchangeVO.getDest_billtype());
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0091") + "[").append(destBillTypeName).append("],");
        if (!StringUtil.isEmptyWithTrim((String)exchangeVO.getDest_transtype())) {
            BilltypeVO destTransTypeVO = PfDataCache.getBillTypeInfo(exchangeVO.getPk_group(), exchangeVO.getDest_transtype());
            String destTransTypeName = Pfi18nTools.i18nBilltypeNameByVO(exchangeVO.getDest_transtype(), destTransTypeVO);
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0092") + "[").append(destTransTypeName).append("]");
        }
        return sbMsg.toString();
    }

    private static String getPkOperationByEnum(PFOperaEnum operation) {
        if (PFOperaEnum.Add.equals(operation)) {
            return "f8ca8a0e-0a8c-4609-92d8-a9e13a6b989a";
        }
        if (PFOperaEnum.Edit.equals(operation)) {
            return "3d507d81-9051-43d8-ab88-47540fee7876";
        }
        if (PFOperaEnum.Delete.equals(operation)) {
            return "1df23801-2060-4033-aecd-1ffed53537fa";
        }
        return null;
    }

    private static String getSrcTypeName(ExchangeVO exchangeVO) {
        if (!StringUtil.isEmptyWithTrim((String)exchangeVO.getSrc_transtype())) {
            BilltypeVO srcTransType = PfDataCache.getBillTypeInfo(exchangeVO.getPk_group(), exchangeVO.getSrc_transtype());
            if (srcTransType == null) {
                return exchangeVO.getSrc_transtype();
            }
            return Pfi18nTools.i18nBilltypeNameByVO(srcTransType.getPk_billtypecode(), srcTransType);
        }
        return Pfi18nTools.i18nBilltypeName(exchangeVO.getSrc_billtype());
    }

    private static String getDestTypeName(ExchangeVO exchangeVO) {
        if (!StringUtil.isEmptyWithTrim((String)exchangeVO.getDest_transtype())) {
            BilltypeVO destTransType = PfDataCache.getBillTypeInfo(exchangeVO.getPk_group(), exchangeVO.getDest_transtype());
            if (destTransType == null) {
                return "";
            }
            return Pfi18nTools.i18nBilltypeNameByVO(destTransType.getPk_billtypecode(), destTransType);
        }
        return Pfi18nTools.i18nBilltypeName(exchangeVO.getDest_billtype());
    }

    private static String getSrcType(ExchangeVO exchangeVO) {
        if (!StringUtil.isEmptyWithTrim((String)exchangeVO.getSrc_transtype())) {
            return exchangeVO.getSrc_transtype();
        }
        return exchangeVO.getSrc_billtype();
    }

    private static String getDestType(ExchangeVO exchangeVO) {
        if (!StringUtil.isEmptyWithTrim((String)exchangeVO.getDest_transtype())) {
            return exchangeVO.getDest_transtype();
        }
        return exchangeVO.getDest_billtype();
    }
}

