/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pub.busilog;

import nc.bs.busilog.vo.BusinessLogContext;
import nc.bs.pf.pub.PfDataCache;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.BillItfDefVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.busilog.PFBusiLogUtil;
import nc.vo.pub.busilog.operation.PFOperaEnum;
import nc.vo.pub.pf.Pfi18nTools;

public class BillItfDefBusiLogUtil {
    public static void writeBaseLog(BillItfDefVO itfDefVO, PFOperaEnum operation) throws BusinessException {
        BusinessLogContext context = BillItfDefBusiLogUtil.buildLogContext(itfDefVO, operation);
        String logMsg = BillItfDefBusiLogUtil.buildBaseOperaMsg(itfDefVO, operation);
        context.setLogmsg(logMsg);
        PFBusiLogUtil.writeBusiLog(context);
    }

    private static BusinessLogContext buildLogContext(BillItfDefVO itfDefVO, PFOperaEnum operation) {
        BusinessLogContext context = PFBusiLogUtil.createPFBusinessLogContext();
        context.setPk_busiobj(itfDefVO.getPrimaryKey());
        context.setBusiobjcode(BillItfDefBusiLogUtil.getSrcType(itfDefVO) + "->" + BillItfDefBusiLogUtil.getDestType(itfDefVO));
        context.setBusiobjname(BillItfDefBusiLogUtil.getSrcTypeName(itfDefVO) + "->" + BillItfDefBusiLogUtil.getDestTypeName(itfDefVO));
        context.setTypepk_busiobj("de7a4404-4e2a-44ae-9fb1-2e9bc1e9cb6b");
        context.setBusiobjvo((Object)itfDefVO);
        context.setPk_operation(BillItfDefBusiLogUtil.getPKOperationByEnum(operation));
        return context;
    }

    private static String getSrcTypeName(BillItfDefVO itfDefVO) {
        if (!StringUtil.isEmptyWithTrim((String)itfDefVO.getSrc_transtype())) {
            BilltypeVO srcTransType = PfDataCache.getBillTypeInfo(itfDefVO.getPk_group(), itfDefVO.getSrc_transtype());
            if (srcTransType == null) {
                return itfDefVO.getSrc_transtype();
            }
            return Pfi18nTools.i18nBilltypeNameByVO(srcTransType.getPk_billtypecode(), srcTransType);
        }
        return Pfi18nTools.i18nBilltypeName(itfDefVO.getSrc_billtype());
    }

    private static String getDestTypeName(BillItfDefVO itfDefVO) {
        if (!StringUtil.isEmptyWithTrim((String)itfDefVO.getDest_transtype())) {
            BilltypeVO destTransType = PfDataCache.getBillTypeInfo(itfDefVO.getPk_group(), itfDefVO.getDest_transtype());
            return Pfi18nTools.i18nBilltypeNameByVO(destTransType.getPk_billtypecode(), destTransType);
        }
        return Pfi18nTools.i18nBilltypeName(itfDefVO.getDest_billtype());
    }

    private static String getSrcType(BillItfDefVO itfDefVO) {
        if (!StringUtil.isEmptyWithTrim((String)itfDefVO.getSrc_transtype())) {
            return itfDefVO.getSrc_transtype();
        }
        return itfDefVO.getSrc_billtype();
    }

    private static String getDestType(BillItfDefVO itfDefVO) {
        if (!StringUtil.isEmptyWithTrim((String)itfDefVO.getDest_transtype())) {
            return itfDefVO.getDest_transtype();
        }
        return itfDefVO.getDest_billtype();
    }

    private static String buildBaseOperaMsg(BillItfDefVO itfDefVO, PFOperaEnum operation) {
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(operation.toString()).append(" ").append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0093") + ",");
        String srcBillTypeName = Pfi18nTools.i18nBilltypeName(itfDefVO.getSrc_billtype());
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0089") + "[").append(srcBillTypeName).append("],");
        if (!StringUtil.isEmptyWithTrim((String)itfDefVO.getSrc_transtype())) {
            BilltypeVO srcTransTypeVO = PfDataCache.getBillTypeInfo(itfDefVO.getPk_group(), itfDefVO.getSrc_transtype());
            String srcTransTypeName = Pfi18nTools.i18nBilltypeNameByVO(itfDefVO.getSrc_transtype(), srcTransTypeVO);
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0090") + "[").append(srcTransTypeName).append("],");
        }
        String destBillTypeName = Pfi18nTools.i18nBilltypeName(itfDefVO.getDest_billtype());
        sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0091") + "[").append(destBillTypeName).append("],");
        if (!StringUtil.isEmptyWithTrim((String)itfDefVO.getDest_transtype())) {
            BilltypeVO destTransTypeVO = PfDataCache.getBillTypeInfo(itfDefVO.getPk_group(), itfDefVO.getDest_transtype());
            String destTransTypeName = Pfi18nTools.i18nBilltypeNameByVO(itfDefVO.getDest_transtype(), destTransTypeVO);
            sbMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow61_0", "0pfworkflow61-0092") + "[").append(destTransTypeName).append("]");
        }
        return sbMsg.toString();
    }

    private static String getPKOperationByEnum(PFOperaEnum operation) {
        if (PFOperaEnum.Add.equals(operation)) {
            return "8c00d8c8-dac3-4822-b12b-889e5adffbac";
        }
        if (PFOperaEnum.Edit.equals(operation)) {
            return "843aba92-954e-43f8-a9a2-e9389925d326";
        }
        if (PFOperaEnum.Delete.equals(operation)) {
            return "f95bde78-e30b-49bd-8504-404caba642db";
        }
        return null;
    }
}

