/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.term;

import java.util.HashMap;
import java.util.Map;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.itf.uap.pf.IApproveTermService;
import nc.vo.bd.pub.BDCacheFactory;
import nc.vo.cache.ICache;
import nc.vo.cache.ext.ICacheVersionMonitor;
import nc.vo.cache.ext.TableVersionMonitor;
import nc.vo.cache.ext.VersionSensitiveMap;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pf.term.ApproveTermSettingVO;
import nc.vo.pf.term.IApproveTerm;
import nc.vo.pf.term.def.ConfigurableTermList;
import nc.vo.pub.BusinessException;

public class ApproveTermConfig {
    private static String REGION = "platform_termsetting";
    private static final String CACHE_KEY = "CODE_SETTING_MAP";
    private static final long REFRESH_INTERVAL = 60000L;
    private static Map<String, ApproveTermConfig> dsInstanceMap = new HashMap<String, ApproveTermConfig>();
    private Map<String, IApproveTerm> codeTermMap = null;
    private Map<String, Map<String, Map<String, ApproveTermSettingVO>>> keyCacheMap = null;

    private ApproveTermConfig() {
        this.init();
    }

    private void init() {
        if (this.codeTermMap == null) {
            this.codeTermMap = ConfigurableTermList.getTermMap();
        }
        if (this.keyCacheMap == null) {
            ICache cache = BDCacheFactory.getCacheWithFileStratery((String)REGION);
            this.keyCacheMap = new VersionSensitiveMap(cache.toMap(), (ICacheVersionMonitor)new TableVersionMonitor(new String[]{"pub_wf_termsetting"}, 60000L));
        }
    }

    private synchronized Map<String, ApproveTermSettingVO> getCodeSettingMap(String pk_group) {
        Map<String, Map<String, ApproveTermSettingVO>> groupCacheMap = this.keyCacheMap.get(CACHE_KEY);
        if (groupCacheMap == null) {
            groupCacheMap = new HashMap<String, Map<String, ApproveTermSettingVO>>();
            this.keyCacheMap.put(CACHE_KEY, groupCacheMap);
        }
        if (!groupCacheMap.containsKey(pk_group)) {
            Map<String, ApproveTermSettingVO> codeSettingMap = null;
            try {
                codeSettingMap = this.loadTermSettingFromDb(pk_group);
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (codeSettingMap == null) {
                codeSettingMap = new HashMap<String, ApproveTermSettingVO>();
            }
            groupCacheMap.put(pk_group, codeSettingMap);
        }
        return groupCacheMap.get(pk_group);
    }

    private Map<String, ApproveTermSettingVO> loadTermSettingFromDb(String pk_group) throws BusinessException {
        HashMap<String, ApproveTermSettingVO> codeSettingMap = new HashMap<String, ApproveTermSettingVO>();
        IApproveTermService srv = (IApproveTermService)NCLocator.getInstance().lookup(IApproveTermService.class);
        ApproveTermSettingVO[] settings = srv.loadTermSetting(pk_group);
        if (ArrayUtil.isNotNull((Object[])settings)) {
            for (ApproveTermSettingVO s : settings) {
                codeSettingMap.put(s.getTerm_code(), s);
            }
        }
        return codeSettingMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApproveTermConfig getInstance() {
        String ds = InvocationInfoProxy.getInstance().getUserDataSource();
        if (!dsInstanceMap.containsKey(ds)) {
            Map<String, ApproveTermConfig> map = dsInstanceMap;
            synchronized (map) {
                if (!dsInstanceMap.containsKey(ds)) {
                    ApproveTermConfig instance = new ApproveTermConfig();
                    dsInstanceMap.put(ds, instance);
                }
            }
        }
        return dsInstanceMap.get(ds);
    }

    @Deprecated
    public boolean isHidden(String code) {
        return false;
    }

    public String getText(String code) {
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        ApproveTermSettingVO setting = this.getCodeSettingMap(pk_group).get(code);
        if (setting == null) {
            return this.getDefaultText(code);
        }
        String text = setting.getLocalTerm_text();
        if (StringUtil.isEmptyWithTrim((String)text)) {
            return this.getDefaultText(code);
        }
        return text;
    }

    public String getTextWithoutDefault(String code) {
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        ApproveTermSettingVO setting = this.getCodeSettingMap(pk_group).get(code);
        if (setting == null) {
            return "";
        }
        String text = setting.getLocalTerm_text();
        if (StringUtil.isEmptyWithTrim((String)text)) {
            return "";
        }
        return text;
    }

    public synchronized void resetText(String pk_group) {
        Map<String, Map<String, ApproveTermSettingVO>> groupCacheMap = this.keyCacheMap.get(CACHE_KEY);
        Map<String, ApproveTermSettingVO> codeSettingMap = null;
        try {
            codeSettingMap = this.loadTermSettingFromDb(pk_group);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (codeSettingMap == null) {
            codeSettingMap = new HashMap<String, ApproveTermSettingVO>();
        }
        if (groupCacheMap != null) {
            groupCacheMap.put(pk_group, codeSettingMap);
        }
    }

    public String getDefaultText(String code) {
        IApproveTerm term = this.codeTermMap.get(code);
        if (term == null) {
            throw new IllegalArgumentException("Term: " + code + " not configurable!");
        }
        return term.getDefaultText();
    }
}

