/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.NCLocator;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFMobileAppService;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ArrayProcessor;
import nc.jdbc.framework.processor.BeanListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.MultiLangUtil;
import nc.vo.pf.mobileapp.MobileAppUtil;
import nc.vo.pf.mobileapp.TaskMetaData;
import nc.vo.pf.mobileapp.query.IPaginationQuery;
import nc.vo.pub.BusinessException;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.pub.workflowqry.FlowHistoryUtil;
import nc.vo.trade.sqlutil.IInSqlBatchCallBack;
import nc.vo.trade.sqlutil.InSqlBatchCaller;
import nc.vo.wfengine.pub.WFTask;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;

public class ApproveDetailQuery
implements IPaginationQuery<Map<String, Object>> {
    private static final String BILLTYPE = "#billtype#";
    private static final String BILLID = "#billid#";
    private final String SQL = "select pk_checkflow,senddate,dealdate from pub_workflownote where pk_billtype='#billtype#' and billversionpk='#billid#'   and actiontype like 'Z%' order by senddate, dealdate asc";
    private TaskMetaData tmd = null;

    public ApproveDetailQuery(TaskMetaData tmd) {
        this.tmd = tmd;
    }

    @Override
    public String getIdentifier() {
        return this.tmd.getBillType() + this.tmd.getBillId();
    }

    @Override
    public String getPksSql() {
        return "select pk_checkflow,senddate,dealdate from pub_workflownote where pk_billtype='#billtype#' and billversionpk='#billid#'   and actiontype like 'Z%' order by senddate, dealdate asc".replace(BILLTYPE, this.tmd.getBillType()).replace(BILLID, this.tmd.getBillId());
    }

    @Override
    public List<Map<String, Object>> queryByPks(String[] pks) throws BusinessException {
        final IUAPQueryBS qry = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class);
        StringBuffer sb = new StringBuffer();
        String suffix = MultiLangUtil.getCurrentLangSeqSuffix();
        sb.append("select ");
        sb.append("u_t.user_name, ");
        sb.append("u_t.user_name");
        sb.append(suffix);
        sb.append(", ");
        sb.append("i_t.billmaker, i_t.startts,i_t.procstatus from pub_wf_instance i_t left join sm_user u_t on i_t.billmaker=u_t.cuserid  where i_t.billtype=? and i_t.billversionpk=? and i_t.workflow_type=?");
        SQLParameter param = new SQLParameter();
        param.addParam(this.tmd.getBillType());
        param.addParam(this.tmd.getBillId());
        param.addParam(this.tmd.getWorkflow_type());
        Object[] summaries = (Object[])qry.executeQuery(sb.toString(), param, (ResultSetProcessor)new ArrayProcessor());
        final HashMap pkVOMap = new HashMap();
        try {
            InSqlBatchCaller caller = new InSqlBatchCaller(pks);
            caller.execute(new IInSqlBatchCallBack(){

                public Object doWithInSql(String inSql) throws BusinessException, SQLException {
                    String suffix = MultiLangUtil.getCurrentLangSeqSuffix();
                    StringBuffer sb = new StringBuffer();
                    sb.append("select ");
                    sb.append("u_t.user_name");
                    sb.append(suffix);
                    sb.append(" as checknameml, ");
                    sb.append(" u_t.user_name as checkname, w_t.* from pub_workflownote w_t left join sm_user u_t on w_t.checkman=u_t.cuserid");
                    sb.append(" where w_t.pk_checkflow in ");
                    sb.append(inSql);
                    Collection col = (Collection)qry.executeQuery(sb.toString(), (ResultSetProcessor)new BeanListProcessor(WorkflownoteVO.class));
                    if (col != null && col.size() > 0) {
                        for (WorkflownoteVO vo : col) {
                            pkVOMap.put(vo.getPk_checkflow(), vo);
                        }
                    }
                    return null;
                }
            });
        }
        catch (SQLException e) {
            throw new BusinessException((Throwable)e);
        }
        ArrayList<Map<String, Object>> approveHistoryList = MobileAppUtil.createArrayList();
        ArrayList<Map<String, Object>> historyUnitList = MobileAppUtil.createArrayList();
        if (pks.length > 0 && summaries != null) {
            HashMap<String, Object> submitHistoryUnitMap = MobileAppUtil.createHashMap();
            String billmakerName = summaries[0] == null ? null : String.valueOf(summaries[0]);
            String billmakerNameMl = summaries[1] == null ? null : String.valueOf(summaries[1]);
            String billmaker = summaries[2] == null ? null : String.valueOf(summaries[2]);
            String startts = summaries[3] == null ? null : String.valueOf(summaries[3]);
            int procstatus = summaries[4] == null ? 0 : Integer.parseInt(String.valueOf(summaries[4]));
            ArrayList<HashMap<String, Object>> personList = new ArrayList<HashMap<String, Object>>();
            HashMap<String, Object> personMap = MobileAppUtil.createHashMap();
            if (!StringUtil.isEmptyWithTrim((String)billmakerNameMl)) {
                personMap.put("name", billmakerNameMl);
            } else {
                personMap.put("name", billmakerName);
            }
            personMap.put("id", billmaker);
            ArrayList<String> activeList = new ArrayList<String>();
            activeList.add("contact");
            personMap.put("isPerson", activeList);
            personList.add(personMap);
            submitHistoryUnitMap.put("unittype", "submit");
            submitHistoryUnitMap.put("personlist", personList);
            submitHistoryUnitMap.put("time", startts);
            historyUnitList.add(submitHistoryUnitMap);
            IPFMobileAppService srv = (IPFMobileAppService)NCLocator.getInstance().lookup(IPFMobileAppService.class);
            for (int i = 0; i < pks.length; ++i) {
                WorkflownoteVO wvo = (WorkflownoteVO)pkVOMap.get(pks[i]);
                HashMap<String, Object> entry = MobileAppUtil.createHashMap();
                HashMap<String, Object> historyUnitMap = MobileAppUtil.createHashMap();
                if (wvo != null) {
                    boolean isMakebill = "MAKEBILL".equalsIgnoreCase(wvo.getActiontype());
                    String action = WFTask.resolveApproveResult(isMakebill ? null : wvo.getApproveresult());
                    entry.put("approvedid", pks[i]);
                    entry.put("psnid", wvo.getCheckman());
                    entry.put("action", action);
                    entry.put("note", wvo.getChecknote());
                    String handledate = wvo.getDealdate() == null ? "" : wvo.getDealdate().toString();
                    entry.put("handledate", handledate);
                    entry.put("mark", null);
                    entry.put("duration", "");
                    String[] duration = FlowHistoryUtil.getHisDurationsByWorkFlowNotes(new WorkflownoteVO[]{wvo});
                    if (duration != null && duration.length > 0) {
                        entry.put("duration", duration[0]);
                    }
                    if (!StringUtil.isEmptyWithTrim((String)wvo.getChecknameml())) {
                        entry.put("handlername", wvo.getChecknameml());
                    } else {
                        entry.put("handlername", wvo.getCheckname());
                    }
                    Map<String, Object> attMap = srv.getMessageAttachmentList(null, null, pks[i], "ishandled", "handled");
                    entry.putAll(attMap);
                    if (i != pks.length - 1) {
                        historyUnitMap.put("unittype", "solved");
                        historyUnitMap.put("actionname", action);
                        historyUnitMap.put("advice", wvo.getChecknote());
                        historyUnitMap.put("handwriteflag", "N");
                    } else if (procstatus == WfTaskOrInstanceStatus.Finished.getIntValue()) {
                        historyUnitMap.put("unittype", "final");
                        historyUnitMap.put("actionname", action);
                        historyUnitMap.put("advice", wvo.getChecknote());
                        historyUnitMap.put("handwriteflag", "N");
                    } else {
                        historyUnitMap.put("unittype", "handling");
                    }
                    ArrayList<HashMap<String, Object>> personInfos = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> personInfo = MobileAppUtil.createHashMap();
                    if (!StringUtil.isEmptyWithTrim((String)wvo.getChecknameml())) {
                        personInfo.put("name", wvo.getChecknameml());
                    } else {
                        personInfo.put("name", wvo.getCheckname());
                    }
                    personInfo.put("id", billmaker);
                    ArrayList<String> actives = new ArrayList<String>();
                    actives.add("contact");
                    personInfo.put("isPerson", actives);
                    personInfos.add(personInfo);
                    historyUnitMap.put("personlist", personInfos);
                    historyUnitMap.put("mark", null);
                    historyUnitMap.put("remindflag", "N");
                    ArrayList<HashMap<String, Object>> itemlist = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> itemMap = MobileAppUtil.createHashMap();
                    itemMap.put("key", "key");
                    itemMap.put("value", "value");
                    itemlist.add(itemMap);
                    historyUnitMap.put("itemlist", itemlist);
                }
                approveHistoryList.add(entry);
                historyUnitList.add(historyUnitMap);
            }
        }
        ArrayList<Map<String, Object>> resultList = MobileAppUtil.createArrayList();
        HashMap<String, Object> resultMap = MobileAppUtil.createHashMap();
        resultMap.put("approvehistorylinelist", approveHistoryList);
        resultMap.put("flowhistory", historyUnitList);
        resultList.add(resultMap);
        return resultList;
    }
}

