/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.pf.mobileapp.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.bs.framework.common.NCLocator;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.ICacheDataQueryCallback;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.itf.uap.pf.IPFMobileAppService;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.mobileapp.TaskMetaData;
import nc.vo.pf.mobileapp.exception.TaskNotValidException;
import nc.vo.pf.mobileapp.query.TaskQuery;
import nc.vo.pub.BusinessException;
import nc.vo.pub.guid.GuidUtils;
import nc.vo.pub.msg.MessageVO;
import nc.vo.pub.workflownote.WorkflownoteVO;

public abstract class AbstractReceivedQuery
extends TaskQuery {
    protected static final String CHECKMAN = "#checkman#";
    protected static final String WORKFLOWTYPE_IN = "#workflowtype#";
    protected static final String APPROVRESTATUS = "#approvestatus#";
    protected static final String PK_GROUP = "#pk_group#";
    protected static final String SENDDATE = "#senddate#";
    protected static final String STARTTIME = "#starttime#";
    private String SQL = "select note.pk_checkflow,note.senddate from pub_workflownote note where note.actiontype like 'Z%' and note.checkman='#checkman#'  and note.workflow_type in #workflowtype# and note.approvestatus=#approvestatus# and note.pk_group ='#pk_group#'  and note.senddate<'#senddate#'";

    protected String getBaseSql() throws BusinessException {
        int i;
        List<String> list;
        List<String> ret = this.getBillTypeByModuleid(this.getModuleid(), this.getPk_group());
        if (this.getBilltypeOrTranstype() != null && this.getBilltypeOrTranstype().size() > 0 && ret != null && ret.size() > 0) {
            this.getBilltypeOrTranstype().retainAll(ret);
            if (this.getBilltypeOrTranstype() == null || this.getBilltypeOrTranstype().size() == 0) {
                ArrayList<String> fakelist = new ArrayList<String>();
                fakelist.add(GuidUtils.generate());
                this.setBilltypeOrTranstype(fakelist);
            }
        } else if (this.getBilltypeOrTranstype() != null && this.getBilltypeOrTranstype().size() != 0 || ret != null && ret.size() != 0) {
            if ((this.getBilltypeOrTranstype() == null || this.getBilltypeOrTranstype().size() == 0) && ret != null && ret.size() > 0) {
                this.setBilltypeOrTranstype(ret);
            } else if (this.getBilltypeOrTranstype() == null && this.getBilltypeOrTranstype().size() <= 0 || ret == null || ret.size() == 0) {
                // empty if block
            }
        }
        if (!StringUtil.isEmptyWithTrim((String)this.getCondition())) {
            int i2;
            List<String> list2;
            String sql = "select note.pk_checkflow,note.senddate from pub_workflownote note left join sm_msg_approve msg on note.pk_checkflow = msg.pk_detail  where note.actiontype like 'Z%' and note.checkman='#checkman#'  and note.workflow_type in #workflowtype# and note.approvestatus=#approvestatus# and note.pk_group ='#pk_group#'  and note.senddate<'#senddate#' and msg.subject like '%" + this.getCondition() + "%'";
            if (this.getDateAsBegin() != null) {
                sql = sql + "and note.senddate > '" + this.getDateAsBegin() + "'";
            }
            if (this.getBilltypeOrTranstype() != null && this.getBilltypeOrTranstype().size() > 0) {
                sql = sql + "and note.pk_billtype in (";
                list2 = this.getBilltypeOrTranstype();
                for (i2 = 0; i2 < list2.size(); ++i2) {
                    sql = i2 == list2.size() - 1 ? sql + "'" + list2.get(i2) + "')" : sql + "'" + list2.get(i2) + "',";
                }
            }
            if (this.getPk_org() != null && this.getPk_org().size() > 0) {
                sql = sql + "and note.pk_org in (";
                list2 = this.getPk_org();
                for (i2 = 0; i2 < list2.size(); ++i2) {
                    sql = i2 == list2.size() - 1 ? sql + "'" + list2.get(i2) + "')" : sql + "'" + list2.get(i2) + "',";
                }
            }
            return sql + " order by note.senddate desc";
        }
        if (this.getDateAsBegin() != null) {
            this.SQL = this.SQL + "and note.senddate > '" + this.getDateAsBegin() + "'";
        }
        if (this.getBilltypeOrTranstype() != null && this.getBilltypeOrTranstype().size() > 0) {
            this.SQL = this.SQL + "and note.pk_billtype in (";
            list = this.getBilltypeOrTranstype();
            for (i = 0; i < list.size(); ++i) {
                this.SQL = i == list.size() - 1 ? this.SQL + "'" + list.get(i) + "')" : this.SQL + "'" + list.get(i) + "',";
            }
        }
        if (this.getPk_org() != null && this.getPk_org().size() > 0) {
            this.SQL = this.SQL + "and note.pk_org in (";
            list = this.getPk_org();
            for (i = 0; i < list.size(); ++i) {
                this.SQL = i == list.size() - 1 ? this.SQL + "'" + list.get(i) + "')" : this.SQL + "'" + list.get(i) + "',";
            }
        }
        return this.SQL + " order by note.senddate desc";
    }

    @Override
    public List<Map<String, Object>> queryByPks(String[] pks) throws BusinessException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String pk : pks) {
            TaskMetaData tmd = this.queryTaskMetaData(pk);
            Map<String, Object> map = this.convertToTask(tmd);
            list.add(map);
        }
        return list;
    }

    private Map<String, Object> convertToTask(TaskMetaData tmd) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskid", tmd.getPk_checkflow());
        map.put("date", tmd.getStartDate());
        map.put("title", tmd.getTitle());
        map.put("modulecode", tmd.getModulecode());
        map.put("billtype", tmd.getBillType());
        map.put("moduleid", this.getParentCode(tmd.getModulecode()));
        map.put("canbatch", this.getBatchLable(tmd).get("canbatch"));
        map.put("workflowtype", this.getBatchLable(tmd).get("workflowtype"));
        return map;
    }

    private String getParentCode(String modulecode) throws BusinessException {
        IPFMobileAppService service = (IPFMobileAppService)NCLocator.getInstance().lookup(IPFMobileAppService.class);
        String moduleid = service.getParentCode(modulecode);
        return moduleid;
    }

    private HashMap<String, String> getBatchLable(TaskMetaData tmd) throws BusinessException {
        IPFMobileAppService service = (IPFMobileAppService)NCLocator.getInstance().lookup(IPFMobileAppService.class);
        HashMap<String, String> batchLable = service.addBatchLable(tmd);
        return batchLable;
    }

    @Override
    public TaskMetaData queryTaskMetaData(final String pk) throws BusinessException {
        CondStringKey key = new CondStringKey("mobileapp_received_querytaskmetadata", pk);
        ICacheDataQueryCallback<TaskMetaData> callback = new ICacheDataQueryCallback<TaskMetaData>(){

            public TaskMetaData queryData() throws BusinessException {
                WorkflownoteVO note = (WorkflownoteVO)AbstractReceivedQuery.this.getQueryService().retrieveByPK(WorkflownoteVO.class, pk);
                if (note == null) {
                    throw new TaskNotValidException();
                }
                String devModel = AbstractReceivedQuery.this.getPFMetaModelService().queryModuleOfBilltype(note.getPk_billtype());
                return AbstractReceivedQuery.this.convertToMeta(note, devModel);
            }
        };
        return (TaskMetaData)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }

    private TaskMetaData convertToMeta(WorkflownoteVO note, String devModel) {
        TaskMetaData tmd = new TaskMetaData();
        tmd.setBillType(note.getPk_billtype());
        tmd.setBillId(note.getBillVersionPK());
        tmd.setBillNo(note.getBillno());
        tmd.setCuserid(note.getCheckman());
        tmd.setPk_checkflow(note.getPrimaryKey());
        tmd.setTitle(MessageVO.getMessageNoteAfterI18N(note.getMessagenote()));
        tmd.setStartDate(note.getSenddate().toString());
        tmd.setWorkflow_type(note.getWorkflow_type() == 6 ? 4 : note.getWorkflow_type());
        tmd.setModulecode(devModel);
        return tmd;
    }
}

