/*
 * Decompiled with CFR 0.152.
 */
package nc.ui.pub.workflownote.msgtemp;

import nc.bs.framework.common.NCLocator;
import nc.message.mestemptype.itf.IMestemptypeQueryService;
import nc.message.mestemptype.itf.IMestemptypeService;
import nc.message.templet.vo.MsgtmptypeVO;
import nc.ui.pub.workflownote.msgtemp.IMsgTempType;
import nc.ui.pub.workflownote.msgtemp.IMsgTempTypeRegister;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.MultiLangText;
import nccloud.commons.lang.ArrayUtils;
import uap.apppf.util.SQLTransferMeaningUtil;

public abstract class AbstractMsgTempTypeRegister2
implements IMsgTempTypeRegister {
    private IMestemptypeQueryService qryService;
    private IMestemptypeService persistService;

    @Override
    public MsgtmptypeVO registerMsgTempType(Object obj) throws BusinessException {
        IMsgTempType type = this.convertToType(obj);
        return this.register(type);
    }

    protected MsgtmptypeVO register(IMsgTempType type) throws BusinessException {
        IMsgTempType parent = type.getParentType();
        String pk_parent = this.getParentPk(parent);
        MsgtmptypeVO typeVO = this.getMsgtmptypeVO(pk_parent, type);
        return this.saveAndReturn(typeVO);
    }

    protected MsgtmptypeVO isTypeExist(IMsgTempType type) throws BusinessException {
        String code = type.getTypeCode();
        if (code == null) {
            return null;
        }
        String cond = "LOWER(tempcode)='" + SQLTransferMeaningUtil.tmsql((String)code.toLowerCase()) + "'";
        Object[] vos = this.getQryService().queryMsgtmptypeVOByCondition(cond);
        if (ArrayUtils.isEmpty((Object[])vos)) {
            return null;
        }
        return vos[0];
    }

    public abstract IMsgTempType convertToType(Object var1) throws BusinessException;

    protected MsgtmptypeVO beforeSave(MsgtmptypeVO typeVO) throws BusinessException {
        return typeVO;
    }

    public IMestemptypeQueryService getQryService() {
        if (this.qryService == null) {
            this.qryService = (IMestemptypeQueryService)NCLocator.getInstance().lookup(IMestemptypeQueryService.class);
        }
        return this.qryService;
    }

    public IMestemptypeService getPersistService() {
        if (this.persistService == null) {
            this.persistService = (IMestemptypeService)NCLocator.getInstance().lookup(IMestemptypeService.class);
        }
        return this.persistService;
    }

    private MsgtmptypeVO saveAndReturn(MsgtmptypeVO typeVO) throws BusinessException {
        boolean typeExists;
        boolean bl = typeExists = (typeVO = this.beforeSave(typeVO)).getPrimaryKey() != null;
        if (typeExists) {
            return this.getPersistService().updateMsgtmptypeVO(typeVO);
        }
        return this.getPersistService().insertMsgtmptypeVO(typeVO);
    }

    private String getParentPk(IMsgTempType parent) throws BusinessException {
        String pk_parent = null;
        if (parent != null) {
            MsgtmptypeVO parentVO = this.isTypeExist(parent);
            if (parentVO == null) {
                parentVO = this.register(parent);
            }
            pk_parent = parentVO.getPrimaryKey();
        }
        return pk_parent;
    }

    private MsgtmptypeVO getMsgtmptypeVO(String pk_parent, IMsgTempType type) throws BusinessException {
        MsgtmptypeVO typeVO = this.isTypeExist(type);
        if (typeVO == null) {
            typeVO = new MsgtmptypeVO();
        }
        typeVO.setParentpk(pk_parent);
        MultiLangText typeName = type.getTypeName();
        if (typeName != null) {
            typeVO.setName(typeName.getText());
            typeVO.setName2(typeName.getText2());
            typeVO.setName3(typeName.getText3());
            typeVO.setName4(typeName.getText4());
            typeVO.setName5(typeName.getText5());
            typeVO.setName6(typeName.getText6());
        } else {
            typeVO.setName("");
        }
        typeVO.setTempcode(type.getTypeCode());
        typeVO.setMetaid(type.getTypeMetaID());
        typeVO.setTmpvars(type.getTypeMsgtempvarVOs());
        return typeVO;
    }
}

