/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.uap.pf.functioncopy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.functioncopy.IPFFunctionCopyPlugin;
import nc.itf.uap.bbd.func.IFuncRegisterQueryService;
import nc.itf.uap.bbd.func.IFuncRegisterService;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.billtype2.ExtendedClassEnum;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.pf.workflow.WFActivityFuncodeVO;
import nc.vo.pub.pftemplate.FunccodetocodeVO;
import nc.vo.pub.transtype.TranstypePublishNodeVO;
import nc.vo.querytemplate.queryscheme.QuerySchemeVO;
import nc.vo.sm.funcreg.FuncRegisterVO;
import nc.vo.sm.funcreg.MenuItemVO;
import nc.vo.sm.funcreg.MenuRegisterVO;
import nc.vo.sm.funcreg.ParamRegVO;
import nc.vo.uap.pf.PFBusinessException;
import uap.apppf.util.SQLTransferMeaningUtil;

public class PFFunctionCopyUtils {
    public static final String TRANSTYPE_PUBLISH_PARAM = "transtype";
    public static final String TRANSTYPE_PK_PARAM = "pk_transtype";

    public static String publishFuncNode(BilltypeVO parentBilltypeVO, BilltypeVO newBilltypeVO, String srcFuncode, String menuItemCode, boolean isExecFunc) throws BusinessException {
        String parentNodecode = srcFuncode;
        return PFFunctionCopyUtils.cPublishFuncNode(parentBilltypeVO, newBilltypeVO, parentNodecode, menuItemCode, isExecFunc);
    }

    public static String publishFuncNode(BilltypeVO parentBilltypeVO, BilltypeVO newBilltypeVO, String menuItemCode, boolean isExecFunc) throws BusinessException {
        String parentNodecode = parentBilltypeVO.getWebNodecode();
        if (isExecFunc || StringUtil.isEmptyWithTrim((String)parentNodecode)) {
            parentNodecode = parentBilltypeVO.getNodecode();
        }
        return PFFunctionCopyUtils.cPublishFuncNode(parentBilltypeVO, newBilltypeVO, parentNodecode, menuItemCode, isExecFunc);
    }

    public static String publishFuncNode(BilltypeVO parentBilltypeVO, BilltypeVO newBilltypeVO, TranstypePublishNodeVO nodeVo) throws BusinessException {
        String parentNodecode = nodeVo.getFuncode();
        return PFFunctionCopyUtils.cPublishFuncNode(parentBilltypeVO, newBilltypeVO, parentNodecode, nodeVo);
    }

    private static String cPublishFuncNode(BilltypeVO parentBilltypeVO, BilltypeVO newBilltypeVO, String parentNodecode, TranstypePublishNodeVO nodeVo) throws BusinessException {
        FuncRegisterVO funcvo = PFFunctionCopyUtils.getFuncregisteQryService().queryFunctionByCode(parentNodecode);
        if (funcvo == null) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PFFunctionCopyUtils-000000", null, new String[]{parentNodecode}));
        }
        String funname = nodeVo.getMenuName();
        if (StringUtil.isEmptyWithTrim((String)funname)) {
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow65", "PFFunctionCopyUtils-0001"));
        }
        FuncRegisterVO newFuncVO = PFFunctionCopyUtils.getFuncregService().copyFunctionAddGroup(funcvo.getFuncode(), funname, InvocationInfoProxy.getInstance().getGroupId());
        if (newFuncVO == null) {
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630003") + funcvo.getFuncode());
        }
        boolean isExecFunc = nodeVo.isWebNode();
        if (!isExecFunc && funcvo.getFun_property() != 6) {
            newFuncVO.setFun_property(Integer.valueOf(6));
            newFuncVO = PFFunctionCopyUtils.getFuncregService().updateFunctionRegVO(newFuncVO);
        }
        String newNodecode = newFuncVO.getFuncode();
        String menuItemCode = nodeVo.getMenuCode();
        PFFunctionCopyUtils.insertMenuItemReg(newNodecode, menuItemCode, funname);
        BaseDAO baseDAO = new BaseDAO();
        if (nodeVo.isMakeBill() && !nodeVo.isBoth()) {
            newBilltypeVO.setNodecode(newNodecode);
        } else if (!nodeVo.isMakeBill() && !nodeVo.isBoth()) {
            newBilltypeVO.setClassname(newNodecode);
        } else if (nodeVo.isBoth()) {
            newBilltypeVO.setNodecode(newNodecode);
            newBilltypeVO.setClassname(newNodecode);
        }
        baseDAO.updateVO((SuperVO)newBilltypeVO);
        ParamRegVO paramVO = new ParamRegVO();
        paramVO.setParamname(TRANSTYPE_PUBLISH_PARAM);
        paramVO.setParamvalue(newBilltypeVO.getPk_billtypecode());
        paramVO.setParentid(newFuncVO.getPrimaryKey());
        ParamRegVO paramVO1 = new ParamRegVO();
        paramVO1.setParamname(TRANSTYPE_PK_PARAM);
        paramVO1.setParamvalue(newBilltypeVO.getPk_billtypeid());
        paramVO1.setParentid(newFuncVO.getPrimaryKey());
        baseDAO.insertVOArray((SuperVO[])new ParamRegVO[]{paramVO, paramVO1});
        WFActivityFuncodeVO actFuncVO = new WFActivityFuncodeVO();
        actFuncVO.setBilltype(newBilltypeVO.getPk_billtypecode());
        actFuncVO.setPk_billtypeid(newBilltypeVO.getPk_billtypeid());
        actFuncVO.setFuncode(newFuncVO.getFuncode());
        if (nodeVo.isMakeBill() && !nodeVo.isBoth()) {
            actFuncVO.setIsmakebill(UFBoolean.TRUE);
            PFFunctionCopyUtils.insertBilltypeRefFunc(actFuncVO);
        } else if (!nodeVo.isMakeBill() && !nodeVo.isBoth()) {
            actFuncVO.setIsmakebill(UFBoolean.FALSE);
            PFFunctionCopyUtils.insertBilltypeRefFunc(actFuncVO);
        } else if (nodeVo.isBoth()) {
            actFuncVO.setIsmakebill(UFBoolean.TRUE);
            PFFunctionCopyUtils.insertBilltypeRefFunc(actFuncVO);
            WFActivityFuncodeVO actFuncVO2 = new WFActivityFuncodeVO();
            actFuncVO2.setBilltype(newBilltypeVO.getPk_billtypecode());
            actFuncVO2.setPk_billtypeid(newBilltypeVO.getPk_billtypeid());
            actFuncVO2.setFuncode(newFuncVO.getFuncode());
            actFuncVO2.setIsmakebill(UFBoolean.FALSE);
            PFFunctionCopyUtils.insertBilltypeRefFunc(actFuncVO2);
        }
        return newNodecode;
    }

    private static String cPublishFuncNode(BilltypeVO parentBilltypeVO, BilltypeVO newBilltypeVO, String parentNodecode, String menuItemCode, boolean isExecFunc) throws BusinessException {
        FuncRegisterVO funcvo = PFFunctionCopyUtils.getFuncregisteQryService().queryFunctionByCode(parentNodecode);
        if (funcvo == null) {
            throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("busitype", "PFFunctionCopyUtils-000000", null, new String[]{parentNodecode}));
        }
        String funname = newBilltypeVO.getBilltypenameOfCurrLang();
        if (StringUtil.isEmptyWithTrim((String)funname)) {
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630002"));
        }
        FuncRegisterVO newFuncVO = PFFunctionCopyUtils.getFuncregService().copyFunctionAddGroup(funcvo.getFuncode(), funname, InvocationInfoProxy.getInstance().getGroupId());
        if (newFuncVO == null) {
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow63", "0pfworkflow630003") + funcvo.getFuncode());
        }
        if (!isExecFunc && funcvo.getFun_property() != 6) {
            newFuncVO.setFun_property(Integer.valueOf(6));
            newFuncVO = PFFunctionCopyUtils.getFuncregService().updateFunctionRegVO(newFuncVO);
        }
        String newNodecode = newFuncVO.getFuncode();
        PFFunctionCopyUtils.insertMenuItemReg(newNodecode, menuItemCode, funname);
        BaseDAO baseDAO = new BaseDAO();
        if (!isExecFunc) {
            if (StringUtil.isEmptyWithTrim((String)newBilltypeVO.getWebNodecode())) {
                newBilltypeVO.setWebNodecode(newNodecode);
                newBilltypeVO.setClassname(newNodecode);
                baseDAO.updateVO((SuperVO)newBilltypeVO);
            }
        } else if (StringUtil.isEmptyWithTrim((String)newBilltypeVO.getNodecode()) || newBilltypeVO.getNodecode().equals(parentBilltypeVO.getNodecode())) {
            newBilltypeVO.setNodecode(newNodecode);
            newBilltypeVO.setClassname(newNodecode);
            baseDAO.updateVO((SuperVO)newBilltypeVO);
        }
        ParamRegVO paramVO = new ParamRegVO();
        paramVO.setParamname(TRANSTYPE_PUBLISH_PARAM);
        paramVO.setParamvalue(newBilltypeVO.getPk_billtypecode());
        paramVO.setParentid(newFuncVO.getPrimaryKey());
        ParamRegVO paramVO1 = new ParamRegVO();
        paramVO1.setParamname(TRANSTYPE_PK_PARAM);
        paramVO1.setParamvalue(newBilltypeVO.getPk_billtypeid());
        paramVO1.setParentid(newFuncVO.getPrimaryKey());
        baseDAO.insertVOArray((SuperVO[])new ParamRegVO[]{paramVO, paramVO1});
        PFFunctionCopyUtils.insertFunccodetocode(newBilltypeVO.getPk_billtypecode(), newNodecode, isExecFunc);
        return newNodecode;
    }

    private static void insertMenuItemReg(String newNodecode, String menuItemCode, String funname) throws BusinessException {
        MenuItemVO menuItemVO = new MenuItemVO();
        menuItemVO.setFuncode(newNodecode);
        menuItemVO.setMenuitemcode(menuItemCode);
        menuItemVO.setMenuitemname(funname);
        menuItemVO.setMenudes(TRANSTYPE_PUBLISH_PARAM);
        menuItemVO.setIsmenutype(UFBoolean.FALSE);
        try {
            MenuRegisterVO menuRegVO = PFFunctionCopyUtils.getFuncregisteQryService().getEnabledMenuVO(true);
            menuItemVO.setPk_menu(menuRegVO.getPk_menu());
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PFBusinessException(e.getMessage());
        }
        PFFunctionCopyUtils.getFuncregService().insertMenuItem(menuItemVO);
    }

    private static void insertBilltypeRefFunc(WFActivityFuncodeVO actFuncVO) throws BusinessException {
        BaseDAO dao = new BaseDAO();
        if (UFBoolean.TRUE.equals((Object)actFuncVO.getIsmakebill())) {
            String updateSql = "update bd_billtype_func set ismakebill='N' where billtype='" + actFuncVO.getBilltype() + "' and ismakebill='Y'";
            dao.executeUpdate(updateSql);
        }
        dao.insertVO((SuperVO)actFuncVO);
    }

    private static void insertFunccodetocode(String billtypecode, String newNodecode, boolean isExecFunc) throws BusinessException {
        StringBuilder whereSql = new StringBuilder("billtype='").append(billtypecode).append("'");
        if (!isExecFunc) {
            whereSql.append(" and nodetype=").append(6);
        }
        BaseDAO baseDAO = new BaseDAO();
        Collection col = baseDAO.retrieveByClause(FunccodetocodeVO.class, whereSql.toString());
        FunccodetocodeVO tmpVO = new FunccodetocodeVO();
        tmpVO.setBilltype(billtypecode);
        tmpVO.setNodecode(newNodecode);
        if (!isExecFunc) {
            tmpVO.setNodetype(Integer.valueOf(6));
        }
        if (col == null || col.size() == 0) {
            tmpVO.setMainnodecode(newNodecode);
        } else {
            FunccodetocodeVO retVO = (FunccodetocodeVO)col.iterator().next();
            tmpVO.setMainnodecode(retVO.getMainnodecode());
        }
        baseDAO.insertVO((SuperVO)tmpVO);
    }

    private static IFuncRegisterQueryService getFuncregisteQryService() {
        return (IFuncRegisterQueryService)NCLocator.getInstance().lookup(IFuncRegisterQueryService.class.getName());
    }

    private static IFuncRegisterService getFuncregService() {
        return (IFuncRegisterService)NCLocator.getInstance().lookup(IFuncRegisterService.class.getName());
    }

    public static ArrayList<FuncRegisterVO> deleteFuncregVO(BilltypeVO[] billtypevos) throws BusinessException {
        if (billtypevos == null || billtypevos.length == 0) {
            return null;
        }
        BaseDAO dao = new BaseDAO();
        ArrayList<FuncRegisterVO> delFuncVOs = new ArrayList<FuncRegisterVO>();
        for (BilltypeVO btvo : billtypevos) {
            String[] funCodes;
            if (!btvo.getIsPublished().booleanValue() || (funCodes = PFFunctionCopyUtils.getAllInFuncode(btvo.getNodecode())) == null || funCodes.length == 0) continue;
            delFuncVOs.addAll(Arrays.asList(PFFunctionCopyUtils.getFuncregisteQryService().queryFunctionsByCodes(funCodes)));
            for (String funcode : funCodes) {
                PFFunctionCopyUtils.getFuncregService().deleteFunction(funcode);
            }
        }
        dao.deleteByClause(WFActivityFuncodeVO.class, PFFunctionCopyUtils.buildBatchDelSql(billtypevos, "funcode"));
        dao.deleteByClause(QuerySchemeVO.class, PFFunctionCopyUtils.buildBatchDelSql(billtypevos, "funcode"));
        return delFuncVOs;
    }

    private static String buildBatchDelSql(BilltypeVO[] vos, String fieldName) {
        if (vos == null || vos.length == 0) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(fieldName + " in(");
        for (int i = 0; i < vos.length - 1; ++i) {
            sql.append("'" + SQLTransferMeaningUtil.tmsql((String)vos[i].getNodecode()) + "'");
            sql.append(",");
        }
        sql.append("'" + vos[vos.length - 1].getNodecode() + "'");
        sql.append(")");
        return sql.toString();
    }

    private static String[] getAllInFuncode(String funcode) throws BusinessException {
        BaseDAO dao = new BaseDAO();
        Collection col = dao.retrieveByClause(WFActivityFuncodeVO.class, "funcode = '" + SQLTransferMeaningUtil.tmsql((String)funcode) + "'");
        if (col == null || col.size() == 0) {
            return null;
        }
        String[] funCodes = new String[col.size()];
        int i = 0;
        for (WFActivityFuncodeVO retVO : col) {
            funCodes[i++] = retVO.getFuncode();
        }
        return funCodes;
    }

    public static void executePluginWhenInsert(BilltypeVO srcBilltypeVO, BilltypeVO newBilltypeVO) throws BusinessException {
        String clzName = PFFunctionCopyUtils.getFunctionPluginClass(srcBilltypeVO.getPk_billtypecode());
        if (clzName == null) {
            Logger.warn((Object)("[Platform]\u6267\u884c\u529f\u80fd\u590d\u5236([billtypecode]=" + srcBilltypeVO.getPk_billtypecode() + "),\u4f46\u662f\u6ca1\u6709\u5b9e\u73b0\u5bf9\u5e94\u63d2\u4ef6\u7c7b"));
        } else {
            try {
                Object objImpl = Class.forName(clzName).newInstance();
                if (objImpl instanceof IPFFunctionCopyPlugin) {
                    Logger.warn((Object)("[Platform]\u6267\u884c\u529f\u80fd\u590d\u5236([billtypecode]=" + srcBilltypeVO.getPk_billtypecode() + "),\u63d2\u4ef6\u7c7b\u4e3a:" + clzName));
                    ((IPFFunctionCopyPlugin)objImpl).excuteCopyBill(srcBilltypeVO, newBilltypeVO);
                } else {
                    Logger.warn((Object)("[Platform]\u6267\u884c\u529f\u80fd\u590d\u5236([billtypecode]=" + srcBilltypeVO.getPk_billtypecode() + "),\u63d2\u4ef6\u7c7b\u975e\u63a5\u53e3IPFFunctionCopyPlugin\u7c7b\u578b"));
                }
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PFBusinessException(e.getMessage());
            }
        }
    }

    public static void executePluginWhenDelete(BilltypeVO btvo, String parentBilltypecode) throws BusinessException {
        String clzName = PFFunctionCopyUtils.getFunctionPluginClass(btvo.getPk_billtypecode());
        if (clzName == null) {
            Logger.warn((Object)"[Platform]\u6267\u884c\u529f\u80fd\u590d\u5236,\u4f46\u662f\u6ca1\u6709\u5b9e\u73b0\u5bf9\u5e94\u63d2\u4ef6\u7c7b");
        } else {
            try {
                Object objImpl = Class.forName(clzName).newInstance();
                if (objImpl instanceof IPFFunctionCopyPlugin) {
                    ((IPFFunctionCopyPlugin)objImpl).excuteDeleteBill(btvo, parentBilltypecode);
                } else {
                    Logger.warn((Object)"[Platform]\u6267\u884c\u529f\u80fd\u590d\u5236,\u63d2\u4ef6\u7c7b\u975e\u63a5\u53e3IPFFunctionCopyPlugin\u7c7b\u578b");
                }
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PFBusinessException(e.getMessage());
            }
        }
    }

    private static String getFunctionPluginClass(String srctypecode) throws DAOException {
        BaseDAO dao = new BaseDAO();
        String condition = " pk_billtype = '" + srctypecode + "' and classtype=" + ExtendedClassEnum.FUNCTION_COPY.getIntValue();
        Collection type2vos = dao.retrieveByClause(Billtype2VO.class, condition);
        if (type2vos != null && type2vos.size() > 0) {
            return ((Billtype2VO)((Object)type2vos.iterator().next())).getClassname();
        }
        return null;
    }
}

