/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pflock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nc.bs.logging.Logger;
import nc.bs.ml.NCLangResOnserver;
import nc.bs.pub.pflock.IConsistenceCheck;
import nc.jdbc.framework.JdbcSession;
import nc.jdbc.framework.PersistenceManager;
import nc.jdbc.framework.exception.DbException;
import nc.jdbc.framework.processor.ArrayListProcessor;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.md.data.access.NCObject;
import nc.md.model.IBusinessEntity;
import nc.uap.pf.metadata.PfMetadataTools;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pub.BusinessException;

public class VOConsistenceCheck
implements IConsistenceCheck {
    protected Object m_vo = null;
    protected String m_billtype = null;

    public VOConsistenceCheck(Object vo) {
        this.m_vo = vo;
    }

    public VOConsistenceCheck(Object vo, String billtype) {
        this.m_vo = vo;
        this.m_billtype = billtype;
    }

    @Override
    public void checkConsistence() throws BusinessException {
        try {
            NCObject ncObject = NCObject.newInstance((Object)this.m_vo);
            if (ncObject.getAttributeValue("ts") == null) {
                return;
            }
            String[] tableNameAndPKField = this.getTableNameAndPKField();
            String tableName = tableNameAndPKField[0];
            String pkField = tableNameAndPKField[1];
            String pkValue = (String)NCObject.newInstance((Object)this.m_vo).getAttributeValue(pkField);
            String sqlTs = "select ts from " + tableName + " where " + pkField + "='" + pkValue + "'";
            String tsInDB = this.queryTs(sqlTs);
            if (tsInDB == null) {
                throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "UPPpfworkflow-000603"));
            }
            if (!tsInDB.equals(NCObject.newInstance((Object)this.m_vo).getAttributeValue("ts").toString())) {
                throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "UPPpfworkflow-000604"));
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    private String[] getTableNameAndPKField() throws BusinessException {
        String[] resultArray = new String[2];
        IBusinessEntity bean = PfMetadataTools.queryMetaOfBilltype(this.m_billtype);
        resultArray[0] = bean.getTable().getName();
        resultArray[1] = bean.getTable().getPrimaryKeyName();
        return resultArray;
    }

    protected void checkConsistenceAry(Object[] itemVos) throws BusinessException {
        if (itemVos == null || itemVos.length == 0) {
            return;
        }
        try {
            ArrayList<String> pkAry = new ArrayList<String>();
            HashMap<String, Object> oldTsMap = new HashMap<String, Object>();
            HashMap<Object, Object> newTsMap = new HashMap<Object, Object>();
            for (int i = 0; i < itemVos.length; ++i) {
                Object itemVo = itemVos[i];
                NCObject ncObject = NCObject.newInstance((Object)itemVo);
                Object tsValue = ncObject.getAttributeValue("ts");
                IBusinessEntity be = PfMetadataTools.queryMetaOfBilltype(this.m_billtype);
                String keyValue = (String)ncObject.getAttributeValue(be.getKeyAttribute());
                if (tsValue == null || StringUtil.isEmptyWithTrim((String)keyValue)) continue;
                pkAry.add(keyValue);
                oldTsMap.put(keyValue, tsValue);
            }
            String[] tableNameAndPKField = this.getTableNameAndPKField();
            String[] strTemp = this.getTsSqlStr(pkAry, tableNameAndPKField[0], tableNameAndPKField[1]);
            for (int i = 0; i < strTemp.length; ++i) {
                List lResult = this.getTsChanged(strTemp[i]);
                for (Object[] objs : lResult) {
                    newTsMap.put(objs[0], objs[1]);
                }
            }
            for (Object key : oldTsMap.keySet()) {
                String strNewTs;
                String strOldTs = String.valueOf(oldTsMap.get(key));
                if (strOldTs.equals(strNewTs = (String)newTsMap.get(key))) continue;
                throw new BusinessException(NCLangResOnserver.getInstance().getStrByID("pfworkflow", "UPPpfworkflow-000604"));
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryTs(String strTsSql) throws DbException {
        PersistenceManager persist = null;
        try {
            persist = PersistenceManager.getInstance();
            JdbcSession jdbc = persist.getJdbcSession();
            Object objTs = jdbc.executeQuery(strTsSql, (ResultSetProcessor)new ColumnProcessor());
            String string = objTs == null ? null : objTs.toString();
            return string;
        }
        finally {
            if (persist != null) {
                persist.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getTsChanged(String strSql) throws DbException {
        PersistenceManager persist = null;
        try {
            List lRet;
            persist = PersistenceManager.getInstance();
            JdbcSession jdbc = persist.getJdbcSession();
            List list = lRet = (List)jdbc.executeQuery(strSql, (ResultSetProcessor)new ArrayListProcessor());
            return list;
        }
        finally {
            if (persist != null) {
                persist.release();
            }
        }
    }

    private static String[] getSplitSqlIn(ArrayList pkAry) {
        int PACKAGESIZE = 400;
        int fixedPKLength = pkAry.size();
        int numofPackage = fixedPKLength / PACKAGESIZE + (fixedPKLength % PACKAGESIZE > 0 ? 1 : 0);
        String[] strTemp = new String[numofPackage];
        for (int s = 0; s < numofPackage; ++s) {
            String newStr;
            StringBuffer strArys = new StringBuffer();
            int beginIndex = s * PACKAGESIZE;
            int endindex = beginIndex + PACKAGESIZE;
            if (endindex > fixedPKLength) {
                endindex = fixedPKLength;
            }
            for (int i = beginIndex; i < endindex; ++i) {
                strArys.append("'");
                strArys.append(pkAry.get(i));
                strArys.append("',");
            }
            strTemp[s] = newStr = "(" + strArys.substring(0, strArys.length() - 1) + ")";
        }
        return strTemp;
    }

    private String[] getTsSqlStr(ArrayList pkAry, String tableName, String fieldName) {
        String[] strTemp = VOConsistenceCheck.getSplitSqlIn(pkAry);
        for (int i = 0; i < strTemp.length; ++i) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("select ");
            sqlBuffer.append(fieldName);
            sqlBuffer.append(",ts from ");
            sqlBuffer.append(tableName);
            sqlBuffer.append(" where ");
            sqlBuffer.append(fieldName);
            sqlBuffer.append(" in ");
            sqlBuffer.append(strTemp[i]);
            strTemp[i] = sqlBuffer.toString();
        }
        return strTemp;
    }
}

