/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pf.busistate;

import nc.bs.dao.BaseDAO;
import nc.bs.logging.Logger;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.md.data.access.NCObject;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.compiler.PfParameterVO;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.uap.pf.PFBusinessException;

public abstract class AbstractBusiStateCallback {
    private void execApproveGoing(PfParameterVO paraVo) throws Exception {
        Logger.info((Object)"****\u6267\u884c\u5ba1\u6279\u901a\u8fc7execApproveGoing\u5f00\u59cb****");
        this.changeStatusWhenApprove(paraVo, 2);
        Logger.info((Object)"****\u6267\u884c\u5ba1\u6279\u901a\u8fc7execApproveGoing\u7ed3\u675f****");
    }

    protected abstract String[] getTableInfo(String var1) throws BusinessException;

    protected abstract void changeStatusWhenApprove(PfParameterVO var1, int var2) throws Exception;

    protected abstract void changeStatusWhenUnapprove(PfParameterVO var1, String var2, int var3) throws Exception;

    private void execApproveNoPass(PfParameterVO paraVo) throws Exception {
        Logger.info((Object)"****\u6267\u884c\u5ba1\u6279\u672a\u901a\u8fc7execApproveNoPass\u5f00\u59cb****");
        this.changeStatusWhenApprove(paraVo, 0);
        Logger.info((Object)"****\u6267\u884c\u5ba1\u6279\u672a\u901a\u8fc7execApproveNoPass\u7ed3\u675f****");
    }

    private void execApprovePass(PfParameterVO paraVo) throws Exception {
        Logger.info((Object)"****\u6267\u884c\u5ba1\u6279\u901a\u8fc7execApprovePass\u5f00\u59cb****");
        this.changeStatusWhenApprove(paraVo, 1);
        Logger.info((Object)"****\u6267\u884c\u5ba1\u6279\u901a\u8fc7execApprovePass\u7ed3\u675f****");
    }

    public void execApproveState(PfParameterVO paraVo, int intCheckState) throws Exception {
        switch (intCheckState) {
            case 1: {
                this.execApprovePass(paraVo);
                break;
            }
            case 2: {
                this.execApproveGoing(paraVo);
                break;
            }
            case 0: {
                this.execApproveNoPass(paraVo);
                break;
            }
            case -1: {
                this.execUnApproveFree(paraVo);
                break;
            }
            case 3: {
                this.execUnApproveCommit(paraVo);
                break;
            }
            default: {
                throw new PFBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "AbstractBusiStateCallback-000000", null, new String[]{String.valueOf(intCheckState)}));
            }
        }
    }

    private void execUnApproveFree(PfParameterVO paraVo) throws Exception {
        Logger.info((Object)"\u8fdb\u884c\u5355\u636e\u72b6\u6001\u7684\u4fee\u6539\u4e3a\u81ea\u7531\u6001\u5f00\u59cb");
        this.changeStatusWhenUnapprove(paraVo, null, -1);
        Logger.info((Object)"\u8fdb\u884c\u5355\u636e\u72b6\u6001\u7684\u4fee\u6539\u4e3a\u81ea\u7531\u6001\u7ed3\u675f");
    }

    private void execUnApproveCommit(PfParameterVO paraVo) throws Exception {
        Logger.info((Object)"\u8fdb\u884c\u5355\u636e\u72b6\u6001\u7684\u4fee\u6539\u4e3a\u81ea\u7531\u6001\u5f00\u59cb");
        this.changeStatusWhenUnapprove(paraVo, null, 3);
        Logger.info((Object)"\u8fdb\u884c\u5355\u636e\u72b6\u6001\u7684\u4fee\u6539\u4e3a\u81ea\u7531\u6001\u7ed3\u675f");
    }

    private void execUnApproveGoing(PfParameterVO paraVo, String preCheckMan) throws Exception {
        Logger.info((Object)"\u8fdb\u884c\u5355\u636e\u72b6\u6001\u7684\u4fee\u6539\uff1a\u5ba1\u6279\u8fdb\u884c\u4e2d(\u6709\u5ba1\u6279\u6d41)\u5f00\u59cb");
        this.changeStatusWhenUnapprove(paraVo, preCheckMan, 2);
        Logger.info((Object)"\u8fdb\u884c\u5355\u636e\u72b6\u6001\u7684\u4fee\u6539\uff1a\u5ba1\u6279\u8fdb\u884c\u4e2d(\u6709\u5ba1\u6279\u6d41)\u7ed3\u675f");
    }

    public void execUnApproveState(PfParameterVO paraVo, String preCheckMan, int intBackCheckState) throws Exception {
        switch (intBackCheckState) {
            case 2: {
                this.execUnApproveGoing(paraVo, preCheckMan);
                break;
            }
            case -1: {
                this.execUnApproveFree(paraVo);
                break;
            }
            case 3: {
                this.execUnApproveCommit(paraVo);
                break;
            }
            default: {
                throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "AbstractBusiStateCallback-000001"));
            }
        }
    }

    protected void refreshHeadTs(Object headVo) {
        if (headVo instanceof SuperVO) {
            try {
                NCObject.newInstance((Object)headVo).setAttributeValue("ts", (Object)this.queryTSByVO((SuperVO)headVo));
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private UFDateTime queryTSByVO(SuperVO vo) throws BusinessException {
        BaseDAO baseDAO = new BaseDAO();
        String sql = "select ts from " + vo.getTableName() + " where " + vo.getPKFieldName() + " = ?";
        SQLParameter param = new SQLParameter();
        param.addParam(vo.getPrimaryKey());
        Object tsObj = baseDAO.executeQuery(sql, param, (ResultSetProcessor)new ColumnProcessor());
        if (null == tsObj) {
            return null;
        }
        return new UFDateTime(tsObj.toString());
    }
}

