/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.pf;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.PFRequestDataCacheProxy;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pf.pub.cache.CondStringKey;
import nc.bs.pf.pub.cache.ICacheDataQueryCallback;
import nc.bs.pf.pub.cache.IRequestDataCacheKey;
import nc.bs.pf.pub.cache.WFTaskCacheKey;
import nc.bs.pf.workflow.def.WFFuncodeUtil;
import nc.bs.pub.pf.IMessageCenterInfoCallBack;
import nc.bs.pub.pf.MsgCenterContext;
import nc.bs.pub.pf.PfUtilTools;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.pf.IPFMessageMetaService;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.itf.uap.rbac.IUserManageQuery;
import nc.message.itf.IMessageQueryService;
import nc.message.itf.IMessageService;
import nc.message.util.MessageCenter;
import nc.message.vo.NCMessage;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pf.msg.MessageMetaVO;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.billtype2.ExtendedClassEnum;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.msg.CommonMessageVO;
import nc.vo.pub.msg.MessageVO;
import nc.vo.pub.msg.MessageinfoVO;
import nc.vo.pub.msg.UserNameObject;
import nc.vo.pub.pf.Pfi18nTools;
import nc.vo.pub.workflownote.WorkflownoteVO;
import nc.vo.sm.UserVO;
import nc.vo.trade.sqlutil.IInSqlBatchCallBack;
import nc.vo.trade.sqlutil.InSqlBatchCaller;
import nc.vo.wfengine.pub.WFTask;
import nccloud.commons.lang.StringUtils;
import nccloud.message.itf.IApproveMessageManageService;
import nccloud.message.vo.NCCApproveMessageVO;
import nccloud.message.vo.NCCMessage;
import nccloud.message.vo.NCCNoticeMessageVO;

public class PfMessageUtil {
    public static final String DEFAULT_SENDER = "NC_USER0000000000000";

    private static IMessageQueryService lookupMessageQueryService() {
        return (IMessageQueryService)NCLocator.getInstance().lookup(IMessageQueryService.class);
    }

    private static IMessageService lookupMessageService() {
        return (IMessageService)NCLocator.getInstance().lookup(IMessageService.class);
    }

    public static void fill(NCMessage ncmsg, WorkflownoteVO workflownote, String funcode, String langcode) throws BusinessException {
        nc.message.vo.MessageVO messageVO = ncmsg.getMessage();
        String actionType = workflownote.getActiontype();
        String msgSourceType = null;
        msgSourceType = actionType != null && actionType.startsWith("BIZ") ? "pfbizmsg" : "worklist";
        String subject = messageVO.getSubject();
        subject = !StringUtil.isEmptyWithTrim((String)subject) ? PfMessageUtil.getI18NMessageNoteForUser(subject, workflownote.getCheckman(), langcode) : PfMessageUtil.getI18NMessageNoteForUser(workflownote.getMessagenote(), workflownote.getCheckman(), langcode);
        String content = messageVO.getContent();
        if (!StringUtil.isEmptyWithTrim((String)content)) {
            content = PfMessageUtil.getI18NMessageNoteForUser(content, workflownote.getCheckman(), langcode);
        }
        String sender = workflownote.getSenderman() != null ? workflownote.getSenderman() : DEFAULT_SENDER;
        messageVO.setContenttype(actionType);
        messageVO.setMsgsourcetype(msgSourceType);
        messageVO.setSubject(subject);
        messageVO.setContent(content);
        messageVO.setReceiver(workflownote.getCheckman());
        messageVO.setSender(sender);
        messageVO.setIsdelete(workflownote.getReceivedeleteflag());
        messageVO.setIshandled(UFBoolean.FALSE);
        messageVO.setPk_group(workflownote.getPk_group());
        messageVO.setSendtime(workflownote.getSenddate());
        messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
        messageVO.setPriority(workflownote.getPriority());
        messageVO.setTs(workflownote.getTs());
        messageVO.setDr(workflownote.getDr());
        messageVO.setPk_org(workflownote.getPk_org());
        messageVO.setDetail(workflownote.getBillid() + "@" + workflownote.getPk_billtype() + "@" + workflownote.getBillno() + "@" + funcode);
        messageVO.setPk_detail(workflownote.getPk_checkflow());
        messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(workflownote.getPk_billtype()));
        messageVO.setSubcolor(PfMessageUtil.getMessageColor(workflownote.getPk_billtype(), workflownote.getBillid()));
    }

    public static void fill(NCMessage ncmsg, WorkflownoteVO workflownote) throws BusinessException {
        nc.message.vo.MessageVO messageVO = ncmsg.getMessage();
        String actionType = workflownote.getActiontype();
        String msgSourceType = null;
        msgSourceType = actionType != null && actionType.startsWith("BIZ") ? "pfbizmsg" : "worklist";
        String subject = messageVO.getSubject();
        subject = !StringUtil.isEmptyWithTrim((String)subject) ? PfMessageUtil.getI18NMessageNoteForUser(subject, workflownote.getCheckman()) : PfMessageUtil.getI18NMessageNoteForUser(workflownote.getMessagenote(), workflownote.getCheckman());
        String content = messageVO.getContent();
        if (!StringUtil.isEmptyWithTrim((String)content)) {
            content = PfMessageUtil.getI18NMessageNoteForUser(content, workflownote.getCheckman());
        }
        String sender = workflownote.getSenderman() != null ? workflownote.getSenderman() : DEFAULT_SENDER;
        messageVO.setContenttype(actionType);
        messageVO.setMsgsourcetype(msgSourceType);
        messageVO.setSubject(subject);
        messageVO.setContent(content);
        messageVO.setReceiver(workflownote.getCheckman());
        messageVO.setSender(sender);
        messageVO.setIsdelete(workflownote.getReceivedeleteflag());
        messageVO.setIshandled(UFBoolean.FALSE);
        messageVO.setPk_group(workflownote.getPk_group());
        messageVO.setSendtime(workflownote.getSenddate());
        messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
        messageVO.setPriority(workflownote.getPriority());
        messageVO.setTs(workflownote.getTs());
        messageVO.setDr(workflownote.getDr());
        messageVO.setPk_org(workflownote.getPk_org());
        messageVO.setDetail(workflownote.getBillid() + "@" + workflownote.getPk_billtype() + "@" + workflownote.getBillno() + "@" + WFFuncodeUtil.getActivityFuncode(workflownote));
        messageVO.setPk_detail(workflownote.getPk_checkflow());
        messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(workflownote.getPk_billtype()));
        messageVO.setSubcolor(PfMessageUtil.getMessageColor(workflownote.getPk_billtype(), workflownote.getBillid()));
    }

    public static NCMessage transferToNCMessage(WorkflownoteVO workflownote) throws BusinessException {
        NCMessage ncmsg = workflownote.getNcMsg();
        PfMessageUtil.fill(ncmsg, workflownote);
        return ncmsg;
    }

    public static NCMessage transferToNCMessage(WorkflownoteVO workflownote, String funcode, String langcode) throws BusinessException {
        NCMessage ncmsg = workflownote.getNcMsg();
        PfMessageUtil.fill(ncmsg, workflownote, funcode, langcode);
        return ncmsg;
    }

    public static String getModuleOfBilltype(String pk_billtypecode) {
        try {
            BilltypeVO btvo = PfDataCache.getBillTypeInfo(pk_billtypecode);
            if (btvo != null) {
                return btvo.getSystemcode();
            }
            return null;
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getI18NMessageNoteForUser(String note, String cuserid, String langcode) throws BusinessException {
        String originLang = InvocationInfoProxy.getInstance().getLangCode();
        try {
            String i18nNote;
            InvocationInfoProxy.getInstance().setLangCode(langcode);
            String string = i18nNote = MessageVO.getMessageNoteAfterI18N(note);
            return string;
        }
        finally {
            InvocationInfoProxy.getInstance().setLangCode(originLang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getI18NMessageNoteForUser(String note, String cuserid) throws BusinessException {
        String langcode = Pfi18nTools.getLangcodeOfUser(cuserid);
        String originLang = InvocationInfoProxy.getInstance().getLangCode();
        try {
            String i18nNote;
            InvocationInfoProxy.getInstance().setLangCode(langcode);
            String string = i18nNote = MessageVO.getMessageNoteAfterI18N(note);
            return string;
        }
        finally {
            InvocationInfoProxy.getInstance().setLangCode(originLang);
        }
    }

    public static NCMessage transferToNCMessage(MessageinfoVO msginfovo) throws BusinessException {
        NCMessage ncMessage = new NCMessage();
        nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
        if (msginfovo.getType() == 6) {
            messageVO.setMsgsourcetype("notice");
        } else {
            messageVO.setMsgsourcetype("worklist");
        }
        messageVO.setReceiver(msginfovo.getCheckman());
        String subject = PfMessageUtil.getI18NMessageNoteForUser(msginfovo.getTitle(), msginfovo.getCheckman());
        messageVO.setSubject(subject);
        messageVO.setSender(msginfovo.getSenderman());
        messageVO.setIsdelete(msginfovo.getReceivedeleteflag());
        messageVO.setIshandled(UFBoolean.FALSE);
        messageVO.setSendtime(msginfovo.getSenddate());
        messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
        messageVO.setPriority(msginfovo.getPriority());
        messageVO.setTs(msginfovo.getTs());
        messageVO.setDr(msginfovo.getDr());
        messageVO.setContent(msginfovo.getContent());
        messageVO.setPk_group(msginfovo.getPk_corp());
        messageVO.setPk_detail(msginfovo.getPk_wf_msg() + "@" + msginfovo.getPk_wf_task() + "@" + msginfovo.getType() + "@" + msginfovo.getType() + "@");
        messageVO.setDetail(msginfovo.getBillid() + "@" + msginfovo.getPk_billtype() + "@" + msginfovo.getBillno());
        messageVO.setContenttype("BIZ");
        messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msginfovo.getPk_billtype()));
        ncMessage.setMessage(messageVO);
        return ncMessage;
    }

    public static void insertBizMessages(MessageinfoVO[] array) throws BusinessException {
        if (array == null || array.length == 0) {
            return;
        }
        NCMessage[] ncMsgs = new NCMessage[array.length];
        MessageMetaVO[] metas = new MessageMetaVO[array.length];
        for (int i = 0; i < array.length; ++i) {
            ncMsgs[i] = PfMessageUtil.transferToNCMessage(array[i]);
            metas[i] = PfMessageUtil.createMessageMeta(array[i]);
        }
        try {
            MessageCenter.sendMessage((NCMessage[])ncMsgs, (boolean)true);
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metas);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static MessageVO transferNCMessageToMessageVO(NCMessage ncmsg) {
        if (ncmsg == null) {
            return null;
        }
        MessageVO msgVO = new MessageVO();
        msgVO.setActionTypeCode(ncmsg.getMessage().getContenttype());
        msgVO.setCheckerCode(ncmsg.getMessage().getReceiver());
        msgVO.setPrimaryKey(ncmsg.getMessage().getPrimaryKey());
        msgVO.setCorpPK(ncmsg.getMessage().getPk_org());
        try {
            String detail = ncmsg.getMessage().getDetail();
            String[] values = detail.split("@");
            msgVO.setBillPK(values[0]);
            msgVO.setPk_billtype(values[1]);
            msgVO.setBillNO(values[2]);
            if (values.length >= 4) {
                msgVO.setFuncode(values[3]);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            WorkflownoteVO notevo = (WorkflownoteVO)((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveByPK(WorkflownoteVO.class, ncmsg.getMessage().getPk_detail());
            if (notevo != null) {
                msgVO.setUserobject(notevo.getUserobject());
                if (notevo.getWorkflow_type() != null) {
                    msgVO.setWorkflowtype(notevo.getWorkflow_type());
                }
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        msgVO.setMessageNote(ncmsg.getMessage().getContent());
        return msgVO;
    }

    private static NCMessage[] transferToNCMessage(CommonMessageVO msg) {
        HashSet<String> setHasAdded = new HashSet<String>();
        ArrayList<NCMessage> list = new ArrayList<NCMessage>();
        for (int i = 0; i < msg.getReceiver().length; ++i) {
            if (setHasAdded.contains(msg.getReceiver()[i].getUserPK())) continue;
            NCMessage ncMessage = new NCMessage();
            nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
            messageVO.setMsgsourcetype(msg.getActionType());
            messageVO.setReceiver(msg.getReceiver()[i].getUserPK());
            messageVO.setSubject(msg.getTitle());
            messageVO.setSender(msg.getSender() == null ? NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000706") : msg.getSender());
            messageVO.setIsdelete(UFBoolean.FALSE);
            messageVO.setIsread(UFBoolean.FALSE);
            messageVO.setSendtime(msg.getSendDataTime());
            messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
            messageVO.setPriority(Integer.valueOf(msg.getPriority()));
            messageVO.setTs(msg.getSendDataTime());
            messageVO.setDr(Integer.valueOf(0));
            messageVO.setContent(msg.getMessageContent());
            messageVO.setIshandled(UFBoolean.FALSE);
            messageVO.setDetail(msg.getBillid() + "@" + msg.getBilltype() + "@" + msg.getBillno());
            ncMessage.setMessage(messageVO);
            messageVO.setPk_group(InvocationInfoProxy.getInstance().getGroupId());
            messageVO.setPk_detail(msg.getPk_wf_msg() + "@" + msg.getPk_wf_task() + "@" + msg.getBilltype());
            messageVO.setContenttype(msg.isNeedFlowCheck() ? "MSG_NEEDCHECK" : "MSG_NOCHECK");
            messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msg.getBilltype()));
            list.add(ncMessage);
            setHasAdded.add(msg.getReceiver()[i].getUserPK());
        }
        return list.toArray(new NCMessage[0]);
    }

    @Deprecated
    private static NCMessage[] transferToNCMessage2(CommonMessageVO msg) {
        HashSet<String> setHasAdded = new HashSet<String>();
        ArrayList<NCMessage> list = new ArrayList<NCMessage>();
        for (int i = 0; i < msg.getReceiver().length; ++i) {
            if (setHasAdded.contains(msg.getReceiver()[i].getUserPK())) continue;
            NCMessage ncMessage = new NCMessage();
            nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
            messageVO.setMsgsourcetype(msg.getActionType());
            messageVO.setReceiver(msg.getReceiver()[i].getUserPK());
            messageVO.setSubject(msg.getTitle());
            messageVO.setSender(msg.getSender() == null ? NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "UPPpfworkflow-000706") : msg.getSender());
            messageVO.setIsdelete(UFBoolean.FALSE);
            messageVO.setSendtime(msg.getSendDataTime());
            messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
            messageVO.setPriority(Integer.valueOf(msg.getPriority()));
            messageVO.setContent(msg.getMessageContent());
            messageVO.setTs(msg.getSendDataTime());
            messageVO.setDr(Integer.valueOf(0));
            messageVO.setIshandled(UFBoolean.FALSE);
            messageVO.setPk_group(InvocationInfoProxy.getInstance().getGroupId());
            messageVO.setPk_detail(msg.getPk_wf_msg() + "@" + msg.getPk_wf_task() + "@" + msg.getBilltype());
            messageVO.setContenttype(msg.isNeedFlowCheck() ? "MSG_NEEDCHECK" : "MSG_NOCHECK");
            messageVO.setDetail(msg.getBillid() + "@" + msg.getBilltype() + "@" + msg.getBillno());
            messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msg.getBilltype()));
            ncMessage.setMessage(messageVO);
            list.add(ncMessage);
            setHasAdded.add(msg.getReceiver()[i].getUserPK());
        }
        return list.toArray(new NCMessage[0]);
    }

    private static NCMessage[] transferToNoticeMessage(CommonMessageVO msg) {
        HashSet<String> setHasAdded = new HashSet<String>();
        ArrayList<NCMessage> list = new ArrayList<NCMessage>();
        for (int i = 0; i < msg.getReceiver().length; ++i) {
            if (setHasAdded.contains(msg.getReceiver()[i].getUserPK())) continue;
            NCMessage ncMessage = new NCMessage();
            nc.message.vo.MessageVO messageVO = new nc.message.vo.MessageVO();
            messageVO.setMsgsourcetype("notice");
            messageVO.setReceiver(msg.getReceiver()[i].getUserPK());
            messageVO.setSubject(msg.getTitle());
            messageVO.setSender(msg.getSender());
            messageVO.setIsdelete(UFBoolean.FALSE);
            messageVO.setSendtime(msg.getSendDataTime());
            messageVO.setSendstate(UFBoolean.valueOf((boolean)true));
            messageVO.setPriority(Integer.valueOf(msg.getPriority()));
            messageVO.setContent(msg.getMessageContent());
            messageVO.setTs(msg.getSendDataTime());
            messageVO.setDr(Integer.valueOf(0));
            messageVO.setIshandled(UFBoolean.FALSE);
            messageVO.setPk_group(InvocationInfoProxy.getInstance().getGroupId());
            messageVO.setPk_detail(msg.getPk_wf_msg() + "@" + msg.getPk_wf_task() + "@" + msg.getBilltype());
            messageVO.setContenttype("BIZ");
            messageVO.setDetail(msg.getBillid() + "@" + msg.getBilltype() + "@" + msg.getBillno());
            messageVO.setDomainflag(PfMessageUtil.getModuleOfBilltype(msg.getBilltype()));
            ncMessage.setMessage(messageVO);
            list.add(ncMessage);
            setHasAdded.add(msg.getReceiver()[i].getUserPK());
        }
        return list.toArray(new NCMessage[0]);
    }

    public static void sendNoticeMessage(CommonMessageVO messagevo) throws BusinessException {
        if (messagevo.getReceiver() == null || messagevo.getReceiver().length == 0) {
            return;
        }
        try {
            MessageCenter.sendMessage((NCMessage[])PfMessageUtil.transferToNoticeMessage(messagevo), (boolean)true);
            ArrayList<MessageMetaVO> metaList = new ArrayList<MessageMetaVO>();
            MessageMetaVO meta = new MessageMetaVO();
            meta.setPk_group(InvocationInfoProxy.getInstance().getGroupId());
            meta.setBilltype(messagevo.getBilltype());
            meta.setBillid(messagevo.getBillid());
            meta.setBillno(messagevo.getBillno());
            meta.setMessage_type("nc-notice");
            meta.setTitle(messagevo.getTitle());
            meta.setSenddate(messagevo.getSendDataTime());
            for (UserNameObject uno : messagevo.getReceiver()) {
                MessageMetaVO cloned = (MessageMetaVO)((Object)meta.clone());
                cloned.setReceiver(uno.getUserPK());
                metaList.add(cloned);
            }
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metaList);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static void sendMessageOfWorknote(WorkflownoteVO workflownoteVO) throws BusinessException {
        if (workflownoteVO == null) {
            return;
        }
        if (PfMessageUtil.checkmanIsVirtual(workflownoteVO)) {
            return;
        }
        NCMessage ncMsg = PfMessageUtil.transferToNCMessage(workflownoteVO);
        try {
            String[] msgpk = MessageCenter.sendMessage((NCMessage[])new NCMessage[]{ncMsg}, (boolean)true);
            String pk_message = msgpk[0];
            WFTask task = PfMessageUtil.getWFTask(workflownoteVO.getPk_wf_task());
            MessageMetaVO metavo = PfMessageUtil.createMessageMeta(workflownoteVO, task, pk_message);
            ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).insert(metavo);
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static String getMessageColor(final String billtype, final String billid) {
        CondStringKey key = new CondStringKey("pfmessageutil_get_message_color", billtype, billid);
        ICacheDataQueryCallback<String> callback = new ICacheDataQueryCallback<String>(){

            public String queryData() throws BusinessException {
                ArrayList<Billtype2VO> b2voList = PfDataCache.getBillType2Info(billtype, ExtendedClassEnum.MESSAGECENTER_INFO_CALLBACK.getIntValue());
                if (ArrayUtil.isNotNull(b2voList)) {
                    Billtype2VO b2vo = (Billtype2VO)((Object)b2voList.get(0));
                    String className = b2vo.getClassname();
                    String realBillType = b2vo.getPk_billtype();
                    try {
                        IMessageCenterInfoCallBack cb = (IMessageCenterInfoCallBack)PfUtilTools.instantizeObject(realBillType, className);
                        MsgCenterContext msgCenterContext = cb.getMsgCenterContext(billid);
                        return msgCenterContext == null ? null : msgCenterContext.getColor();
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return null;
            }
        };
        try {
            return (String)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void sendMessageOfWorknoteBatch(WorkflownoteVO[] array) throws BusinessException {
        if (array == null || array.length == 0) {
            return;
        }
        if (PfMessageUtil.checkmanIsVirtual(array[0])) {
            return;
        }
        try {
            ArrayList<NCMessage> nccMsgVOsApprove = new ArrayList<NCMessage>();
            ArrayList<NCMessage> nccMsgVOsNotice = new ArrayList<NCMessage>();
            ArrayList<NCMessage> ncMsgVOs = new ArrayList<NCMessage>();
            for (WorkflownoteVO worknote : array) {
                BilltypeVO billtypeVo = PfDataCache.getBillTypeInfo(InvocationInfoProxy.getInstance().getGroupId(), PfUtilBaseTools.getRealBilltype(worknote.getPk_billtype()));
                WorkflownoteVO[] noteArray = new WorkflownoteVO[]{worknote};
                List<NCMessage> _ncMsgVOs = PfMessageUtil.getNCMessagesByWorkflownoteVos(noteArray);
                if (_ncMsgVOs == null || _ncMsgVOs.size() <= 0) continue;
                if (billtypeVo.getIsLightBill() != null && billtypeVo.getIsLightBill().booleanValue()) {
                    for (NCMessage ncmsg : _ncMsgVOs) {
                        if ("worklist".equals(ncmsg.getMessage().getMsgsourcetype())) {
                            nccMsgVOsApprove.add(ncmsg);
                            continue;
                        }
                        nccMsgVOsNotice.add(ncmsg);
                    }
                    continue;
                }
                for (NCMessage ncmsg : _ncMsgVOs) {
                    ncMsgVOs.add(ncmsg);
                }
            }
            if (nccMsgVOsApprove != null && nccMsgVOsApprove.size() > 0) {
                NCCMessage[] nccMsgVOsApproves = nccloud.bs.pub.pf.PfMessageUtil.convertToNCCMsgVos("approve", nccMsgVOsApprove.toArray(new NCMessage[0]), "");
                String[] stringArray = nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccMsgVOsApproves, (boolean)true);
            }
            if (nccMsgVOsNotice != null && nccMsgVOsNotice.size() > 0) {
                NCCMessage[] nccMsgVOsNotices = nccloud.bs.pub.pf.PfMessageUtil.convertToNCCMsgVos("notice", nccMsgVOsApprove.toArray(new NCMessage[0]), "");
                String[] stringArray = nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccMsgVOsNotices, (boolean)true);
            }
            if (ncMsgVOs != null && ncMsgVOs.size() > 0) {
                String[] msgpks = MessageCenter.sendMessage((NCMessage[])ncMsgVOs.toArray(new NCMessage[0]), (boolean)true);
                ArrayList<MessageMetaVO> metaList = new ArrayList<MessageMetaVO>();
                for (int i = 0; i < array.length; ++i) {
                    String pk_message = ((NCMessage)ncMsgVOs.get(i)).getMessage().getPk_message();
                    WFTask task = PfMessageUtil.getWFTask(array[i].getPk_wf_task());
                    MessageMetaVO metavo = PfMessageUtil.createMessageMeta(array[i], task, pk_message);
                    metaList.add(metavo);
                }
                IPFMessageMetaService srv = (IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class);
                srv.insert(metaList.toArray(new MessageMetaVO[0]));
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            if (e instanceof BusinessException) {
                throw (BusinessException)((Object)e);
            }
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public static List<NCMessage> getNCMessagesByWorkflownoteVos(WorkflownoteVO[] array) throws BusinessException {
        ArrayList<NCMessage> ncMsgVOs = new ArrayList<NCMessage>();
        String[] funcodes = PfMessageUtil.getFuncodeByNoteVos(array);
        ArrayList<String> cuserids = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            String cuserid = array[i].getCheckman();
            if (cuserid == null || "".equalsIgnoreCase(cuserid)) continue;
            cuserids.add(cuserid);
        }
        HashMap<String, String> langcodes = Pfi18nTools.getLangcodesOfUserFromDb(cuserids.toArray(new String[0]));
        for (int i = 0; i < array.length; ++i) {
            String funcode = null;
            if (funcodes != null && funcodes.length > i) {
                funcode = funcodes[i];
            }
            if (funcode == null) {
                funcode = "";
            }
            String langcode = langcodes.get(array[i].getCheckman());
            NCMessage ncMsg = PfMessageUtil.transferToNCMessage(array[i], funcode, langcode);
            nc.message.vo.MessageVO messagevo = ncMsg.getMessage();
            messagevo.setFuncid(array[i].getPk_message());
            ncMsgVOs.add(ncMsg);
        }
        return ncMsgVOs;
    }

    public static String[] getFuncodeByNoteVos(WorkflownoteVO[] array) throws BusinessException {
        return WFFuncodeUtil.getActivityFuncode(array);
    }

    public static WFTask getWFTask(final String pk_wf_task) throws BusinessException {
        if (pk_wf_task == null) {
            return null;
        }
        WFTaskCacheKey key = new WFTaskCacheKey(pk_wf_task);
        ICacheDataQueryCallback<WFTask> callback = new ICacheDataQueryCallback<WFTask>(){

            public WFTask queryData() throws BusinessException {
                return ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).getWFTask(pk_wf_task);
            }
        };
        return (WFTask)PFRequestDataCacheProxy.get((IRequestDataCacheKey)key, (ICacheDataQueryCallback)callback);
    }

    public static MessageMetaVO createMessageMeta(MessageinfoVO msg) {
        MessageMetaVO meta = new MessageMetaVO();
        meta.setPk_group(msg.getPk_corp());
        meta.setMessage_type("nc-notice");
        meta.setBilltype(msg.getPk_billtype());
        meta.setBillid(msg.getBillid());
        meta.setBillno(msg.getBillno());
        meta.setTitle(msg.getTitle());
        meta.setReceiver(msg.getCheckman());
        meta.setSenddate(msg.getSenddate());
        return meta;
    }

    public static MessageMetaVO createMessageMeta(WorkflownoteVO note, WFTask task, String pk_message) {
        MessageMetaVO metavo = new MessageMetaVO();
        if (note.getActiontype().startsWith("Z") || note.getActiontype().startsWith("MAKEBILL")) {
            metavo.setMessage_type("nc-workitem");
        } else {
            metavo.setMessage_type("nc-notice");
        }
        metavo.setPk_group(note.getPk_group());
        metavo.setBilltype(note.getPk_billtype());
        metavo.setBillid(note.getBillVersionPK());
        metavo.setBillno(note.getBillno());
        metavo.setPk_checkflow(note.getPk_checkflow());
        metavo.setPk_message(pk_message);
        metavo.setTitle(note.getMessagenote());
        metavo.setReceiver(note.getCheckman());
        metavo.setSenddate(note.getSenddate());
        if (task != null) {
            metavo.setActivity_id(task.getActivityID());
            metavo.setPk_wf_instance(task.getWfProcessInstancePK());
        }
        return metavo;
    }

    public static void setRejectApproveMessage(String pk_checkflow) throws BusinessException {
        if (StringUtils.isBlank((CharSequence)pk_checkflow)) {
            return;
        }
        BaseDAO dao = new BaseDAO();
        try {
            String updateMsgApproveSql = "update sm_msg_approve set detail='{\"enableActions\":[]}',canbatch='N' where pk_detail='" + pk_checkflow + "'";
            String updateMsgUserSql = "update sm_msg_user set isread='Y',isreject='Y' where pk_message=(select pk_message from sm_msg_approve where pk_detail='" + pk_checkflow + "')  and destination = 'inbox'";
            dao.executeUpdate(updateMsgApproveSql);
            dao.executeUpdate(updateMsgUserSql);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public static void deleteMessagesOfWorknote(WorkflownoteVO[] notes) throws BusinessException {
        if (notes == null || notes.length == 0) {
            return;
        }
        Logger.info((Object)("deleteMessagesOfWorknote aryWorknote:" + notes));
        String[] pks = null;
        ArrayList<String> pkList = new ArrayList<String>();
        ArrayList<String> nccpks = new ArrayList<String>();
        for (int i = 0; i < notes.length; ++i) {
            BilltypeVO billtypeVo = PfDataCache.getBillTypeInfo(InvocationInfoProxy.getInstance().getGroupId(), PfUtilBaseTools.getRealBilltype(notes[i].getPk_billtype()));
            if (billtypeVo.getIsLightBill() != null && billtypeVo.getIsLightBill().booleanValue()) {
                nccpks.add(notes[i].getPk_checkflow());
                continue;
            }
            pkList.add(notes[i].getPk_checkflow());
        }
        if (nccpks != null && nccpks.size() > 0) {
            String ids = "";
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < nccpks.size(); ++i) {
                jsonArray.add(nccpks.get(i));
            }
            JSONObject params = new JSONObject();
            params.put("pk_details", (Object)jsonArray);
            ((IApproveMessageManageService)NCLocator.getInstance().lookup(IApproveMessageManageService.class)).setDelete((Map)params, true, null);
        }
        if (pkList != null && pkList.size() > 0) {
            pks = pkList.toArray(new String[0]);
            try {
                InSqlBatchCaller caller = new InSqlBatchCaller(pks);
                caller.execute(new IInSqlBatchCallBack(){

                    public Object doWithInSql(String inSql) throws BusinessException, SQLException {
                        String cond = "pk_detail in " + inSql;
                        String[] pks = PfMessageUtil.lookupMessageQueryService().queryNCMsgPKs(cond);
                        PfMessageUtil.lookupMessageService().deleteMessageByPk(pks);
                        return null;
                    }
                });
                ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).deleteMessageOfWorkitem(pks);
            }
            catch (SQLException e) {
                throw new BusinessException((Throwable)e);
            }
        }
    }

    public static void deletePullMessage(String billid) throws BusinessException {
        String cond = " pk_detail='" + billid + "' and contenttype='" + "BIZ_PULL" + "'";
        String[] pks = PfMessageUtil.lookupMessageQueryService().queryNCMsgPKs(cond);
        PfMessageUtil.lookupMessageService().deleteMessageByPk(pks);
        ((IPFMessageMetaService)NCLocator.getInstance().lookup(IPFMessageMetaService.class)).deleteByPkMessage(pks);
    }

    public static void setHandled(WorkflownoteVO worknote) throws BusinessException {
        BilltypeVO billtypeVo = null;
        if (StringUtils.isNotEmpty((CharSequence)worknote.getPk_billtype())) {
            billtypeVo = PfDataCache.getBillTypeInfo(InvocationInfoProxy.getInstance().getGroupId(), PfUtilBaseTools.getRealBilltype(worknote.getPk_billtype()));
        }
        if (billtypeVo != null && billtypeVo.getIsLightBill() != null && billtypeVo.getIsLightBill().booleanValue()) {
            JSONArray pkMsg = new JSONArray();
            Collection ncApproveMsgVOs = new BaseDAO().retrieveByClause(NCCApproveMessageVO.class, "pk_detail='" + worknote.pk_checkflow + "'");
            Collection ncNoticeMsgVOs = new BaseDAO().retrieveByClause(NCCNoticeMessageVO.class, "pk_detail='" + worknote.pk_checkflow + "'");
            if (ncApproveMsgVOs != null && ncApproveMsgVOs.size() > 0) {
                for (NCCApproveMessageVO nccmsgvo : ncApproveMsgVOs) {
                    if ("{\"enableActions\":[]}".equals(nccmsgvo.getDetail())) continue;
                    nccmsgvo.setDetail(" {\"enableActions\":[\"unapprove\"]}");
                    new BaseDAO().updateVO((SuperVO)nccmsgvo);
                    pkMsg.add((Object)nccmsgvo.getPk_message());
                }
            }
            if (ncNoticeMsgVOs != null && ncNoticeMsgVOs.size() > 0) {
                for (NCCNoticeMessageVO noticemsgvo : ncNoticeMsgVOs) {
                    pkMsg.add((Object)noticemsgvo.getPk_message());
                }
            }
            JSONObject params = new JSONObject();
            if (pkMsg.size() > 0) {
                params.put("pk_messages", (Object)pkMsg);
                IApproveMessageManageService iMessageManageService = (IApproveMessageManageService)NCLocator.getInstance().lookup(IApproveMessageManageService.class);
                iMessageManageService.setRead((Map)params, true, null);
            }
        } else {
            NCMessage[] ncMsgs = PfMessageUtil.lookupMessageQueryService().queryNCMessages("pk_detail='" + worknote.pk_checkflow + "'");
            if (ncMsgs == null || ncMsgs.length == 0) {
                return;
            }
            for (NCMessage message : ncMsgs) {
                message.getMessage().setIshandled(UFBoolean.TRUE);
            }
            PfMessageUtil.lookupMessageService().udpateMessage(ncMsgs);
        }
    }

    private static boolean checkmanIsVirtual(WorkflownoteVO workflownoteVO) throws BusinessException {
        String pk_checkman = workflownoteVO.getCheckman();
        IUserManageQuery iUserService = (IUserManageQuery)NCLocator.getInstance().lookup(IUserManageQuery.class.getName());
        UserVO checkuser = iUserService.getUser(pk_checkman);
        return null != checkuser && checkuser.getUser_type() == -1;
    }
}

