/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.mobile;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.logging.Logger;
import nc.bs.pub.mobile.ShortMessageService;
import nc.bs.pub.mobile.UfmobileSmsImpl;
import nc.message.config.MailConfigAccessor;
import nc.message.config.SMSConfigAccessor;
import nc.vo.framework.rsa.Encode;
import nc.vo.pub.mobile.MobileConfig;
import nc.vo.pub.mobile.MobileImplInfo;
import nc.vo.pub.mobile.MobilePluginVO;
import nc.vo.pub.mobile.PubDevSmsConfig;
import nc.vo.pub.msg.DefaultSMTP;
import nc.vo.pub.msg.SysMessageParam;

public class WirelessManager {
    private static String MESSAGE_4PF_CONF = RuntimeEnv.getInstance().getNCHome() + "/ierp/bin/message4pf.xml";
    private static String CONFIG_FILE = RuntimeEnv.getInstance().getNCHome() + "/ierp/bin/mobileplugin.xml";
    private static SysMessageParam m_smp = null;
    private static ShortMessageService _shortMsgService = null;
    private static MobileConfig m_mobileConfig;

    public static synchronized SysMessageParam fetchSysMsgParam() {
        if (m_smp != null) {
            return m_smp;
        }
        File msgFile = new File(MESSAGE_4PF_CONF);
        if (msgFile.exists()) {
            FileReader in = null;
            try {
                in = new FileReader(msgFile);
                XStream xstream = WirelessManager.getAliasXstream();
                m_smp = (SysMessageParam)xstream.fromXML((Reader)in);
            }
            catch (Throwable e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (m_smp == null) {
                    m_smp = new SysMessageParam();
                }
                DefaultSMTP smtp = m_smp.getSmtp();
                smtp.setPop3(MailConfigAccessor.getPop3Server());
                smtp.setSmtp(MailConfigAccessor.getSMTPServer());
                smtp.setUser(MailConfigAccessor.getUser());
                smtp.setPassword(new Encode().encode(MailConfigAccessor.getPassword()));
                smtp.setSender(MailConfigAccessor.getMailFrom());
                smtp.setSenderName(MailConfigAccessor.getMailFrom());
            }
        }
        return m_smp;
    }

    public static synchronized MobileConfig getMobileConfig() {
        if (m_mobileConfig != null) {
            return m_mobileConfig;
        }
        XStream xs = WirelessManager.getMobileAliasXstream();
        FileReader fr = null;
        try {
            fr = new FileReader(CONFIG_FILE);
            m_mobileConfig = (MobileConfig)xs.fromXML((Reader)fr);
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (m_mobileConfig != null) {
                PubDevSmsConfig c = m_mobileConfig.getPubSms();
                c.setURL(SMSConfigAccessor.getSMSServer());
                c.setTimeout(SMSConfigAccessor.getTimeOut());
            }
        }
        return m_mobileConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMobileConfig(MobileConfig mc) {
        XStream xs = WirelessManager.getMobileAliasXstream();
        FileWriter fw = null;
        try {
            fw = new FileWriter(CONFIG_FILE);
            xs.toXML((Object)mc, (Writer)fw);
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static XStream getMobileAliasXstream() {
        XStream xs = new XStream();
        xs.addPermission(AnyTypePermission.ANY);
        xs.alias("mobileconfig", MobileConfig.class);
        xs.alias("mobileplugin", MobilePluginVO.class);
        xs.alias("mobileplugins", MobilePluginVO[].class);
        xs.alias("mobileimplinfos", MobileImplInfo[].class);
        xs.alias("mobileimpl", MobileImplInfo.class);
        xs.alias("pubdev", PubDevSmsConfig.class);
        return xs;
    }

    private static XStream getAliasXstream() {
        XStream xstream = new XStream();
        xstream.addPermission(AnyTypePermission.ANY);
        xstream.alias("SysMessageParam", SysMessageParam.class);
        return xstream;
    }

    public static synchronized ShortMessageService getSMS() {
        if (_shortMsgService != null) {
            return _shortMsgService;
        }
        MobileConfig mc = WirelessManager.getMobileConfig();
        MobileImplInfo[] miis = mc.getMobileimplinfos();
        if (miis == null || miis.length == 0) {
            _shortMsgService = new UfmobileSmsImpl();
            return _shortMsgService;
        }
        for (int i = 0; i < miis.length; ++i) {
            if (!miis[i].isActive()) continue;
            try {
                _shortMsgService = (ShortMessageService)Class.forName(miis[i].getQualifiedclass()).newInstance();
                return _shortMsgService;
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return _shortMsgService;
    }

    public static boolean saveSysMsgParam(SysMessageParam smp) throws IOException {
        if (smp == null) {
            return false;
        }
        try (FileWriter out = null;){
            out = new FileWriter(MESSAGE_4PF_CONF);
            XStream xstream = WirelessManager.getAliasXstream();
            xstream.toXML((Object)smp, (Writer)out);
            m_smp = null;
            boolean bl = true;
            return bl;
        }
    }

    @Deprecated
    public static void testMobileConfig(String[] args) {
    }
}

