/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import nc.bs.framework.common.NCLocator;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.pub.workflowqry.IFlowInstanceQuery;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.rbac.IUserManageQuery_C;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.ColumnListProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.ui.wfengine.IWFProcessCheck;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.formulaset.core.ParseException;
import nc.vo.pub.formulaset.function.PostfixMathCommand;
import nc.vo.sm.UserVO;
import nc.vo.wfengine.core.activity.ActivityEx;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.pub.WfTaskOrInstanceStatus;
import nc.vo.wfengine.pub.WfTaskType;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.impl.platform.common.util.CollectionUtils;
import nccloud.vo.pf.flowinstance.NCCFlowInstanceVO;

public class GetCheckManFormula
extends PostfixMathCommand {
    public GetCheckManFormula() {
        this.numberOfParameters = 3;
        this.functionType = 4;
        this.functionDesc = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "GetCheckMan-0000");
    }

    public void run(Stack inStack) throws ParseException {
        Object activityName = inStack.pop();
        Object billCode = inStack.pop();
        Object billPk = inStack.pop();
        if (activityName == null || billCode == null || billPk == null) {
            String exemess = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "GetCheckMan-0001");
            throw new ParseException(exemess + "\u3010billpk:" + billPk + "\u3011\u3010billCode:" + billCode + "\u3011\u3010activityName:" + activityName + "\u3011");
        }
        Object r = null;
        try {
            r = this.getcheckMan(billPk, billCode, activityName);
            inStack.push(r);
        }
        catch (BusinessException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public Object getcheckMan(Object billPk, Object billCode, Object activityNames) throws BusinessException {
        List resArr;
        String billid = "";
        String billtype = "";
        if (billPk instanceof List) {
            resArr = this.getVarValueWithNull(billPk);
            if (CollectionUtils.isEmpty((Collection)resArr)) {
                return null;
            }
            billid = (String)resArr.get(0);
        } else {
            billid = String.valueOf(billPk);
        }
        if (billCode instanceof List) {
            resArr = this.getVarValueWithNull(billCode);
            if (CollectionUtils.isEmpty((Collection)resArr)) {
                return null;
            }
            billtype = (String)resArr.get(0);
        } else {
            billtype = String.valueOf(billCode);
        }
        String activityName = String.valueOf(activityNames);
        if (StringUtils.isBlank((CharSequence)billid) || StringUtils.isBlank((CharSequence)billtype) || StringUtils.isBlank((CharSequence)activityName)) {
            String exemess = NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow", "GetCheckMan-0001");
            throw new BusinessException(exemess + "\u3010billpk:" + billid + "\u3011\u3010billCode:" + billtype + "\u3011\u3010activityName:" + activityName + "\u3011");
        }
        IFlowInstanceQuery flowInstance = (IFlowInstanceQuery)NCLocator.getInstance().lookup(IFlowInstanceQuery.class);
        NCCFlowInstanceVO[] arrvo = flowInstance.findAllFlowInstancesByBillIdAndBillType(billid, billtype);
        if (ArrayUtils.isEmpty((Object[])arrvo)) {
            return null;
        }
        HashMap<String, String> processDefInstanceMap = new HashMap<String, String>();
        NCCFlowInstanceVO parentinstancevo = null;
        for (NCCFlowInstanceVO vo : arrvo) {
            processDefInstanceMap.put(vo.getProcessdefid(), vo.getPk_wf_instance());
            if (!"2".equals(vo.getWorkflow_type()) && !"4".equals(vo.getWorkflow_type())) continue;
            parentinstancevo = vo;
        }
        if (parentinstancevo == null) {
            return null;
        }
        String pk_wf_instance = parentinstancevo.getPk_wf_instance();
        String pk_wf_def = parentinstancevo.getProcessdefid();
        if (StringUtils.isBlank((CharSequence)pk_wf_instance) || StringUtils.isBlank((CharSequence)pk_wf_def)) {
            return null;
        }
        BasicWorkflowProcess wf = null;
        try {
            wf = PfDataCache.getWorkflowProcess(pk_wf_def, pk_wf_instance);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        ArrayList<BasicWorkflowProcess> allProcess = new ArrayList<BasicWorkflowProcess>();
        this.getAllWorkflowProcessByMainProcess(wf, allProcess);
        ArrayList<String> ListUser = new ArrayList();
        String activityPk = null;
        String subfindwfInstnacePk = null;
        block3: for (BasicWorkflowProcess process : allProcess) {
            List activityList = process.getActivities();
            if (StringUtils.isNotBlank(activityPk)) break;
            for (ActivityEx activity : activityList) {
                if (!activity.getName().equals(activityName)) continue;
                if (activity.getActivityType() == 0) {
                    ListUser.add(parentinstancevo.getBillmaker());
                    return this.getUserNameByIds(ListUser);
                }
                activityPk = activity.getId();
                subfindwfInstnacePk = (String)processDefInstanceMap.get(process.getPrimaryKey());
                continue block3;
            }
        }
        if (StringUtils.isBlank(activityPk) || StringUtils.isBlank(subfindwfInstnacePk)) {
            return null;
        }
        ListUser = this.getCheckManBySql(activityPk, subfindwfInstnacePk);
        return this.getUserNameByIds(ListUser);
    }

    private void getAllWorkflowProcessByMainProcess(BasicWorkflowProcess wf, List<BasicWorkflowProcess> list) throws BusinessException {
        list.add(wf);
        IWFProcessCheck wfprocess = (IWFProcessCheck)NCLocator.getInstance().lookup(IWFProcessCheck.class);
        ArrayList<String> subProcessList = wfprocess.getAllSubFlow(new ArrayList<String>(), wf.getPrimaryKey());
        if (CollectionUtils.isEmpty(subProcessList)) {
            return;
        }
        for (String sub : subProcessList) {
            try {
                BasicWorkflowProcess subwf = PfDataCache.getWorkflowProcess(sub);
                list.add(subwf);
            }
            catch (XPDLParserException e) {
                throw new BusinessException((Throwable)e);
            }
        }
    }

    private String getUserNameByIds(List<String> listUser) throws BusinessException {
        if (listUser == null) {
            return null;
        }
        IUserManageQuery_C userManager = (IUserManageQuery_C)NCLocator.getInstance().lookup(IUserManageQuery_C.class);
        String[] arr = listUser.toArray(new String[0]);
        UserVO[] users = userManager.findUserByIDs(arr);
        StringBuffer sb = new StringBuffer();
        for (UserVO uservo : users) {
            sb.append(uservo.getUser_name());
            sb.append(",");
        }
        String userNames = sb.toString();
        userNames = userNames.substring(0, userNames.length() - 1);
        return userNames;
    }

    private List<String> getCheckManBySql(String activityid, String pk_wf_instance) throws BusinessException {
        if (StringUtils.isBlank((CharSequence)activityid) || StringUtils.isBlank((CharSequence)pk_wf_instance)) {
            return null;
        }
        String sql = "select checkman from pub_workflownote where pk_wf_task = ( select pk_wf_task from pub_wf_task where activitydefid = ? and pk_wf_instance = ? and taskstatus = ? and tasktype = ? ) and approvestatus = ? and actiontype not like 'Z_A'";
        SQLParameter sqlParam = new SQLParameter();
        sqlParam.addParam(activityid);
        sqlParam.addParam(pk_wf_instance);
        sqlParam.addParam(WfTaskOrInstanceStatus.Finished.getIntValue());
        sqlParam.addParam(WfTaskType.Forward.getIntValue());
        sqlParam.addParam(WfTaskOrInstanceStatus.Finished.getIntValue());
        List userList = (List)((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).executeQuery(sql, sqlParam, (ResultSetProcessor)new ColumnListProcessor());
        if (CollectionUtils.isEmpty((Collection)userList)) {
            return null;
        }
        return userList;
    }
}

