/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pub.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import nc.bs.dao.BaseDAO;
import nc.bs.dao.DAOException;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.BillTypeCacheKey;
import nc.bs.pf.pub.PfDataCache;
import nc.bs.pub.compiler.ICodeRemark;
import nc.bs.pub.compiler.IPfRun;
import nc.bs.pub.compiler.IWorkFlowRet;
import nc.bs.pub.pf.IPfPersonFilter2;
import nc.bs.pub.pf.PfUtilTools;
import nc.bs.pub.pf.busistate.PFBusiStateOfMeta;
import nc.itf.uap.pf.IPFConfig;
import nc.itf.uap.pf.IWorkflowMachine;
import nc.message.util.MessageCenter;
import nc.message.vo.MessageVO;
import nc.message.vo.NCMessage;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.change.PublicHeadVO;
import nc.vo.pub.compiler.PfParameterVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.pf.Pfi18nTools;
import nc.vo.pub.pfflow01.BillbusinessVO;
import nc.vo.uap.pf.PFBusinessException;
import nc.vo.uap.pf.RetBackWfVo;
import nc.vo.wfengine.definition.WorkflowTypeEnum;
import nc.vo.wfengine.pub.WFTask;
import nccloud.bs.pub.pf.PfMessageUtil;
import nccloud.commons.lang.StringUtils;
import nccloud.message.vo.NCCMessage;

public class AbstractCompiler
implements IPfRun,
ICodeRemark {
    private void execApprovePass(PfParameterVO paraVo) throws Exception {
        try {
            if (!PfUtilBaseTools.isApproveAction(paraVo.m_actionName, paraVo.m_billType)) {
                return;
            }
            PFBusiStateOfMeta absc = new PFBusiStateOfMeta();
            absc.execApproveState(paraVo, 1);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private void execApproveNOPass(PfParameterVO paraVo) throws Exception {
        try {
            if (!PfUtilBaseTools.isApproveAction(paraVo.m_actionName, paraVo.m_billType)) {
                return;
            }
            PFBusiStateOfMeta absc = new PFBusiStateOfMeta();
            absc.execApproveState(paraVo, 0);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private void execApproveReject(PfParameterVO paraVo) throws Exception {
        try {
            if (!PfUtilBaseTools.isApproveAction(paraVo.m_actionName, paraVo.m_billType)) {
                return;
            }
            PFBusiStateOfMeta absc = new PFBusiStateOfMeta();
            absc.execApproveState(paraVo, -1);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    protected void getHeadInfo(PfParameterVO paraVo) {
        PublicHeadVO standHeadVo = new PublicHeadVO();
        PfUtilBaseTools.getHeadInfoByMeta(standHeadVo, paraVo.m_preValueVo, paraVo.m_billType);
        paraVo.m_businessType = StringUtil.isEmptyWithTrim((String)standHeadVo.businessType) ? "KHHH0000000000000001" : standHeadVo.businessType;
        paraVo.m_billNo = standHeadVo.billNo;
        paraVo.m_billVersionPK = standHeadVo.pkBillVersion;
        paraVo.m_billId = standHeadVo.pkBillId;
        paraVo.m_pkOrg = standHeadVo.pkOrg;
        paraVo.m_makeBillOperator = standHeadVo.operatorId;
    }

    public Object procActionFlow(PfParameterVO paraVo) throws Exception {
        IWorkFlowRet retObj = null;
        int intFlag = this.processWorkFlow(paraVo);
        if (intFlag != 1) {
            retObj = new IWorkFlowRet();
            retObj.m_inVo = paraVo.m_preValueVo;
        } else {
            this.insertPullWorkitems(paraVo);
        }
        return retObj;
    }

    private void insertPullWorkitems(PfParameterVO paravo) {
        Logger.debug((Object)(">>\u5ba1\u6279\u901a\u8fc7\u540e\u53d1\u9001\u62c9\u5f0f\u6d88\u606f=" + paravo.m_billType + "\u5f00\u59cb"));
        boolean isTranstype = false;
        boolean isNeed = false;
        BillbusinessVO condVO = new BillbusinessVO();
        condVO.setPk_businesstype(paravo.m_businessType);
        String billtype = paravo.m_billType;
        BilltypeVO billtypeVO = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(billtype).buildPkGroup(paravo.m_pkGroup));
        if (billtypeVO.getIstransaction() != null && billtypeVO.getIstransaction().booleanValue()) {
            isTranstype = true;
            condVO.setTranstype(billtype);
            condVO.setPk_billtype(billtypeVO.getParentbilltype());
        } else {
            condVO.setPk_billtype(billtype);
        }
        BaseDAO dao = new BaseDAO();
        try {
            UFBoolean isMsg;
            BillbusinessVO vo;
            Collection co = dao.retrieve((SuperVO)condVO, true);
            if (co.size() > 0) {
                vo = (BillbusinessVO)co.iterator().next();
                isMsg = vo.getForwardmsgflag();
                if (isMsg != null && isMsg.booleanValue()) {
                    isNeed = true;
                }
            } else if (isTranstype) {
                condVO.setTranstype(null);
                co = dao.retrieve((SuperVO)condVO, true);
                if (co.size() > 0 && (isMsg = (vo = (BillbusinessVO)co.iterator().next()).getForwardmsgflag()) != null && isMsg.booleanValue()) {
                    isNeed = true;
                }
            }
        }
        catch (DAOException ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return;
        }
        if (!isNeed) {
            Logger.debug((Object)(">>\u6e90\u5355\u636e" + paravo.m_billType + "\u4e0d\u53ef\u53d1\u9001\u4e0b\u6e38\u6d88\u606f\uff0c\u8fd4\u56de"));
            return;
        }
        try {
            IPFConfig pfcfg = (IPFConfig)NCLocator.getInstance().lookup(IPFConfig.class.getName());
            BillbusinessVO[] billbusiVOs = pfcfg.queryBillDest(paravo.m_billType, paravo.m_businessType);
            if (!(billbusiVOs != null && billbusiVOs.length != 0 || (billbusiVOs = pfcfg.queryBillDest(condVO.getPk_billtype(), paravo.m_businessType)) != null && billbusiVOs.length != 0)) {
                Logger.debug((Object)("\u8be5\u4e1a\u52a1\u6d41\u7a0b\u6ca1\u6709\u4e3a\u5355\u636e" + paravo.m_billType + "\u914d\u7f6e\u4e0b\u6e38\u5355\u636e\uff0c\u8fd4\u56de"));
                return;
            }
            Object checkClzInstance = PfUtilTools.getBizRuleImpl(paravo.m_billType);
            IPfPersonFilter2 filter = null;
            if (checkClzInstance instanceof IPfPersonFilter2) {
                filter = (IPfPersonFilter2)checkClzInstance;
            }
            for (int k = 0; k < billbusiVOs.length; ++k) {
                BillbusinessVO destBillbusiVO = billbusiVOs[k];
                String[] hsUserPKs = pfcfg.queryForwardMessageUser(paravo.m_billType, destBillbusiVO.getPk_billtype(), paravo.m_businessType, paravo.m_preValueVo, filter);
                if (!(hsUserPKs != null && hsUserPKs.length != 0 || (hsUserPKs = pfcfg.queryForwardMessageUser(condVO.getPk_billtype(), destBillbusiVO.getPk_billtype(), paravo.m_businessType, paravo.m_preValueVo, filter)) != null && hsUserPKs.length != 0)) {
                    Logger.warn((Object)">>\u65e0\u6cd5\u53d1\u9001\u62c9\u5f0f\u6d88\u606f\uff0c\u56e0\u4e3a\u63a5\u6536\u7528\u6237\u4e3a\u7a7a");
                    continue;
                }
                ArrayList<NCMessage> msgList = new ArrayList<NCMessage>();
                for (int i = 0; i < hsUserPKs.length; ++i) {
                    String userId = hsUserPKs[i];
                    MessageVO msgvo = new MessageVO();
                    msgvo.setMsgsourcetype("notice");
                    msgvo.setPriority(Integer.valueOf(0));
                    msgvo.setSendtime(new UFDateTime());
                    msgvo.setReceiver(userId);
                    msgvo.setSender(paravo.m_operator);
                    msgvo.setPk_group(paravo.m_pkGroup);
                    msgvo.setContenttype("BIZ_PULL");
                    String originLang = InvocationInfoProxy.getInstance().getLangCode();
                    String userLang = Pfi18nTools.getLangcodeOfUser(userId);
                    InvocationInfoProxy.getInstance().setLangCode(userLang);
                    msgvo.setSubject(Pfi18nTools.i18nBilltypeName(paravo.m_billType) + paravo.m_billNo + NCLangRes4VoTransl.getNCLangRes().getStrByID("pfworkflow1", "AbstractCompiler-000000") + Pfi18nTools.i18nBilltypeName(destBillbusiVO.getPk_billtype()));
                    InvocationInfoProxy.getInstance().setLangCode(originLang);
                    msgvo.setIsdelete(UFBoolean.FALSE);
                    msgvo.setIshandled(UFBoolean.FALSE);
                    msgvo.setSendstate(UFBoolean.TRUE);
                    msgvo.setPk_detail(paravo.m_billVersionPK);
                    msgvo.setDetail(paravo.m_billType + "@" + destBillbusiVO.getPk_billtype() + "@" + paravo.m_billNo);
                    msgvo.setMsgtype("nc");
                    msgvo.setDomainflag(nc.bs.pub.pf.PfMessageUtil.getModuleOfBilltype(billtype));
                    NCMessage msg = new NCMessage();
                    msg.setMessage(msgvo);
                    msgList.add(msg);
                }
                if (msgList.size() <= 0) continue;
                BilltypeVO btVO = null;
                if (StringUtils.isNotEmpty((CharSequence)paravo.m_billType)) {
                    btVO = PfDataCache.getBillTypeInfo(paravo.m_pkGroup, PfUtilBaseTools.getRealBilltype(paravo.m_billType));
                }
                if (btVO == null) continue;
                if (btVO.getIsLightBill() != null && btVO.getIsLightBill().booleanValue()) {
                    NCCMessage[] nccMsgs = PfMessageUtil.convertToNCCMsgVos("notice", msgList.toArray(new NCMessage[0]));
                    nccloud.message.util.MessageCenter.sendMessage((NCCMessage[])nccMsgs, (boolean)true);
                    continue;
                }
                MessageCenter.sendMessage((NCMessage[])msgList.toArray(new NCMessage[0]), (boolean)true);
            }
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Logger.debug((Object)(">>\u5ba1\u6279\u901a\u8fc7\u540e\u53d1\u9001\u62c9\u5f0f\u6d88\u606f=" + paravo.m_billType + "\u7ed3\u675f"));
    }

    public int processWorkFlow(PfParameterVO paraVo) throws Exception {
        Logger.info((Object)("****\u5904\u7406\u5de5\u4f5c\u6d41processWorkFlow\u5f00\u59cb****" + System.currentTimeMillis() + "ms"));
        int intFlag = 0;
        if (paraVo.m_workFlow == null || paraVo.m_autoApproveAfterCommit) {
            this.execApprovePass(paraVo);
            intFlag = 1;
            return intFlag;
        }
        if (paraVo.m_workFlow != null && paraVo.m_workFlow.isAnyoneCanApprove()) {
            if ("Y".equals(paraVo.m_workFlow.getApproveresult())) {
                this.execApprovePass(paraVo);
                intFlag = 1;
            } else if ("N".equals(paraVo.m_workFlow.getApproveresult())) {
                this.execApproveNOPass(paraVo);
                intFlag = 0;
            } else if ("R".equals(paraVo.m_workFlow.getApproveresult())) {
                this.execApproveReject(paraVo);
                intFlag = -1;
            }
            return intFlag;
        }
        try {
            intFlag = ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).forwardCheckFlow(paraVo);
            WFTask currentTask = paraVo.m_workFlow.getTaskInfo().getTask();
            int iCurrentWfType = currentTask.getWorkflowType();
            boolean isWorkflow = WorkflowTypeEnum.Workflow.getIntValue() == iCurrentWfType || WorkflowTypeEnum.SubWorkflow.getIntValue() == iCurrentWfType;
            boolean isWorkflow_ssc = PfDataCache.queryAllShareBillTypeReject().containsKey(PfUtilBaseTools.getRealBilltype(paraVo.m_billType));
            BilltypeVO btvo = PfDataCache.getBillTypeInfo(PfUtilBaseTools.getRealBilltype(paraVo.m_billType));
            boolean isWorkflowAutoApprove = false;
            if (btvo != null && btvo.getIsworkflowcanautoapprove() != null && btvo.getIsworkflowcanautoapprove().booleanValue()) {
                isWorkflowAutoApprove = true;
            }
            if (!isWorkflow || isWorkflow_ssc || isWorkflowAutoApprove) {
                PFBusiStateOfMeta absc = new PFBusiStateOfMeta();
                absc.execApproveState(paraVo, intFlag);
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw e;
            }
            Throwable exp = e.getCause();
            throw new PFBusinessException(exp == null ? e.getMessage() : exp.getMessage(), e);
        }
        Logger.debug((Object)(">>\u5f53\u524d\u5355\u636e\u7684\u5ba1\u6279\u72b6\u6001=" + intFlag));
        Logger.info((Object)("****\u5904\u7406\u5de5\u4f5c\u6d41processWorkFlow\u7ed3\u675f****" + System.currentTimeMillis() + "ms"));
        return intFlag;
    }

    public Hashtable procFlowBacth(PfParameterVO paraVo) throws Exception {
        Hashtable<String, String> retHas = new Hashtable<String, String>();
        IWorkFlowRet retObj = null;
        int intFlag = this.processWorkFlow(paraVo);
        if (intFlag != 1) {
            retObj = new IWorkFlowRet();
            retObj.m_inVo = paraVo.m_preValueVo;
            retHas.put(String.valueOf(0), String.valueOf(0));
        } else {
            this.insertPullWorkitems(paraVo);
        }
        return retHas;
    }

    public Object runClass(String className, String method, String parameter, PfParameterVO paraVo, Hashtable keyHas) throws BusinessException {
        return PfUtilTools.runClass(className, method, parameter, paraVo, keyHas);
    }

    @Override
    public Object runComClass(PfParameterVO paraVo) throws BusinessException {
        return null;
    }

    public boolean procUnApproveFlow(PfParameterVO paraVo) throws BusinessException {
        RetBackWfVo backWfVo = ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).backCheckFlow(paraVo);
        boolean needChangeStatus = false;
        if (paraVo.m_workFlow == null) {
            needChangeStatus = true;
        } else {
            int wftype = paraVo.m_workFlow.getWorkflow_type();
            if (wftype == WorkflowTypeEnum.Approveflow.getIntValue() || wftype == WorkflowTypeEnum.SubApproveflow.getIntValue() || wftype == WorkflowTypeEnum.SubWorkApproveflow.getIntValue() || PfDataCache.queryAllShareBillTypeReject().containsKey(PfUtilBaseTools.getRealBilltype(paraVo.m_billType))) {
                needChangeStatus = true;
            }
        }
        if (needChangeStatus) {
            this.unApproveState(paraVo, backWfVo.getBackState(), backWfVo.getPreCheckMan());
        }
        return backWfVo.getIsFinish().booleanValue();
    }

    public void procRecallFlow(PfParameterVO paraVo) throws BusinessException {
        try {
            ((IWorkflowMachine)NCLocator.getInstance().lookup(IWorkflowMachine.class)).backCheckFlow(paraVo);
            this.unApproveState(paraVo, -1, null);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PFBusinessException(ex.getMessage(), ex);
        }
    }

    private void unApproveState(PfParameterVO paraVo, int iBackState, String preCheckMan) throws BusinessException {
        Logger.info((Object)"****\u5f03\u5ba1\u65f6\uff0c\u4fee\u6539\u5355\u636e\u7684\u5ba1\u6279\u72b6\u6001unApproveState\u5f00\u59cb*****");
        try {
            PFBusiStateOfMeta absc = new PFBusiStateOfMeta();
            switch (iBackState) {
                case 2: {
                    absc.execUnApproveState(paraVo, preCheckMan, 2);
                    break;
                }
                case -1: {
                    paraVo.m_workFlow = null;
                    absc.execUnApproveState(paraVo, null, -1);
                    break;
                }
                case 3: {
                    absc.execUnApproveState(paraVo, null, 3);
                    break;
                }
            }
        }
        catch (BusinessException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PFBusinessException(ex.getMessage(), ex);
        }
        Logger.info((Object)"****\u5f03\u5ba1\u65f6\uff0c\u4fee\u6539\u5355\u636e\u7684\u5ba1\u6279\u72b6\u6001unApproveState\u7ed3\u675f*****");
    }

    @Override
    public String getCodeRemark() {
        return null;
    }
}

