/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.pub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.common.NCLocator;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.logging.Logger;
import nc.bs.pf.pub.BillTypeCacheKey;
import nc.bs.pf.pub.BillTypeVOListProcessor;
import nc.bs.pf.pub.PfDataCacheConstant;
import nc.bs.pf.pub.WorkflowProcessCache;
import nc.itf.uap.IUAPQueryBS;
import nc.itf.uap.bbd.func.IModuleQueryService;
import nc.itf.uap.pf.IPFBillItfDef;
import nc.itf.uap.pf.IWFModuleService;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.processor.BeanListProcessor;
import nc.jdbc.framework.processor.ColumnProcessor;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.ui.dbcache.DBCacheQueryFacade;
import nc.vo.bd.pub.BDCacheFactory;
import nc.vo.cache.CacheToMap;
import nc.vo.cache.ICache;
import nc.vo.cache.ext.ElementVersionSensitiveMap;
import nc.vo.cache.ext.ICacheVersionMonitor;
import nc.vo.cache.ext.ObjectCacheVersionMonitor;
import nc.vo.cache.ext.TableVersionMonitor;
import nc.vo.cache.ext.VersionMonitorFactory;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.pf.change.BillItfDefVO;
import nc.vo.pf.change.PfUtilBaseTools;
import nc.vo.pf.pub.FunctionVO;
import nc.vo.pf.pub.util.ArrayUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.PubActorFilter;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.billtype2.Billtype2VO;
import nc.vo.pub.forwardbilltype.ForwardBillTypeVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.pfflow.BillactionVO;
import nc.vo.sm.funcreg.ModuleVO;
import nc.vo.uap.pf.DynamicOrgRegInfo;
import nc.vo.uap.pf.DynamicOrganizeUnitRegistry;
import nc.vo.wfengine.core.application.WorkflowgadgetVO;
import nc.vo.wfengine.core.parser.XPDLParserException;
import nc.vo.wfengine.core.workflow.BasicWorkflowProcess;
import nc.vo.wfengine.core.workflow.WorkflowProcess;
import nccloud.nc.vo.pub.pf.ShareBillTypeRejectVO;

public class PfDataCache
implements PfDataCacheConstant {
    private static Hashtable<String, ElementVersionSensitiveMap> dsName_instance_map = new Hashtable();

    private static String getCurrentDs() {
        return InvocationInfoProxy.getInstance().getUserDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElementVersionSensitiveMap getVersionSensitiveCache() {
        String currDS = PfDataCache.getCurrentDs();
        if (dsName_instance_map.get(currDS) == null) {
            Hashtable<String, ElementVersionSensitiveMap> hashtable = dsName_instance_map;
            synchronized (hashtable) {
                if (dsName_instance_map.get(currDS) == null) {
                    ICache dataCache = BDCacheFactory.getCacheWithFileStratery((String)(currDS + "platform"));
                    final long timeout = BDCacheFactory.getCacheTimeout((ICache)dataCache);
                    CacheToMap adapter = new CacheToMap(dataCache);
                    ElementVersionSensitiveMap versionMap = new ElementVersionSensitiveMap((Map)adapter, new VersionMonitorFactory(){

                        public ICacheVersionMonitor createVersionMonitor(Object key) {
                            String tablename = null;
                            if (key.equals("BILLTYPE2INFO")) {
                                tablename = "bd_billtype2";
                            } else if (key.equals("BILLTYPEINFO")) {
                                tablename = "bd_billtype";
                            } else if (key.equals("SYSTEMTYPEINFO")) {
                                tablename = "dap_dapsystem";
                            } else if (key.equals("BILLACTION")) {
                                tablename = "pub_billaction";
                            } else if (key.equals("BILLITFDEF")) {
                                tablename = "pub_billitfde";
                            } else if (key.equals("DYNAMICORGINFO")) {
                                tablename = "pub_dynamicorg";
                            } else if (key.equals("BILLTYPETOFUNCTION")) {
                                tablename = "pub_function";
                            } else if (key.equals("FORWARDBILLTYPE")) {
                                tablename = "bd_fwdbilltype";
                            } else if (key.equals("WORKFLOWGADGETINFO")) {
                                tablename = "pub_workflowgadget";
                            } else if (key.equals("BUSIBYCORPANDBILL")) {
                                tablename = "pub_billbusiness";
                            } else {
                                return new ObjectCacheVersionMonitor(String.valueOf(key), timeout);
                            }
                            return new TableVersionMonitor(new String[]{tablename}, timeout);
                        }
                    });
                    dsName_instance_map.put(currDS, versionMap);
                }
            }
        }
        return dsName_instance_map.get(currDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Billtype2VO> getBillType2Info(String billType, int classtype) {
        String strTypeCode;
        HashMap<Integer, ArrayList<Billtype2VO>> hashCacheObj;
        block8: {
            hashCacheObj = null;
            strTypeCode = PfUtilBaseTools.getRealBilltype(billType);
            try {
                hashCacheObj = (HashMap<Integer, ArrayList<Billtype2VO>>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPE2INFO");
                if (hashCacheObj == null) {
                    Object object = MUTEX_BILLTYPE2INFO;
                    synchronized (object) {
                        hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPE2INFO");
                        if (hashCacheObj == null) {
                            hashCacheObj = PfDataCache.queryAllBilltype2();
                            PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPE2INFO", hashCacheObj);
                        }
                        break block8;
                    }
                }
                if (!hashCacheObj.containsKey(classtype) && !PfDataCache.hasCachedBilltype2(hashCacheObj, strTypeCode)) {
                    return PfDataCache.queryAllBilltype2(strTypeCode, classtype);
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return PfDataCache.findBilltype2ByBilltypeAndClasstype(strTypeCode, classtype, hashCacheObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Billtype2VO> getBillType2InfoByGroup(String billType, int classtype, String pk_group) {
        String strTypeCode;
        HashMap<Integer, ArrayList<Billtype2VO>> hashCacheObj;
        block8: {
            hashCacheObj = null;
            strTypeCode = PfUtilBaseTools.getRealBilltypeByGroup(pk_group, billType);
            try {
                hashCacheObj = (HashMap<Integer, ArrayList<Billtype2VO>>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPE2INFO");
                if (hashCacheObj == null) {
                    Object object = MUTEX_BILLTYPE2INFO;
                    synchronized (object) {
                        hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPE2INFO");
                        if (hashCacheObj == null) {
                            hashCacheObj = PfDataCache.queryAllBilltype2();
                            PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPE2INFO", hashCacheObj);
                        }
                        break block8;
                    }
                }
                if (!hashCacheObj.containsKey(classtype) && !PfDataCache.hasCachedBilltype2(hashCacheObj, strTypeCode)) {
                    return PfDataCache.queryAllBilltype2(strTypeCode, classtype);
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return PfDataCache.findBilltype2ByBilltypeAndClasstype(strTypeCode, classtype, hashCacheObj);
    }

    private static boolean hasCachedBilltype2(HashMap<Integer, ArrayList<Billtype2VO>> hashCacheObj, String billType) {
        for (ArrayList<Billtype2VO> alBilltype2VO : hashCacheObj.values()) {
            for (Billtype2VO bt2VO : alBilltype2VO) {
                if (!billType.equals(bt2VO.getPk_billtype())) continue;
                return true;
            }
        }
        return false;
    }

    private static HashMap<Integer, ArrayList<Billtype2VO>> queryAllBilltype2() throws BusinessException {
        HashMap<Integer, ArrayList<Billtype2VO>> hm = new HashMap<Integer, ArrayList<Billtype2VO>>();
        Collection coAll = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveAll(Billtype2VO.class);
        for (Billtype2VO bt2VO : coAll) {
            ArrayList<Billtype2VO> alTemp = hm.get(bt2VO.getClasstype());
            if (alTemp == null) {
                alTemp = new ArrayList();
                hm.put(bt2VO.getClasstype(), alTemp);
            }
            alTemp.add(bt2VO);
        }
        return hm;
    }

    private static ArrayList<Billtype2VO> queryAllBilltype2(String billtype, int classtype) throws BusinessException {
        ArrayList<Billtype2VO> hm = new ArrayList<Billtype2VO>();
        String realBilltype = PfUtilBaseTools.getRealBilltype(billtype);
        Collection coAll = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveByClause(Billtype2VO.class, "pk_billtype='" + realBilltype + "' and classtype=" + classtype + "");
        if (coAll != null && coAll.size() > 0) {
            for (Billtype2VO bt2VO : coAll) {
                hm.add(bt2VO);
            }
        } else {
            return null;
        }
        return hm;
    }

    public static HashMap<String, ShareBillTypeRejectVO> queryAllShareBillTypeReject() throws BusinessException {
        HashMap<String, ShareBillTypeRejectVO> hm = new HashMap<String, ShareBillTypeRejectVO>();
        Collection coAll = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveAll(ShareBillTypeRejectVO.class);
        for (ShareBillTypeRejectVO bt2VO : coAll) {
            hm.put(bt2VO.getBilltypecode(), bt2VO);
        }
        return hm;
    }

    private static ArrayList<Billtype2VO> findBilltype2ByBilltypeAndClasstype(String billType, int classtype, HashMap<Integer, ArrayList<Billtype2VO>> hashCacheObj) {
        ArrayList<Billtype2VO> alRet = new ArrayList<Billtype2VO>();
        ArrayList<Billtype2VO> alBilltype2VO = hashCacheObj.get(classtype);
        if (alBilltype2VO == null) {
            return alRet;
        }
        for (Billtype2VO bt2VO : alBilltype2VO) {
            if (classtype != bt2VO.getClasstype() || !billType.equals(bt2VO.getPk_billtype()) && !bt2VO.getPk_billtype().equals("XX")) continue;
            alRet.add(bt2VO);
        }
        return alRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ForwardBillTypeVO> getFwdBilltypeInfo(String pk_backBillType) {
        HashMap<String, ArrayList<ForwardBillTypeVO>> hashCacheObj;
        block6: {
            hashCacheObj = null;
            try {
                hashCacheObj = (HashMap<String, ArrayList<ForwardBillTypeVO>>)PfDataCache.getVersionSensitiveCache().get((Object)"FORWARDBILLTYPE");
                if (hashCacheObj != null) break block6;
                Object object = MUTEX_FORWARDBILLTYPE;
                synchronized (object) {
                    hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"FORWARDBILLTYPE");
                    if (hashCacheObj == null) {
                        hashCacheObj = PfDataCache.queryAllFwdBilltype();
                        PfDataCache.getVersionSensitiveCache().put((Object)"FORWARDBILLTYPE", hashCacheObj);
                    }
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return PfDataCache.findFwdBilltypeByBilltype(pk_backBillType, hashCacheObj);
    }

    private static ArrayList<ForwardBillTypeVO> findFwdBilltypeByBilltype(String pk_backBillType, HashMap<String, ArrayList<ForwardBillTypeVO>> hashCacheObj) {
        ArrayList<ForwardBillTypeVO> alBilltype2VO = hashCacheObj.get(pk_backBillType);
        return alBilltype2VO;
    }

    private static HashMap<String, ArrayList<ForwardBillTypeVO>> queryAllFwdBilltype() throws BusinessException {
        HashMap<String, ArrayList<ForwardBillTypeVO>> hm = new HashMap<String, ArrayList<ForwardBillTypeVO>>();
        Collection coAll = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveAll(ForwardBillTypeVO.class);
        for (ForwardBillTypeVO bt2VO : coAll) {
            ArrayList<ForwardBillTypeVO> alTemp = hm.get(bt2VO.getPk_backbilltype());
            if (alTemp == null) {
                alTemp = new ArrayList();
                hm.put(bt2VO.getPk_backbilltype(), alTemp);
            }
            alTemp.add(bt2VO);
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FunctionVO> getFunctionsOfBilltype(String billtype) {
        HashMap<String, List<FunctionVO>> hashCacheObj;
        String realBilltype = billtype;
        if (PfUtilBaseTools.isTranstype(billtype)) {
            realBilltype = PfUtilBaseTools.getRealBilltype(billtype);
        }
        if ((hashCacheObj = (HashMap<String, List<FunctionVO>>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPETOFUNCTION")) == null) {
            Object object = MUTEX_BILLTYPETOFUNCTION;
            synchronized (object) {
                hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPETOFUNCTION");
                if (hashCacheObj == null) {
                    hashCacheObj = new HashMap<String, List<FunctionVO>>();
                    PfDataCache.setFunctionVOs(hashCacheObj, realBilltype);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPETOFUNCTION", hashCacheObj);
                }
            }
        }
        if (!hashCacheObj.containsKey(realBilltype)) {
            Object object = MUTEX_BILLTYPETOFUNCTION;
            synchronized (object) {
                if (!hashCacheObj.containsKey(realBilltype)) {
                    PfDataCache.setFunctionVOs(hashCacheObj, realBilltype);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPETOFUNCTION", hashCacheObj);
                }
            }
        }
        return (ArrayList)hashCacheObj.get(realBilltype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FunctionVO> getFunctionsOfBilltypeOfPk_group(String billtype, String pk_group) {
        HashMap<String, List<FunctionVO>> hashCacheObj;
        String realBilltype = billtype;
        if (PfUtilBaseTools.isTranstype(billtype)) {
            realBilltype = PfUtilBaseTools.getRealBilltypeByGroup(pk_group, billtype);
        }
        if ((hashCacheObj = (HashMap<String, List<FunctionVO>>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPETOFUNCTION")) == null) {
            Object object = MUTEX_BILLTYPETOFUNCTION;
            synchronized (object) {
                hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPETOFUNCTION");
                if (hashCacheObj == null) {
                    hashCacheObj = new HashMap<String, List<FunctionVO>>();
                    PfDataCache.setFunctionVOs(hashCacheObj, realBilltype);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPETOFUNCTION", hashCacheObj);
                }
            }
        }
        if (!hashCacheObj.containsKey(realBilltype)) {
            Object object = MUTEX_BILLTYPETOFUNCTION;
            synchronized (object) {
                if (!hashCacheObj.containsKey(realBilltype)) {
                    PfDataCache.setFunctionVOs(hashCacheObj, realBilltype);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPETOFUNCTION", hashCacheObj);
                }
            }
        }
        return (ArrayList)hashCacheObj.get(realBilltype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FunctionVO> getFunctionsOfBilltype(String billtype, String pk_group) {
        HashMap<String, List<FunctionVO>> hashCacheObj;
        String realBilltype = billtype;
        if (PfUtilBaseTools.isTranstype(billtype, pk_group)) {
            realBilltype = PfUtilBaseTools.getRealBilltypeByGroup(pk_group, billtype);
        }
        if ((hashCacheObj = (HashMap<String, List<FunctionVO>>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPETOFUNCTION")) == null) {
            Object object = MUTEX_BILLTYPETOFUNCTION;
            synchronized (object) {
                hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPETOFUNCTION");
                if (hashCacheObj == null) {
                    hashCacheObj = new HashMap<String, List<FunctionVO>>();
                    PfDataCache.setFunctionVOs(hashCacheObj, realBilltype);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPETOFUNCTION", hashCacheObj);
                }
            }
        }
        if (!hashCacheObj.containsKey(realBilltype)) {
            Object object = MUTEX_BILLTYPETOFUNCTION;
            synchronized (object) {
                if (!hashCacheObj.containsKey(realBilltype)) {
                    PfDataCache.setFunctionVOs(hashCacheObj, realBilltype);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPETOFUNCTION", hashCacheObj);
                }
            }
        }
        return (ArrayList)hashCacheObj.get(realBilltype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<WorkflowgadgetVO> getWorkflowGadget(String billType) {
        HashMap<String, ArrayList<WorkflowgadgetVO>> hashCacheObj;
        block11: {
            hashCacheObj = null;
            try {
                hashCacheObj = (HashMap<String, ArrayList<WorkflowgadgetVO>>)PfDataCache.getVersionSensitiveCache().get((Object)"WORKFLOWGADGETINFO");
                if (hashCacheObj == null) {
                    Object object = MUTEX_WORKFLOWGADGETINFO;
                    synchronized (object) {
                        hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"WORKFLOWGADGETINFO");
                        if (hashCacheObj == null) {
                            hashCacheObj = new HashMap<String, ArrayList<WorkflowgadgetVO>>();
                            PfDataCache.setWorkflowgadgetVOs(hashCacheObj, billType);
                            PfDataCache.getVersionSensitiveCache().put((Object)"WORKFLOWGADGETINFO", hashCacheObj);
                        }
                        break block11;
                    }
                }
                if (hashCacheObj.containsKey(billType)) break block11;
                Object object = MUTEX_WORKFLOWGADGETINFO;
                synchronized (object) {
                    if (!hashCacheObj.containsKey(billType)) {
                        PfDataCache.setWorkflowgadgetVOs(hashCacheObj, billType);
                    }
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return (ArrayList)hashCacheObj.get(billType);
    }

    private static void setWorkflowgadgetVOs(HashMap<String, ArrayList<WorkflowgadgetVO>> hasWorkflowgadgetInfo, String billtype) throws BusinessException {
        try {
            WorkflowgadgetVO[] gadgetVOs = ((IWFModuleService)NCLocator.getInstance().lookup(IWFModuleService.class)).queryGadgets(billtype);
            if (gadgetVOs == null) {
                gadgetVOs = new WorkflowgadgetVO[]{};
            }
            ArrayList<WorkflowgadgetVO> alRet = new ArrayList<WorkflowgadgetVO>();
            for (WorkflowgadgetVO gadgetVO : gadgetVOs) {
                alRet.add(gadgetVO);
            }
            hasWorkflowgadgetInfo.put(billtype, alRet);
        }
        catch (BusinessException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static BasicWorkflowProcess getWorkflowProcess(String defPK) throws XPDLParserException, BusinessException {
        return WorkflowProcessCache.getInstance().getWorkflowProcess(defPK);
    }

    public static void synchronizeWorkflowProcess(String processInstancePK, WorkflowProcess wp) {
        WorkflowProcessCache.getInstance().synchronizeWorkflowProcess(processInstancePK, wp);
    }

    public static BilltypeVO getBillTypeInfo(String billtype) {
        return PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(billtype).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId()));
    }

    public static BilltypeVO getBillTypeInfo(String pkGroup, String billtype) {
        return PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(billtype).buildPkGroup(pkGroup));
    }

    public static BilltypeVO getBillType(String billType) {
        return PfDataCache.getBillTypeInfo(billType);
    }

    public static void removeBillType(String billType) {
        BillTypeCacheKey cacheKey = new BillTypeCacheKey().buildBilltype(billType).buildPkGroup(InvocationInfoProxy.getInstance().getGroupId());
        if (cacheKey == null || StringUtil.isEmptyWithTrim((String)billType)) {
            return;
        }
        HashMap hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPEINFO");
        if (hashCacheObj == null || !hashCacheObj.containsKey(cacheKey.getKey()) || !hashCacheObj.containsKey(cacheKey.getBilltype())) {
            return;
        }
        hashCacheObj.remove(cacheKey.getKey());
        hashCacheObj.remove(cacheKey.getBilltype());
        PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPEINFO", (Object)hashCacheObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BilltypeVO getBillTypeInfo(BillTypeCacheKey cacheKey) {
        BilltypeVO pbt;
        String strBt;
        HashMap<String, BilltypeVO> keyVOMap;
        block19: {
            if (cacheKey == null || StringUtil.isEmptyWithTrim((String)cacheKey.getBilltype())) {
                return new BilltypeVO();
            }
            keyVOMap = (HashMap<String, BilltypeVO>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPEINFO");
            try {
                Object object;
                if (keyVOMap == null) {
                    object = MUTEX_BILLTYPEINFO;
                    synchronized (object) {
                        keyVOMap = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPEINFO");
                        if (keyVOMap == null) {
                            keyVOMap = new HashMap<String, BilltypeVO>();
                            PfDataCache.setBilltypeVOs(keyVOMap);
                            PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPEINFO", keyVOMap);
                        }
                    }
                }
                if (!keyVOMap.containsKey(cacheKey.getKey()) && !keyVOMap.containsKey(cacheKey.getBilltype())) {
                    object = MUTEX_BILLTYPEINFO;
                    synchronized (object) {
                        if (!keyVOMap.containsKey(cacheKey.getKey()) && !keyVOMap.containsKey(cacheKey.getBilltype())) {
                            PfDataCache.setSingleBilltypeVOs(keyVOMap, cacheKey.getKey(), cacheKey.getBilltype());
                            PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPEINFO", keyVOMap);
                        }
                        break block19;
                    }
                }
                if (keyVOMap.get(cacheKey.getKey()) != null || keyVOMap.get(cacheKey.getBilltype()) != null) break block19;
                object = MUTEX_BILLTYPEINFO;
                synchronized (object) {
                    if (keyVOMap.get(cacheKey.getKey()) == null && keyVOMap.get(cacheKey.getBilltype()) == null) {
                        PfDataCache.setSingleBilltypeVOs(keyVOMap, cacheKey.getKey(), cacheKey.getBilltype());
                        PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPEINFO", keyVOMap);
                    }
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        BilltypeVO btVO = (BilltypeVO)keyVOMap.get(cacheKey.getKey());
        if (btVO == null) {
            btVO = (BilltypeVO)keyVOMap.get(cacheKey.getBilltype());
        }
        if (btVO != null && UFBoolean.TRUE.equals((Object)btVO.getIstransaction()) && !StringUtil.isEmptyWithTrim((String)(strBt = btVO.getParentbilltype())) && (pbt = PfDataCache.getBillTypeInfo(new BillTypeCacheKey().buildBilltype(strBt))) != null && !StringUtil.isEmptyWithTrim((String)pbt.getPk_billtypecode())) {
            PfDataCache.copySomeFieldsToTranstype(btVO, pbt);
        }
        return btVO;
    }

    private static void copySomeFieldsToTranstype(BilltypeVO transtypeVO, BilltypeVO pbt) {
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getAccountclass())) {
            transtypeVO.setAccountclass(pbt.getAccountclass());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getCheckclassname())) {
            transtypeVO.setCheckclassname(pbt.getCheckclassname());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getDatafinderclz())) {
            transtypeVO.setDatafinderclz(pbt.getDatafinderclz());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getComponent())) {
            transtypeVO.setComponent(pbt.getComponent());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getDef1())) {
            transtypeVO.setDef1(pbt.getDef1());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getDef2())) {
            transtypeVO.setDef2(pbt.getDef2());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getDef3())) {
            transtypeVO.setDef3(pbt.getDef3());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getForwardbilltype())) {
            transtypeVO.setForwardbilltype(pbt.getForwardbilltype());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getReferclassname())) {
            transtypeVO.setReferclassname(pbt.getReferclassname());
        }
        if (StringUtil.isEmptyWithTrim((String)transtypeVO.getWherestring())) {
            transtypeVO.setWherestring(pbt.getWherestring());
        }
    }

    public static BilltypeVO getBillType(BillTypeCacheKey billType) {
        return PfDataCache.getBillTypeInfo(billType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, BilltypeVO> getBilltypes() {
        HashMap<String, BilltypeVO> hashCacheObj;
        block6: {
            hashCacheObj = (HashMap<String, BilltypeVO>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPEINFO");
            try {
                if (hashCacheObj != null) break block6;
                Object object = MUTEX_BILLTYPEINFO;
                synchronized (object) {
                    hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLTYPEINFO");
                    if (hashCacheObj == null) {
                        hashCacheObj = new HashMap<String, BilltypeVO>();
                        PfDataCache.setBilltypeVOs(hashCacheObj);
                        PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPEINFO", hashCacheObj);
                    }
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return hashCacheObj;
    }

    public static void clearBilltypeCache() {
        PfDataCache.getVersionSensitiveCache().put((Object)"BILLTYPEINFO", null);
    }

    private static void setSingleBillItfVOs(HashMap<String, BillItfDefVO[]> map, BillItfDefVO defVO) throws BusinessException {
        BillItfDefVO[] itfvos = ((IPFBillItfDef)NCLocator.getInstance().lookup(IPFBillItfDef.class)).getBillItfDef(defVO);
        if (itfvos != null && itfvos.length != 0) {
            map.put(PfDataCache.fetchBillitfMapKey(defVO), itfvos);
        }
    }

    private static void setSingleBilltypeVOs(HashMap<String, BilltypeVO> hasBillTypeInfo, String cacheKey, String billtype) throws BusinessException {
        String sql = "select " + BillTypeVOListProcessor.getFieldString().toLowerCase() + " from bd_billtype where pk_billtypecode=? and pk_group<>?";
        SQLParameter param = new SQLParameter();
        param.addParam(billtype);
        param.addParam("global00000000000000");
        Collection coBilltypes = (Collection)DBCacheQueryFacade.runQuery((String)sql, (SQLParameter)param, (ResultSetProcessor)new BillTypeVOListProcessor());
        if (ArrayUtil.isNotNull((Collection)coBilltypes) && ((BilltypeVO)coBilltypes.iterator().next()).getIstransaction().booleanValue()) {
            boolean qryFlag = true;
            for (BilltypeVO vo : coBilltypes) {
                if (StringUtil.compare((String)vo.getPk_group(), (String)InvocationInfoProxy.getInstance().getGroupId()) != 0) continue;
                qryFlag = false;
                break;
            }
            if (qryFlag) {
                String grpTransSql = "select " + BillTypeVOListProcessor.getFieldString().toLowerCase() + " from bd_billtype where pk_billtypecode=? and pk_group =?";
                param = new SQLParameter();
                param.addParam(billtype);
                param.addParam(InvocationInfoProxy.getInstance().getGroupId());
                Collection groupTrastype = (Collection)DBCacheQueryFacade.runQuery((String)grpTransSql, (SQLParameter)param, (ResultSetProcessor)new BillTypeVOListProcessor());
                coBilltypes.addAll(groupTrastype);
            }
        }
        if (coBilltypes != null && coBilltypes.size() != 0) {
            PfDataCache.fillMapWithBilltypeVOs(hasBillTypeInfo, coBilltypes);
        }
    }

    private static void fillMapWithBilltypeVOs(Map<String, BilltypeVO> map, Collection<BilltypeVO> col) {
        if (col == null || col.size() == 0) {
            return;
        }
        for (BilltypeVO bt : col) {
            String key = null;
            key = bt != null && UFBoolean.TRUE.equals((Object)bt.getIstransaction()) ? new BillTypeCacheKey().buildBilltype(bt.getPk_billtypecode()).buildPkGroup(bt.getPk_group()).getKey() : new BillTypeCacheKey().buildBilltype(bt.getPk_billtypecode()).getKey();
            map.put(key, bt);
        }
    }

    private static void setBillItfVOS(HashMap<String, BillItfDefVO[]> map) throws BusinessException {
        Collection coBillitf;
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        if (RuntimeEnv.getInstance().isRunningInServer()) {
            coBillitf = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveByClause(BillItfDefVO.class, "pk_group='" + pk_group + "'");
        } else {
            SQLParameter param = new SQLParameter();
            param.addParam(pk_group);
            String sql = "select * from pub_billitfdef where pk_group=?";
            coBillitf = (List)DBCacheQueryFacade.runQuery((String)sql, (SQLParameter)param, (ResultSetProcessor)new BeanListProcessor(BillItfDefVO.class));
        }
        HashMap temp = new HashMap();
        for (BillItfDefVO vo : coBillitf) {
            String key = PfDataCache.fetchBillitfMapKey(vo);
            if (temp.get(key) == null) {
                ArrayList defvos = new ArrayList();
                temp.put(key, defvos);
            }
            ((ArrayList)temp.get(key)).add(vo);
        }
        Set keys = temp.keySet();
        for (String key : keys) {
            map.put(key, ((ArrayList)temp.get(key)).toArray(new BillItfDefVO[0]));
        }
    }

    private static void setBilltypeVOs(HashMap<String, BilltypeVO> hasBillTypeInfo) throws BusinessException {
        String sql = "select " + BillTypeVOListProcessor.getFieldString().toLowerCase() + " from bd_billtype where pk_group<>?";
        SQLParameter param = new SQLParameter();
        param.addParam("global00000000000000");
        BillTypeVOListProcessor processor = new BillTypeVOListProcessor();
        Collection coBilltypes = RuntimeEnv.getInstance().isRunningInServer() ? (Collection)((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).executeQuery(sql, param, (ResultSetProcessor)processor) : (List)DBCacheQueryFacade.runQuery((String)sql, (SQLParameter)param, (ResultSetProcessor)processor);
        if (coBilltypes == null || coBilltypes.size() == 0) {
            return;
        }
        PfDataCache.fillMapWithBilltypeVOs(hasBillTypeInfo, coBilltypes);
    }

    public static List<BilltypeVO> getBillTypeAndTranstypesInGrp(String pk_group) {
        HashMap<String, BilltypeVO> hashCacheObj = PfDataCache.getBilltypes();
        if (hashCacheObj == null) {
            return null;
        }
        ArrayList<BilltypeVO> voarrs = new ArrayList<BilltypeVO>(hashCacheObj.values());
        if (voarrs == null || voarrs.size() == 0) {
            return null;
        }
        ArrayList<BilltypeVO> res = new ArrayList<BilltypeVO>();
        for (BilltypeVO vo : voarrs) {
            if (vo == null || (!UFBoolean.TRUE.equals((Object)vo.getIstransaction()) || !pk_group.equals(vo.getPk_group())) && vo.getIstransaction() != null && vo.getIstransaction().booleanValue()) continue;
            res.add(vo);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<BillactionVO> getBillactionVOs(String billtype) {
        Object object;
        HashMap hashCacheObj = null;
        hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLACTION");
        if (hashCacheObj == null) {
            object = MUTEX_BILLACTION;
            synchronized (object) {
                hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLACTION");
                if (hashCacheObj == null) {
                    hashCacheObj = new HashMap();
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLACTION", hashCacheObj);
                }
            }
        }
        if (!hashCacheObj.containsKey(billtype)) {
            object = MUTEX_BILLACTION;
            synchronized (object) {
                if (!hashCacheObj.containsKey(billtype)) {
                    try {
                        PfDataCache.setBillactionVOs(hashCacheObj, billtype);
                        PfDataCache.getVersionSensitiveCache().put((Object)"BILLACTION", hashCacheObj);
                    }
                    catch (BusinessException e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return (ArrayList)hashCacheObj.get(billtype);
    }

    public static Map<String, BillactionVO> getBillactionVOMap(String billtype) {
        ArrayList<BillactionVO> billActionList = PfDataCache.getBillactionVOs(billtype);
        if (billActionList != null && billActionList.size() > 0) {
            HashMap<String, BillactionVO> actionMap = new HashMap<String, BillactionVO>();
            for (BillactionVO billactionVO : billActionList) {
                actionMap.put(billactionVO.getActiontype(), billactionVO);
            }
            return actionMap;
        }
        if (PfUtilBaseTools.isTranstype(billtype)) {
            String realBilltype = PfUtilBaseTools.getRealBilltype(billtype);
            return PfDataCache.getBillactionVOMap(realBilltype);
        }
        return null;
    }

    private static void setBillactionVOs(HashMap hasBillaction, String billtype) throws BusinessException {
        Collection coRet;
        BilltypeVO vo = PfDataCache.getBillType(billtype);
        if (vo == null) {
            return;
        }
        String pk_billtypeid = vo.getPk_billtypeid();
        if (RuntimeEnv.getInstance().isRunningInServer()) {
            BaseDAO uapQry = new BaseDAO();
            BillactionVO condVO = new BillactionVO();
            condVO.setPk_billtypeid(pk_billtypeid);
            coRet = uapQry.retrieve((SuperVO)condVO, true);
            if (UFBoolean.TRUE.equals((Object)vo.getIstransaction()) && (coRet == null || coRet.size() == 0)) {
                BillactionVO condVO2 = new BillactionVO();
                condVO2.setPk_billtype(vo.getParentbilltype());
                coRet = uapQry.retrieve((SuperVO)condVO2, true);
            }
        } else {
            SQLParameter param = new SQLParameter();
            param.addParam(pk_billtypeid);
            coRet = (List)DBCacheQueryFacade.runQuery((String)"select * from pub_billaction where pk_billtypeid=?", (SQLParameter)param, (ResultSetProcessor)new BeanListProcessor(BillactionVO.class));
            if (UFBoolean.TRUE.equals((Object)vo.getIstransaction()) && (coRet == null || coRet.size() == 0)) {
                param.clearParams();
                param.addParam(vo.getParentbilltype());
                coRet = (List)DBCacheQueryFacade.runQuery((String)"select * from pub_billaction where pk_billtype=?", (SQLParameter)param, (ResultSetProcessor)new BeanListProcessor(BillactionVO.class));
            }
        }
        hasBillaction.put(billtype, coRet);
    }

    private static void setFunctionVOs(HashMap<String, List<FunctionVO>> hmBillToFunction, String billtype) {
        try {
            FunctionVO condVO = new FunctionVO();
            condVO.setPk_billtype(billtype);
            Collection coRet = ((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieve((SuperVO)condVO, true);
            ArrayList<FunctionVO> aryList = new ArrayList<FunctionVO>();
            for (FunctionVO functionVO : coRet) {
                aryList.add(functionVO);
            }
            hmBillToFunction.put(billtype, aryList);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap getDynamicOrgReg() {
        LinkedHashMap hmCacheObj;
        block7: {
            hmCacheObj = null;
            try {
                hmCacheObj = (LinkedHashMap)PfDataCache.getVersionSensitiveCache().get((Object)"DYNAMICORGINFO");
                if (hmCacheObj != null) break block7;
                Object object = MUTEX_DYNAMIC_ORG_REGINFO;
                synchronized (object) {
                    hmCacheObj = (LinkedHashMap)PfDataCache.getVersionSensitiveCache().get((Object)"DYNAMICORGINFO");
                    if (hmCacheObj == null) {
                        hmCacheObj = new LinkedHashMap();
                        IUAPQueryBS uapBS = (IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class.getName());
                        Collection co = uapBS.retrieveAll(DynamicOrgRegInfo.class);
                        for (DynamicOrgRegInfo reg : co) {
                            DynamicOrganizeUnitRegistry.register(reg.getOrgclass(), reg.getBuilderclass(), reg.getResolverclass(), hmCacheObj);
                        }
                        PfDataCache.getVersionSensitiveCache().put((Object)"DYNAMICORGINFO", hmCacheObj);
                    }
                }
            }
            catch (Exception ex) {
                Logger.warn((Object)("\u6ce8\u518c\u52a8\u6001\u7ec4\u7ec7\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u5c06\u65e0\u6cd5\u4f7f\u7528\u52a8\u6001\u7ec4\u7ec7=" + ex.getMessage()), (Throwable)ex);
            }
        }
        return hmCacheObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillTypeByStyle(String billStyle) {
        HashMap<String, String> hashCacheObj;
        block11: {
            hashCacheObj = null;
            try {
                hashCacheObj = (HashMap<String, String>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLSTYLETOTYPE");
                if (hashCacheObj == null) {
                    Object object = MUTEX_BILLSTYLETOTYPE;
                    synchronized (object) {
                        hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLSTYLETOTYPE");
                        if (hashCacheObj == null) {
                            hashCacheObj = new HashMap<String, String>();
                            PfDataCache.setBilltypeOfStyle(hashCacheObj);
                            PfDataCache.getVersionSensitiveCache().put((Object)"BILLSTYLETOTYPE", hashCacheObj);
                        }
                        break block11;
                    }
                }
                if (hashCacheObj.containsKey(billStyle)) break block11;
                Object object = MUTEX_BILLSTYLETOTYPE;
                synchronized (object) {
                    if (!hashCacheObj.containsKey(billStyle)) {
                        PfDataCache.setBilltypeOfStyle(hashCacheObj);
                        PfDataCache.getVersionSensitiveCache().put((Object)"BILLSTYLETOTYPE", hashCacheObj);
                    }
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return (String)hashCacheObj.get(billStyle);
    }

    private static void setBilltypeOfStyle(HashMap<String, String> hashCacheObj) {
        HashMap<String, BilltypeVO> hashPkToBilltype = PfDataCache.getBilltypes();
        Collection<BilltypeVO> coBilltypes = hashPkToBilltype.values();
        for (BilltypeVO billtype : coBilltypes) {
            if (billtype.getIsroot() == null || !billtype.getIsroot().booleanValue() || billtype.getBillstyle() == null) continue;
            hashCacheObj.put(billtype.getBillstyle().toString(), billtype.getPk_billtypecode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleVO getModuleVO(String systypeCode) {
        HashMap hashCacheObj;
        block6: {
            hashCacheObj = null;
            try {
                hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"SYSTEMTYPEINFO");
                if (hashCacheObj != null) break block6;
                Object object = MUTEX_SYSTEMTYPEINFO;
                synchronized (object) {
                    hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"SYSTEMTYPEINFO");
                    if (hashCacheObj == null) {
                        PfDataCache.getAllModules();
                        hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"SYSTEMTYPEINFO");
                    }
                }
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return (ModuleVO)hashCacheObj.get(systypeCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleVO[] getAllModules() {
        HashMap<String, ModuleVO> hashCacheObj = null;
        try {
            hashCacheObj = (HashMap<String, ModuleVO>)PfDataCache.getVersionSensitiveCache().get((Object)"SYSTEMTYPEINFO");
            if (hashCacheObj == null) {
                Object object = MUTEX_SYSTEMTYPEINFO;
                synchronized (object) {
                    hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"SYSTEMTYPEINFO");
                    if (hashCacheObj == null) {
                        hashCacheObj = new HashMap<String, ModuleVO>();
                        ModuleVO[] moduleVOs = ((IModuleQueryService)NCLocator.getInstance().lookup(IModuleQueryService.class)).getAllModules();
                        if (moduleVOs != null) {
                            for (ModuleVO moduleVO : moduleVOs) {
                                hashCacheObj.put(moduleVO.getSystypecode(), moduleVO);
                            }
                        }
                        PfDataCache.getVersionSensitiveCache().put((Object)"SYSTEMTYPEINFO", hashCacheObj);
                    }
                }
            }
            return hashCacheObj.values().toArray(new ModuleVO[0]);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BillItfDefVO[] getBillItfDef(BillItfDefVO defVO) throws BusinessException {
        Object object;
        HashMap<String, BillItfDefVO[]> hashCacheObj = null;
        hashCacheObj = (HashMap<String, BillItfDefVO[]>)PfDataCache.getVersionSensitiveCache().get((Object)"BILLITFDEF");
        String key = PfDataCache.fetchBillitfMapKey(defVO);
        if (hashCacheObj == null) {
            object = MUTEX_BILLITFDEF;
            synchronized (object) {
                hashCacheObj = (HashMap)PfDataCache.getVersionSensitiveCache().get((Object)"BILLITFDEF");
                if (hashCacheObj == null) {
                    hashCacheObj = new HashMap<String, BillItfDefVO[]>();
                    PfDataCache.setBillItfVOS(hashCacheObj);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLITFDEF", hashCacheObj);
                }
            }
        }
        if (PfDataCache.isFindDesTranByItf(defVO) || !hashCacheObj.containsKey(key)) {
            object = MUTEX_BILLITFDEF;
            synchronized (object) {
                if (PfDataCache.isFindDesTranByItf(defVO) || !hashCacheObj.containsKey(key)) {
                    PfDataCache.setSingleBillItfVOs(hashCacheObj, defVO);
                    PfDataCache.getVersionSensitiveCache().put((Object)"BILLITFDEF", hashCacheObj);
                }
            }
        }
        return (BillItfDefVO[])hashCacheObj.get(key);
    }

    private static boolean isFindDesTranByItf(BillItfDefVO defVO) {
        return false;
    }

    public static String fetchBillitfMapKey(BillItfDefVO defVO) {
        String key = "";
        String split = "$$";
        if (!StringUtil.isEmptyWithTrim((String)defVO.getSrc_billtype())) {
            key = key + defVO.getSrc_billtype() + split;
        }
        if (!StringUtil.isEmptyWithTrim((String)defVO.getSrc_transtype())) {
            key = key + defVO.getSrc_transtype() + split;
        }
        if (!StringUtil.isEmptyWithTrim((String)defVO.getDest_billtype())) {
            key = key + defVO.getDest_billtype() + split;
        }
        if (!StringUtil.isEmptyWithTrim((String)defVO.getPk_group())) {
            key = key + defVO.getPk_group() + split;
        }
        if (!StringUtil.isEmptyWithTrim((String)defVO.getPk_org())) {
            key = key + defVO.getPk_org() + split;
        }
        if (!StringUtil.isEmptyWithTrim((String)defVO.getPk_busitype())) {
            key = key + defVO.getPk_busitype() + split;
        }
        return key;
    }

    public static BillItfDefVO[] getBillItfDef(String srcBilltype, String srcTranstype, String destBilltype, String destTranstype, String pk_group) throws BusinessException {
        BillItfDefVO itfvo = new BillItfDefVO();
        itfvo.setSrc_billtype(srcBilltype);
        itfvo.setSrc_transtype(srcTranstype);
        itfvo.setDest_billtype(destBilltype);
        itfvo.setDest_transtype(destTranstype);
        itfvo.setPk_group(pk_group);
        return PfDataCache.getBillItfDef(itfvo);
    }

    public static BasicWorkflowProcess getWorkflowProcess(String defPK, String processInstPK) throws XPDLParserException, BusinessException {
        return WorkflowProcessCache.getInstance().getWorkflowProcess(defPK, processInstPK);
    }

    public static String getBillTypeNameByCode(String billtypecode) {
        String sql = "select billtypename from bd_billtype where pk_billtypecode=? and ((pk_group=? and istransaction='Y') or isnull(istransaction,'N')='N')";
        SQLParameter para = new SQLParameter();
        para.addParam(billtypecode);
        para.addParam(InvocationInfoProxy.getInstance().getGroupId());
        return (String)DBCacheQueryFacade.runQuery((String)sql, (SQLParameter)para, (ResultSetProcessor)new ColumnProcessor());
    }

    public static ArrayList<PubActorFilter> getPubActorFilters() {
        try {
            ArrayList filterList = (ArrayList)((IUAPQueryBS)NCLocator.getInstance().lookup(IUAPQueryBS.class)).retrieveAll(PubActorFilter.class);
            return filterList;
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

