/*
 * Decompiled with CFR 0.152.
 */
package nc.bs.pf.change;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.bs.pf.change.BillSplitter;
import nc.bs.pf.change.SplitHelpVO;
import nc.md.data.access.NCObject;
import nc.vo.pf.change.SplitItemVO;
import nc.vo.pf.util.ListUtil;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.lang.UFDate;
import nc.vo.pubapp.pattern.pub.MapList;
import nc.vo.pubapp.pattern.pub.MapSet;
import nc.vo.pubapp.pattern.pub.PubAppTool;
import nc.vo.trade.pub.IExAggVO;

public class BillSplitHelper {
    private static String getCurrTableCode(AggregatedValueObject origVO) {
        if (!(origVO instanceof IExAggVO)) {
            return null;
        }
        IExAggVO exAggVO = (IExAggVO)origVO;
        String[] tableCodes = exAggVO.getTableCodes();
        if (tableCodes == null || tableCodes.length == 0) {
            return null;
        }
        for (String tableCode : tableCodes) {
            CircularlyAccessibleValueObject[] childrenVO = exAggVO.getTableVO(tableCode);
            if (childrenVO == null) continue;
            return tableCode;
        }
        return null;
    }

    private static void setChildrenOfVO(AggregatedValueObject origVO, CircularlyAccessibleValueObject[] childrenVO) {
        String currTableCode = BillSplitHelper.getCurrTableCode(origVO);
        if (currTableCode == null) {
            origVO.setChildrenVO(childrenVO);
            return;
        }
        ((IExAggVO)origVO).setTableVO(currTableCode, childrenVO);
    }

    static CircularlyAccessibleValueObject[] getChildrenOfVO(AggregatedValueObject origVO) {
        String currTableCode = BillSplitHelper.getCurrTableCode(origVO);
        if (currTableCode == null) {
            return origVO.getChildrenVO();
        }
        return ((IExAggVO)origVO).getTableVO(currTableCode);
    }

    public AggregatedValueObject[] splitBill(AggregatedValueObject[] origVOs) {
        if (origVOs == null || origVOs.length == 0) {
            return origVOs;
        }
        if (!this.canBeSplitted(origVOs)) {
            return origVOs;
        }
        new TimeSpaceInfoProcessor().parseTimeSpaceInfo(origVOs);
        Class<?> aggClazz = origVOs[0].getClass();
        try {
            Hashtable<String, SplitHelpVO> map = new Hashtable<String, SplitHelpVO>();
            Class<?> bodyClazz = null;
            int insIdx = 0;
            for (AggregatedValueObject origVO : origVOs) {
                CircularlyAccessibleValueObject headVO = origVO.getParentVO();
                CircularlyAccessibleValueObject[] childrenVO = BillSplitHelper.getChildrenOfVO(origVO);
                String headUniqueKeyValue = (String)headVO.getAttributeValue("splitkeyvalue");
                if (childrenVO != null && childrenVO.length > 0) {
                    if (bodyClazz == null) {
                        bodyClazz = childrenVO[0].getClass();
                    }
                } else {
                    SplitHelpVO helpVO = new SplitHelpVO();
                    helpVO.setHeader((CircularlyAccessibleValueObject)headVO.clone());
                    String uniqueKeyValue = headUniqueKeyValue + "***##########***" + insIdx++ + "***##########***";
                    map.put(uniqueKeyValue, helpVO);
                    continue;
                }
                for (CircularlyAccessibleValueObject childVO : childrenVO) {
                    SplitHelpVO helpVO;
                    String bodyUniqueKeyValue = (String)childVO.getAttributeValue("splitkeyvalue");
                    String uniqueKeyValue = headUniqueKeyValue + bodyUniqueKeyValue;
                    if (headUniqueKeyValue == null && bodyUniqueKeyValue == null) {
                        return origVOs;
                    }
                    if (map.containsKey(uniqueKeyValue)) {
                        helpVO = (SplitHelpVO)map.get(uniqueKeyValue);
                        this.combineHead(headVO, helpVO.getHeader());
                        helpVO.getBodies().add(childVO);
                        continue;
                    }
                    helpVO = new SplitHelpVO();
                    helpVO.setHeader((CircularlyAccessibleValueObject)headVO.clone());
                    ArrayList<CircularlyAccessibleValueObject> bodies = new ArrayList<CircularlyAccessibleValueObject>();
                    bodies.add(childVO);
                    helpVO.setBodies(bodies);
                    map.put(uniqueKeyValue, helpVO);
                }
            }
            return this.constructAggVO(map, aggClazz, bodyClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AggregatedValueObject[] splitLastBill(AggregatedValueObject[] origVOs, ArrayList<SplitItemVO> alSplitVO) {
        if (origVOs == null || origVOs.length == 0) {
            return origVOs;
        }
        if (!(origVOs[0] instanceof IExAggVO)) {
            return origVOs;
        }
        if (!this.canBeSplitted(origVOs)) {
            return origVOs;
        }
        new TimeSpaceInfoProcessor().parseTimeSpaceInfo(origVOs);
        Class<?> aggClazz = origVOs[0].getClass();
        try {
            Hashtable<String, SplitHelpVO> map = new Hashtable<String, SplitHelpVO>();
            Class<?> bodyClazz = null;
            int insIdx = 0;
            MapList otherTableData = new MapList();
            MapSet otherTableDatasrcid = new MapSet();
            for (AggregatedValueObject origVO : origVOs) {
                int n;
                if (!(origVO instanceof IExAggVO)) continue;
                CircularlyAccessibleValueObject headVO = origVO.getParentVO();
                String[] allTableCodes = ((IExAggVO)origVO).getTableCodes();
                if (null == allTableCodes || allTableCodes.length < 1) continue;
                String currentTableCode = new BillSplitter().findTableCode(allTableCodes, alSplitVO);
                if (null == ((IExAggVO)origVO).getTableVO(currentTableCode)) {
                    for (String string : allTableCodes) {
                        if (null == ((IExAggVO)origVO).getTableVO(string)) continue;
                        currentTableCode = string;
                        break;
                    }
                }
                String[] otherTableCodes = new BillSplitter().getAllOtherTableCodes(allTableCodes, currentTableCode);
                CircularlyAccessibleValueObject[] childrenVO = null;
                childrenVO = !PubAppTool.isNull((String)currentTableCode) ? ((IExAggVO)origVO).getTableVO(currentTableCode) : origVO.getChildrenVO();
                String headUniqueKeyValue = (String)headVO.getAttributeValue("splitkeyvalue");
                if (childrenVO != null && childrenVO.length > 0) {
                    if (bodyClazz == null) {
                        bodyClazz = childrenVO[0].getClass();
                    }
                } else {
                    String[] stringArray = allTableCodes;
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String tablecode = stringArray[n];
                        childrenVO = ((IExAggVO)origVO).getTableVO(tablecode);
                        if (null == childrenVO) continue;
                        bodyClazz = childrenVO.getClass();
                        break;
                    }
                    SplitHelpVO splitHelpVO = new SplitHelpVO();
                    splitHelpVO.setHeader((CircularlyAccessibleValueObject)headVO.clone());
                    String uniqueKeyValue = headUniqueKeyValue + "***##########***" + insIdx++ + "***##########***";
                    map.put(uniqueKeyValue, splitHelpVO);
                    continue;
                }
                if (null == childrenVO) continue;
                CircularlyAccessibleValueObject[] circularlyAccessibleValueObjectArray = childrenVO;
                int uniqueKeyValue = circularlyAccessibleValueObjectArray.length;
                for (n = 0; n < uniqueKeyValue; ++n) {
                    CircularlyAccessibleValueObject[] bvos;
                    Set srcids;
                    CircularlyAccessibleValueObject childVO = circularlyAccessibleValueObjectArray[n];
                    String bodyUniqueKeyValue = (String)childVO.getAttributeValue("splitkeyvalue");
                    String srcid = (String)childVO.getAttributeValue("csrcid");
                    String uniqueKeyValue2 = headUniqueKeyValue + bodyUniqueKeyValue;
                    if (headUniqueKeyValue == null && bodyUniqueKeyValue == null) {
                        return origVOs;
                    }
                    if (map.containsKey(uniqueKeyValue2)) {
                        for (String otherTabelCode : otherTableCodes) {
                            srcids = otherTableDatasrcid.get((Object)(otherTabelCode + uniqueKeyValue2));
                            if (otherTableData.containsKey((Object)(otherTabelCode + uniqueKeyValue2)) && null != srcids && srcids.contains(srcid)) continue;
                            otherTableDatasrcid.put((Object)(otherTabelCode + uniqueKeyValue2), (Object)srcid);
                            bvos = ((IExAggVO)origVO).getTableVO(otherTabelCode);
                            if (null == bvos) continue;
                            for (CircularlyAccessibleValueObject bvo : bvos) {
                                otherTableData.put((Object)(otherTabelCode + uniqueKeyValue2), (Object)bvo);
                            }
                        }
                        SplitHelpVO helpVO2 = (SplitHelpVO)map.get(uniqueKeyValue2);
                        this.combineHead(headVO, helpVO2.getHeader());
                        helpVO2.getBodies().add(childVO);
                        continue;
                    }
                    for (String otherTabelCode : otherTableCodes) {
                        srcids = otherTableDatasrcid.get((Object)(otherTabelCode + uniqueKeyValue2));
                        if (otherTableData.containsKey((Object)(otherTabelCode + uniqueKeyValue2)) && null != srcids && srcids.contains(srcid)) continue;
                        otherTableDatasrcid.put((Object)(otherTabelCode + uniqueKeyValue2), (Object)srcid);
                        bvos = ((IExAggVO)origVO).getTableVO(otherTabelCode);
                        if (null == bvos) continue;
                        for (CircularlyAccessibleValueObject bvo : bvos) {
                            otherTableData.put((Object)(otherTabelCode + uniqueKeyValue2), (Object)bvo);
                        }
                    }
                    SplitHelpVO helpVO = new SplitHelpVO();
                    helpVO.setHeader((CircularlyAccessibleValueObject)headVO.clone());
                    ArrayList<CircularlyAccessibleValueObject> bodies = new ArrayList<CircularlyAccessibleValueObject>();
                    bodies.add(childVO);
                    helpVO.setBodies(bodies);
                    map.put(uniqueKeyValue2, helpVO);
                }
            }
            AggregatedValueObject[] destAggvos = this.constructAggVO(map, aggClazz, bodyClazz);
            if (otherTableData.size() > 0) {
                for (AggregatedValueObject origVO : destAggvos) {
                    MapList orthtablevos = new MapList();
                    MapSet orthtableunitids = new MapSet();
                    CircularlyAccessibleValueObject headVO = origVO.getParentVO();
                    String[] allTableCodes = ((IExAggVO)origVO).getTableCodes();
                    String currentTableCode = new BillSplitter().findTableCode(allTableCodes, alSplitVO);
                    if (null == ((IExAggVO)origVO).getTableVO(currentTableCode)) {
                        for (String tabcode : allTableCodes) {
                            if (null == ((IExAggVO)origVO).getTableVO(tabcode)) continue;
                            currentTableCode = tabcode;
                            break;
                        }
                    }
                    String[] stringArray = new BillSplitter().getAllOtherTableCodes(allTableCodes, currentTableCode);
                    CircularlyAccessibleValueObject[] childrenVO = null;
                    childrenVO = !PubAppTool.isNull((String)currentTableCode) ? ((IExAggVO)origVO).getTableVO(currentTableCode) : origVO.getChildrenVO();
                    String headUniqueKeyValue = (String)headVO.getAttributeValue("splitkeyvalue");
                    if (childrenVO != null && childrenVO.length > 0) {
                        if (bodyClazz == null) {
                            bodyClazz = childrenVO[0].getClass();
                        }
                    } else {
                        SplitHelpVO helpVO = new SplitHelpVO();
                        helpVO.setHeader((CircularlyAccessibleValueObject)headVO.clone());
                        String uniqueKeyValue = headUniqueKeyValue + "***##########***" + insIdx++ + "***##########***";
                        map.put(uniqueKeyValue, helpVO);
                        continue;
                    }
                    for (CircularlyAccessibleValueObject childVO : childrenVO) {
                        String bodyUniqueKeyValue = (String)childVO.getAttributeValue("splitkeyvalue");
                        String uniqueKeyValue = headUniqueKeyValue + bodyUniqueKeyValue;
                        for (String otherTableCode : stringArray) {
                            List bvos = otherTableData.get((Object)(otherTableCode + uniqueKeyValue));
                            if (null == bvos || null != orthtableunitids.get((Object)otherTableCode) && orthtableunitids.get((Object)otherTableCode).contains(otherTableCode + uniqueKeyValue)) continue;
                            orthtableunitids.put((Object)otherTableCode, (Object)(otherTableCode + uniqueKeyValue));
                            for (CircularlyAccessibleValueObject bvo : bvos) {
                                orthtablevos.put((Object)otherTableCode, (Object)bvo);
                            }
                        }
                    }
                    for (String otherTableCode : orthtablevos.keySet()) {
                        List orthtableChildrenVOs = orthtablevos.get((Object)otherTableCode);
                        ((IExAggVO)origVO).setTableVO(otherTableCode, (CircularlyAccessibleValueObject[])ListUtil.toArray(orthtableChildrenVOs));
                    }
                }
            }
            return destAggvos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean canBeSplitted(AggregatedValueObject[] origVOs) {
        if (!(origVOs[0] instanceof IExAggVO)) {
            return true;
        }
        if (origVOs[0] instanceof IExAggVO) {
            IExAggVO aggvo = (IExAggVO)origVOs[0];
            if (null == aggvo.getTableCodes()) {
                return true;
            }
            if (aggvo.getTableCodes().length > 1) {
                try {
                    Method method = aggvo.getClass().getDeclaredMethod("getTableCodes", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            } else if (aggvo.getTableCodes().length == 0) {
                return false;
            }
        }
        return true;
    }

    private void combineHead(CircularlyAccessibleValueObject origHeadVO, CircularlyAccessibleValueObject helpHeadVO) {
        String[] attrNames;
        for (String attrName : attrNames = origHeadVO.getAttributeNames()) {
            if (this.isEqual(origHeadVO.getAttributeValue(attrName), helpHeadVO.getAttributeValue(attrName))) continue;
            origHeadVO.setAttributeValue(attrName, null);
        }
    }

    private <B extends CircularlyAccessibleValueObject, G extends AggregatedValueObject> AggregatedValueObject[] constructAggVO(Map<String, SplitHelpVO> map, Class<G> aggClazz, Class<B> bodyClazz) throws Exception {
        ArrayList<AggregatedValueObject> list = new ArrayList<AggregatedValueObject>();
        Set<Map.Entry<String, SplitHelpVO>> entrySet = map.entrySet();
        for (Map.Entry<String, SplitHelpVO> entry : entrySet) {
            List<CircularlyAccessibleValueObject> helpBodies;
            SplitHelpVO helpVO = entry.getValue();
            AggregatedValueObject aggVO = (AggregatedValueObject)aggClazz.newInstance();
            aggVO.setParentVO(helpVO.getHeader());
            if (bodyClazz != null && (helpBodies = helpVO.getBodies()) != null && helpBodies.size() > 0) {
                CircularlyAccessibleValueObject[] childrenVO = (CircularlyAccessibleValueObject[])Array.newInstance(bodyClazz, helpVO.getBodies().size());
                BillSplitHelper.setChildrenOfVO(aggVO, helpVO.getBodies().toArray(childrenVO));
            }
            list.add(aggVO);
        }
        AggregatedValueObject[] aggVOs = (AggregatedValueObject[])Array.newInstance(aggClazz, list.size());
        return list.toArray(aggVOs);
    }

    private boolean hasMultiTableData(AggregatedValueObject[] aggVOs) {
        boolean flag = false;
        for (AggregatedValueObject aggVO : aggVOs) {
            if (!(aggVO instanceof IExAggVO) || !(flag = this.hasMultiTableData((IExAggVO)aggVO))) continue;
            return flag;
        }
        return flag;
    }

    private boolean hasMultiTableData(IExAggVO aggVO) {
        String tableCode;
        CircularlyAccessibleValueObject[] childrenVOs;
        String[] tableCodes = aggVO.getTableCodes();
        if (tableCodes == null) {
            return false;
        }
        int count = 0;
        String[] stringArray = tableCodes;
        int n = stringArray.length;
        for (int i = 0; i < n && ((childrenVOs = aggVO.getTableVO(tableCode = stringArray[i])) == null || ++count <= 1); ++i) {
        }
        return count > 1;
    }

    private boolean isEqual(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    private static class TimeSpaceInfoProcessor {
        TimeSpaceInfoProcessor() {
        }

        private void appendBodyTimeSpaceSign(AggregatedValueObject origVO, int sign, String timespaceToken) {
            CircularlyAccessibleValueObject[] childrenVO = BillSplitHelper.getChildrenOfVO(origVO);
            if (childrenVO == null) {
                return;
            }
            for (CircularlyAccessibleValueObject vo : childrenVO) {
                if (vo == null) continue;
                this.appendTimeSpaceSign(vo, sign, timespaceToken);
            }
        }

        private void appendHeadTimeSpaceSign(AggregatedValueObject origVO, int sign, String timespaceToken) {
            CircularlyAccessibleValueObject headVO = origVO.getParentVO();
            this.appendTimeSpaceSign(headVO, sign, timespaceToken);
        }

        private void appendTimeSpaceInfo(AggregatedValueObject[] origVOs, String timespaceToken) {
            String[] tokens = timespaceToken.split("=");
            String timespaceColumn = tokens[0];
            Integer timespace = Integer.valueOf(tokens[1]);
            UFDate minDate = this.getMinDate(origVOs, tokens[0]);
            for (AggregatedValueObject origVO : origVOs) {
                NCObject ncobj = NCObject.newInstance((Object)origVO);
                Object value = ncobj.getAttributeValue(timespaceColumn);
                if (value != null && value.getClass().isArray()) {
                    Object[] values;
                    for (Object v : values = (Object[])value) {
                        int sign = this.getTimeSpaceSign(v == null ? null : new UFDate(v.toString()), minDate, timespace, 1);
                        this.appendBodyTimeSpaceSign(origVO, sign, timespaceToken);
                    }
                    continue;
                }
                int sign = this.getTimeSpaceSign(value == null ? null : new UFDate(value.toString()), minDate, timespace, 1);
                this.appendHeadTimeSpaceSign(origVO, sign, timespaceToken);
            }
        }

        private void appendTimeSpaceInfo(AggregatedValueObject[] origVOs, String[] timespaceTokens) {
            for (String timespaceToken : timespaceTokens) {
                this.appendTimeSpaceInfo(origVOs, timespaceToken);
            }
        }

        private void appendTimeSpaceSign(CircularlyAccessibleValueObject vo, int sign, String timespaceToken) {
            String uniqueKey = (String)vo.getAttributeValue("splitkeyvalue");
            String newUniqueKey = uniqueKey + "#" + timespaceToken + "=" + sign;
            vo.setAttributeValue("splitkeyvalue", (Object)newUniqueKey);
        }

        private UFDate getMinDate(AggregatedValueObject[] origVOs, String timespaceColumn) {
            UFDate defaultMinDate;
            UFDate minDate = defaultMinDate = new UFDate(0L);
            for (AggregatedValueObject origVO : origVOs) {
                UFDate date;
                NCObject ncobj = NCObject.newInstance((Object)origVO);
                Object value = ncobj.getAttributeValue(timespaceColumn);
                if (value != null && value.getClass().isArray()) {
                    Object[] values = (Object[])value;
                    for (int i = 0; i < values.length; ++i) {
                        UFDate date2;
                        if (values[i] == null || !(date2 = new UFDate(values[i].toString())).before(minDate) && defaultMinDate.compareTo(minDate) != 0) continue;
                        minDate = date2;
                    }
                    continue;
                }
                if (value == null || !(date = new UFDate(value.toString())).before(minDate)) continue;
                minDate = date;
            }
            return minDate;
        }

        private int getTimeSpaceSign(UFDate date, UFDate minDate, Integer timespace, int beginSign) {
            if (date == null) {
                return 0;
            }
            UFDate maxDate = minDate.getDateAfter(timespace - 1);
            if (date.compareTo(minDate) >= 0 && date.compareTo(maxDate) <= 0) {
                return beginSign;
            }
            return this.getTimeSpaceSign(date, maxDate.getDateAfter(1), timespace, beginSign + 1);
        }

        void parseTimeSpaceInfo(AggregatedValueObject[] origVOs) {
            if (origVOs == null || origVOs.length == 0) {
                return;
            }
            CircularlyAccessibleValueObject headVO = origVOs[0].getParentVO();
            String headUniqueKey = (String)headVO.getAttributeValue("splitkeyvalue");
            if (headUniqueKey == null) {
                return;
            }
            String[] strs = headUniqueKey.split("_timespace_");
            if (strs.length != 2) {
                return;
            }
            String timespaceInfo = strs[1];
            String[] timespaceTokens = timespaceInfo.split("#");
            this.appendTimeSpaceInfo(origVOs, timespaceTokens);
        }
    }
}

